/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.alibabacloudsearch.response;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingFloatResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.response.AlibabaCloudSearchResponseEntity;

public class AlibabaCloudSearchEmbeddingsResponseEntity
extends AlibabaCloudSearchResponseEntity {
    private static final String FAILED_TO_FIND_FIELD_TEMPLATE = "Failed to find required field [%s] in AlibabaCloud Search embeddings response";

    public static TextEmbeddingFloatResults fromResponse(Request request, HttpResult response) throws IOException {
        return (TextEmbeddingFloatResults)AlibabaCloudSearchEmbeddingsResponseEntity.fromResponse(request, response, parser -> {
            XContentUtils.positionParserAtTokenAfterField(parser, "embeddings", FAILED_TO_FIND_FIELD_TEMPLATE);
            List embeddingList = XContentParserUtils.parseList((XContentParser)parser, AlibabaCloudSearchEmbeddingsResponseEntity::parseEmbeddingObject);
            return new TextEmbeddingFloatResults(embeddingList);
        });
    }

    private static TextEmbeddingFloatResults.Embedding parseEmbeddingObject(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        XContentUtils.positionParserAtTokenAfterField(parser, "embedding", FAILED_TO_FIND_FIELD_TEMPLATE);
        List embeddingValues = XContentParserUtils.parseList((XContentParser)parser, AlibabaCloudSearchEmbeddingsResponseEntity::parseEmbeddingList);
        parser.nextToken();
        parser.skipChildren();
        return TextEmbeddingFloatResults.Embedding.of((List)embeddingValues);
    }

    private static float parseEmbeddingList(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
        return parser.floatValue();
    }

    private AlibabaCloudSearchEmbeddingsResponseEntity() {
    }
}

