/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.InMemoryClonedSecureSettings;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.ssl.SslSettingsLoader;
import org.elasticsearch.xpack.security.support.ReloadableSecurityComponent;
import org.elasticsearch.xpack.security.transport.CrossClusterApiKeySignatureManager;
import org.elasticsearch.xpack.security.transport.CrossClusterApiKeySigningSettings;

public final class CrossClusterApiKeySigningConfigReloader
implements ReloadableSecurityComponent {
    private static final Logger logger = LogManager.getLogger(CrossClusterApiKeySigningConfigReloader.class);
    private final Map<Path, ChangeListener> signingConfigPathsToChangeListener = new ConcurrentHashMap<Path, ChangeListener>();
    private final ResourceWatcherService resourceWatcherService;
    private final AtomicReference<Settings> trustSettings = new AtomicReference();
    private final Map<String, Settings> signingSettingsByClusterAlias = new ConcurrentHashMap<String, Settings>();
    private final PlainActionFuture<CrossClusterApiKeySignatureManager> apiKeySignatureManagerFuture = new PlainActionFuture<CrossClusterApiKeySignatureManager>(this){

        protected boolean blockingAllowed() {
            return true;
        }
    };

    public CrossClusterApiKeySigningConfigReloader(Environment environment, ResourceWatcherService resourceWatcherService, ClusterSettings clusterSettings) {
        this.resourceWatcherService = resourceWatcherService;
        this.initTrustConfig(clusterSettings, environment);
        this.initSigningConfig(clusterSettings, environment);
    }

    public void setSigningConfigLoader(CrossClusterApiKeySignatureManager apiKeySignatureManager) {
        assert (!this.apiKeySignatureManagerFuture.isDone()) : "apiKeySignatureManager already set";
        this.apiKeySignatureManagerFuture.onResponse((Object)apiKeySignatureManager);
    }

    private void initTrustConfig(ClusterSettings clusterSettings, Environment environment) {
        Settings allRemoteClusterSettings = environment.settings().getByPrefix("cluster.remote.");
        this.trustSettings.set(allRemoteClusterSettings.getByPrefix("signing."));
        SslConfiguration sslSettingsLoader = SslSettingsLoader.load((Settings)allRemoteClusterSettings, (String)"signing.", (Environment)environment);
        this.watchDependentFiles(new HashSet<Path>(sslSettingsLoader.getDependentFiles()));
        clusterSettings.addSettingsUpdateConsumer(val -> {
            this.reloadConsumer(val.getByPrefix("cluster.remote."), false);
            logger.info("Updated trust configuration due to updated cluster settings");
        }, CrossClusterApiKeySigningSettings.getDynamicTrustSettings(), val -> this.validateUpdate(val.getByPrefix("cluster.remote.")));
    }

    private void initSigningConfig(ClusterSettings clusterSettings, Environment environment) {
        Map clusterSettingsByClusterAlias = environment.settings().getGroups("cluster.remote.", true);
        clusterSettingsByClusterAlias.forEach((clusterAlias, settingsForCluster) -> {
            SslConfiguration sslSettingsLoader = SslSettingsLoader.load((Settings)settingsForCluster, (String)"signing.", (Environment)environment);
            this.signingSettingsByClusterAlias.put((String)clusterAlias, (Settings)settingsForCluster);
            this.watchDependentFiles((String)clusterAlias, (Set<Path>)new HashSet<Path>(sslSettingsLoader.getDependentFiles()));
        });
        clusterSettings.addAffixGroupUpdateConsumer(CrossClusterApiKeySigningSettings.getDynamicSigningSettings(), (key, val) -> {
            this.reloadConsumer((String)key, val.getByPrefix("cluster.remote." + key + "."), false);
            logger.info("Updated signing configuration for [{}] due to updated cluster settings", key);
        }, (key, val) -> this.validateUpdate(val.getByPrefix("cluster.remote." + key + ".")));
    }

    private void validateUpdate(Settings settings) {
        try {
            CrossClusterApiKeySignatureManager apiKeySignatureManager = (CrossClusterApiKeySignatureManager)this.apiKeySignatureManagerFuture.get();
            apiKeySignatureManager.validate(settings);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new ElasticsearchException("Failed to obtain crossClusterApiKeySigner", (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            logger.debug(Strings.format((String)"Failed to update signing settings [%s] due validation error [%s]", (Object[])new Object[]{settings, e}));
            throw e;
        }
    }

    private void reloadConsumer(@Nullable Settings settings, boolean updateSecureSettings) {
        this.reloadConsumer(null, settings, updateSecureSettings);
    }

    private void reloadConsumer(@Nullable String clusterAlias, @Nullable Settings settings, boolean updateSecureSettings) {
        try {
            CrossClusterApiKeySignatureManager apiKeySignatureManager = (CrossClusterApiKeySignatureManager)this.apiKeySignatureManagerFuture.get();
            if (clusterAlias == null) {
                this.trustSettings.updateAndGet(currentSettings -> this.reloadAndWatch(apiKeySignatureManager, (Settings)currentSettings, settings, updateSecureSettings));
            } else {
                this.signingSettingsByClusterAlias.compute(clusterAlias, (alias, currentSettings) -> this.reloadAndWatch((String)alias, apiKeySignatureManager, (Settings)currentSettings, settings, updateSecureSettings));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new ElasticsearchException("Failed to obtain apiKeySignatureManager", (Throwable)e, new Object[0]);
        }
    }

    private Settings reloadAndWatch(CrossClusterApiKeySignatureManager signatureManager, Settings currentSettings, Settings newSettings, boolean updateSecureSettings) {
        return this.reloadAndWatch(null, signatureManager, currentSettings, newSettings, updateSecureSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Settings reloadAndWatch(@Nullable String clusterAlias, CrossClusterApiKeySignatureManager signatureManager, Settings currentSettings, Settings newSettings, boolean updateSecureSettings) {
        Collection<Path> configFiles;
        Settings effectiveSettings = this.buildEffectiveSettings(currentSettings, newSettings, updateSecureSettings);
        try {
            if (clusterAlias == null) {
                signatureManager.reload(effectiveSettings);
            } else {
                signatureManager.reload(clusterAlias, effectiveSettings);
            }
            configFiles = clusterAlias == null ? signatureManager.getDependentTrustFiles() : signatureManager.getDependentSigningFiles(clusterAlias);
        }
        catch (IllegalStateException e) {
            Collection<Path> configFiles2;
            try {
                logger.error(Strings.format((String)"Failed to load trust config", (Object[])new Object[0]), (Throwable)e);
                configFiles2 = clusterAlias == null ? signatureManager.getDependentTrustFiles() : signatureManager.getDependentSigningFiles(clusterAlias);
            }
            catch (Throwable throwable) {
                Collection<Path> configFiles3 = clusterAlias == null ? signatureManager.getDependentTrustFiles() : signatureManager.getDependentSigningFiles(clusterAlias);
                this.watchDependentFiles(clusterAlias, new HashSet<Path>(configFiles3));
                throw throwable;
            }
            this.watchDependentFiles(clusterAlias, new HashSet<Path>(configFiles2));
        }
        this.watchDependentFiles(clusterAlias, new HashSet<Path>(configFiles));
        return effectiveSettings;
    }

    private void watchDependentFiles(Set<Path> filesToMonitor) {
        this.watchDependentFiles(null, filesToMonitor);
    }

    private void watchDependentFiles(@Nullable String clusterAlias, Set<Path> filesToMonitor) {
        filesToMonitor.forEach(path -> this.signingConfigPathsToChangeListener.compute((Path)path, (monitoredPath, existingChangeListener) -> {
            ChangeListener changeListener = existingChangeListener != null ? existingChangeListener : new ChangeListener((Path)path);
            changeListener.addChangeCallback(new ChangeCallback(clusterAlias, () -> this.reloadConsumer(clusterAlias, null, false)));
            FileWatcher fileWatcher = new FileWatcher(path);
            fileWatcher.addListener((Object)changeListener);
            try {
                this.resourceWatcherService.add((ResourceWatcher)fileWatcher, ResourceWatcherService.Frequency.HIGH);
                return changeListener;
            }
            catch (IOException | SecurityException e) {
                logger.error(Strings.format((String)"failed to start watching file [%s]", (Object[])new Object[]{path}), (Throwable)e);
                return changeListener;
            }
        }));
    }

    private Settings buildEffectiveSettings(@Nullable Settings currentSettings, @Nullable Settings newSettings, boolean updateSecureSettings) {
        if (currentSettings == null) {
            return newSettings == null ? Settings.EMPTY : newSettings;
        }
        if (newSettings == null) {
            return currentSettings;
        }
        if (newSettings.isEmpty()) {
            return Settings.EMPTY;
        }
        Settings secureSettingsSource = updateSecureSettings ? newSettings : currentSettings;
        Settings settingsSource = updateSecureSettings ? currentSettings : newSettings;
        SecureSettings secureSettings = Settings.builder().put(secureSettingsSource, true).getSecureSettings();
        Settings.Builder builder = Settings.builder().put(settingsSource, false);
        if (secureSettings != null) {
            builder.setSecureSettings(secureSettings);
        }
        return builder.build();
    }

    @Override
    public void reload(Settings settings) {
        try {
            Settings cachedSettings = Settings.builder().setSecureSettings(InMemoryClonedSecureSettings.cloneSecureSettings((Settings)settings, CrossClusterApiKeySigningSettings.getSecureSettings())).build();
            cachedSettings.getGroups("cluster.remote.", true).forEach((clusterAlias, settingsForCluster) -> {
                if (!settingsForCluster.getByPrefix("signing").isEmpty()) {
                    this.reloadConsumer((String)clusterAlias, (Settings)settingsForCluster, true);
                    logger.info("Updated signing configuration for [{}] due to reload of secure settings", clusterAlias);
                }
            });
            if (!cachedSettings.getByPrefix("cluster.remote.signing.").isEmpty()) {
                this.reloadConsumer(cachedSettings.getByPrefix("cluster.remote."), true);
                logger.info("Updated trust configuration for cluster due to reload of secure settings");
            }
        }
        catch (GeneralSecurityException e) {
            logger.error("Keystore exception while reloading signing configuration after reload of secure settings", (Throwable)e);
        }
    }

    private record ChangeListener(Path file, List<ChangeCallback> changeCallbacks) implements FileChangesListener
    {
        ChangeListener(Path file) {
            this(file, new ArrayList<ChangeCallback>());
        }

        public void addChangeCallback(ChangeCallback changeCallback) {
            if (this.changeCallbacks.stream().anyMatch(existingChangeCallback -> Objects.equals(existingChangeCallback.clusterAlias, changeCallback.clusterAlias))) {
                return;
            }
            this.changeCallbacks.add(changeCallback);
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            if (this.file.equals(file)) {
                this.changeCallbacks.forEach(callback -> callback.callback.run());
                logger.info("Updated signing configuration due to update of file [{}]", (Object)file);
            }
        }
    }

    private record ChangeCallback(@Nullable String clusterAlias, Runnable callback) {
    }
}

