/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.elasticsearch.watcher.FileWatcher;

public class PrivilegedFileWatcher
extends FileWatcher {
    public PrivilegedFileWatcher(Path path) {
        super(path);
    }

    public PrivilegedFileWatcher(Path path, boolean checkFileContents) {
        super(path, checkFileContents);
    }

    protected InputStream newInputStream(Path path) throws IOException {
        return Files.newInputStream(path, new OpenOption[0]);
    }

    protected boolean fileExists(Path path) {
        return AccessController.doPrivileged(() -> Files.exists(path, new LinkOption[0]));
    }

    protected BasicFileAttributes readAttributes(Path path) throws IOException {
        try {
            return AccessController.doPrivileged(() -> Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]));
        }
        catch (PrivilegedActionException e) {
            throw new IOException(e);
        }
    }

    protected DirectoryStream<Path> listFiles(Path path) throws IOException {
        try {
            return AccessController.doPrivileged(() -> Files.newDirectoryStream(path));
        }
        catch (PrivilegedActionException e) {
            throw new IOException(e);
        }
    }
}

