/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.assignment;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class AdaptiveAllocationsSettings
implements ToXContentObject,
Writeable {
    public static final AdaptiveAllocationsSettings RESET_PLACEHOLDER = new AdaptiveAllocationsSettings(false, -1, -1);
    public static final ParseField ENABLED = new ParseField("enabled", new String[0]);
    public static final ParseField MIN_NUMBER_OF_ALLOCATIONS = new ParseField("min_number_of_allocations", new String[0]);
    public static final ParseField MAX_NUMBER_OF_ALLOCATIONS = new ParseField("max_number_of_allocations", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("autoscaling_settings", Builder::new);
    private final Boolean enabled;
    private final Integer minNumberOfAllocations;
    private final Integer maxNumberOfAllocations;

    public static AdaptiveAllocationsSettings parseRequest(XContentParser parser) {
        return ((Builder)PARSER.apply(parser, null)).build();
    }

    public AdaptiveAllocationsSettings(Boolean enabled, Integer minNumberOfAllocations, Integer maxNumberOfAllocations) {
        this.enabled = enabled;
        this.minNumberOfAllocations = minNumberOfAllocations;
        this.maxNumberOfAllocations = maxNumberOfAllocations;
    }

    public AdaptiveAllocationsSettings(StreamInput in) throws IOException {
        this.enabled = in.readOptionalBoolean();
        this.minNumberOfAllocations = in.readOptionalInt();
        this.maxNumberOfAllocations = in.readOptionalInt();
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Integer getMinNumberOfAllocations() {
        return this.minNumberOfAllocations;
    }

    public Integer getMaxNumberOfAllocations() {
        return this.maxNumberOfAllocations;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ENABLED.getPreferredName(), this.enabled != null ? this.enabled : false);
        if (this.minNumberOfAllocations != null) {
            builder.field(MIN_NUMBER_OF_ALLOCATIONS.getPreferredName(), this.minNumberOfAllocations);
        }
        if (this.maxNumberOfAllocations != null) {
            builder.field(MAX_NUMBER_OF_ALLOCATIONS.getPreferredName(), this.maxNumberOfAllocations);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalBoolean(this.enabled);
        out.writeOptionalInt(this.minNumberOfAllocations);
        out.writeOptionalInt(this.maxNumberOfAllocations);
    }

    public AdaptiveAllocationsSettings merge(AdaptiveAllocationsSettings updates) {
        Builder builder = new Builder(this);
        if (updates.getEnabled() != null) {
            builder.setEnabled(updates.enabled);
        }
        if (updates.minNumberOfAllocations != null) {
            if (updates.minNumberOfAllocations == -1) {
                builder.setMinNumberOfAllocations(null);
            } else {
                builder.setMinNumberOfAllocations(updates.minNumberOfAllocations);
            }
        }
        if (updates.maxNumberOfAllocations != null) {
            if (updates.maxNumberOfAllocations == -1) {
                builder.setMaxNumberOfAllocations(null);
            } else {
                builder.setMaxNumberOfAllocations(updates.maxNumberOfAllocations);
            }
        }
        return builder.build();
    }

    public ActionRequestValidationException validate() {
        boolean hasMaxNumberOfAllocations;
        boolean hasMinNumberOfAllocations;
        ActionRequestValidationException validationException = new ActionRequestValidationException();
        boolean bl = hasMinNumberOfAllocations = this.minNumberOfAllocations != null && this.minNumberOfAllocations != -1;
        if (hasMinNumberOfAllocations && this.minNumberOfAllocations < 0) {
            validationException.addValidationError("[" + String.valueOf(MIN_NUMBER_OF_ALLOCATIONS) + "] must be a non-negative integer or null");
        }
        boolean bl2 = hasMaxNumberOfAllocations = this.maxNumberOfAllocations != null && this.maxNumberOfAllocations != -1;
        if (hasMaxNumberOfAllocations && this.maxNumberOfAllocations < 1) {
            validationException.addValidationError("[" + String.valueOf(MAX_NUMBER_OF_ALLOCATIONS) + "] must be a positive integer or null");
        }
        if (hasMinNumberOfAllocations && hasMaxNumberOfAllocations && this.minNumberOfAllocations > this.maxNumberOfAllocations) {
            validationException.addValidationError("[" + String.valueOf(MIN_NUMBER_OF_ALLOCATIONS) + "] must not be larger than [" + String.valueOf(MAX_NUMBER_OF_ALLOCATIONS) + "]");
        }
        return validationException.validationErrors().isEmpty() ? null : validationException;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdaptiveAllocationsSettings that = (AdaptiveAllocationsSettings)o;
        return Objects.equals(this.enabled, that.enabled) && Objects.equals(this.minNumberOfAllocations, that.minNumberOfAllocations) && Objects.equals(this.maxNumberOfAllocations, that.maxNumberOfAllocations);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.minNumberOfAllocations, this.maxNumberOfAllocations);
    }

    static {
        PARSER.declareBoolean(Builder::setEnabled, ENABLED);
        PARSER.declareIntOrNull(Builder::setMinNumberOfAllocations, -1, MIN_NUMBER_OF_ALLOCATIONS);
        PARSER.declareIntOrNull(Builder::setMaxNumberOfAllocations, -1, MAX_NUMBER_OF_ALLOCATIONS);
    }

    public static class Builder {
        private Boolean enabled;
        private Integer minNumberOfAllocations;
        private Integer maxNumberOfAllocations;

        public Builder() {
        }

        public Builder(AdaptiveAllocationsSettings settings) {
            this.enabled = settings.enabled;
            this.minNumberOfAllocations = settings.minNumberOfAllocations;
            this.maxNumberOfAllocations = settings.maxNumberOfAllocations;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public void setMinNumberOfAllocations(Integer minNumberOfAllocations) {
            this.minNumberOfAllocations = minNumberOfAllocations;
        }

        public void setMaxNumberOfAllocations(Integer maxNumberOfAllocations) {
            this.maxNumberOfAllocations = maxNumberOfAllocations;
        }

        public AdaptiveAllocationsSettings build() {
            return new AdaptiveAllocationsSettings(this.enabled, this.minNumberOfAllocations, this.maxNumberOfAllocations);
        }
    }
}

