/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.gpu.codec;

import com.nvidia.cuvs.CagraIndex;
import com.nvidia.cuvs.CagraIndexParams;
import com.nvidia.cuvs.CuVSDeviceMatrix;
import com.nvidia.cuvs.CuVSHostMatrix;
import com.nvidia.cuvs.CuVSIvfPqParams;
import com.nvidia.cuvs.CuVSMatrix;
import com.nvidia.cuvs.CuVSResources;
import java.io.Closeable;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatFieldVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene95.HasIndexSlice;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsWriter;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.FilterIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.MemorySegmentAccessInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.hnsw.CloseableRandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.packed.DirectMonotonicWriter;
import org.apache.lucene.util.quantization.ScalarQuantizer;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.vectors.ES814ScalarQuantizedVectorsFormat;
import org.elasticsearch.index.codec.vectors.reflect.VectorsFormatReflectionUtils;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.gpu.GPUSupport;
import org.elasticsearch.xpack.gpu.codec.CuVSIvfPqParamsFactory;
import org.elasticsearch.xpack.gpu.codec.CuVSResourceManager;
import org.elasticsearch.xpack.gpu.codec.DatasetUtils;
import org.elasticsearch.xpack.gpu.codec.DatasetUtilsImpl;
import org.elasticsearch.xpack.gpu.codec.MergedQuantizedVectorValues;
import org.elasticsearch.xpack.gpu.codec.ResourcesHolder;

final class ES92GpuHnswVectorsWriter
extends KnnVectorsWriter {
    private static final Logger logger = LogManager.getLogger(ES92GpuHnswVectorsWriter.class);
    private static final long SHALLOW_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ES92GpuHnswVectorsWriter.class);
    private static final int LUCENE99_HNSW_DIRECT_MONOTONIC_BLOCK_SHIFT = 16;
    private static final long DIRECT_COPY_THRESHOLD_IN_BYTES = 0x8000000L;
    private static final long MAX_NUM_VECTORS_FOR_NN_DESCENT = 5000000L;
    private final CuVSResourceManager cuVSResourceManager;
    private final SegmentWriteState segmentWriteState;
    private final IndexOutput meta;
    private final IndexOutput vectorIndex;
    private final int M;
    private final int beamWidth;
    private final FlatVectorsWriter flatVectorWriter;
    private final List<FieldWriter> fields = new ArrayList<FieldWriter>();
    private boolean finished;
    private final CuVSMatrix.DataType dataType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ES92GpuHnswVectorsWriter(CuVSResourceManager cuVSResourceManager, SegmentWriteState state, int M, int beamWidth, FlatVectorsWriter flatVectorWriter) throws IOException {
        assert (cuVSResourceManager != null) : "CuVSResources must not be null";
        this.cuVSResourceManager = cuVSResourceManager;
        this.M = M;
        this.beamWidth = beamWidth;
        this.flatVectorWriter = flatVectorWriter;
        if (flatVectorWriter instanceof ES814ScalarQuantizedVectorsFormat.ES814ScalarQuantizedVectorsWriter) {
            this.dataType = CuVSMatrix.DataType.BYTE;
        } else {
            assert (flatVectorWriter instanceof Lucene99FlatVectorsWriter);
            this.dataType = CuVSMatrix.DataType.FLOAT;
        }
        this.segmentWriteState = state;
        String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"vem");
        String indexDataFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"vex");
        boolean success = false;
        try {
            this.meta = state.directory.createOutput(metaFileName, state.context);
            this.vectorIndex = state.directory.createOutput(indexDataFileName, state.context);
            CodecUtil.writeIndexHeader((DataOutput)this.meta, (String)"Lucene99HnswVectorsFormatMeta", (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            CodecUtil.writeIndexHeader((DataOutput)this.vectorIndex, (String)"Lucene99HnswVectorsFormatIndex", (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)((Object)this));
            }
        }
    }

    public KnnFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
        if (!fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            throw new IllegalArgumentException("Field [" + fieldInfo.name + "] must have FLOAT32 encoding, got: " + String.valueOf(fieldInfo.getVectorEncoding()));
        }
        FlatFieldVectorsWriter flatFieldWriter = this.flatVectorWriter.addField(fieldInfo);
        FieldWriter newField = new FieldWriter((FlatFieldVectorsWriter<float[]>)flatFieldWriter, fieldInfo);
        this.fields.add(newField);
        return newField;
    }

    public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        long started = System.nanoTime();
        this.flatVectorWriter.flush(maxDoc, sortMap);
        try {
            this.flushFieldsWithoutMemoryMappedFile(sortMap);
        }
        catch (Throwable t) {
            throw new IOException("Failed to flush GPU index: ", t);
        }
        long elapsed = System.nanoTime() - started;
        logger.debug("Flush total time [{}ms]", new Object[]{(double)elapsed / 1000000.0});
    }

    private void flushFieldsWithoutMemoryMappedFile(Sorter.DocMap sortMap) throws IOException, InterruptedException {
        for (FieldWriter field : this.fields) {
            long started = System.nanoTime();
            FieldInfo fieldInfo = field.fieldInfo;
            List<float[]> originalVectors = field.flatFieldVectorsWriter.getVectors();
            List<float[]> vectorsInSortedOrder = sortMap == null ? originalVectors : this.getVectorsInSortedOrder(field, sortMap, originalVectors);
            int numVectors = vectorsInSortedOrder.size();
            CagraIndexParams cagraIndexParams = this.createCagraIndexParams(fieldInfo.getVectorSimilarityFunction(), numVectors, fieldInfo.getVectorDimension());
            if (numVectors < 2) {
                logger.debug("Skip building carga index; vectors length {} < {} (min for GPU)", new Object[]{numVectors, 2});
                this.generateMockGraphAndWriteMeta(fieldInfo, numVectors);
            } else {
                try (ResourcesHolder resourcesHolder = new ResourcesHolder(this.cuVSResourceManager, this.cuVSResourceManager.acquire(numVectors, fieldInfo.getVectorDimension(), CuVSMatrix.DataType.FLOAT, cagraIndexParams));){
                    CuVSMatrix.Builder builder = CuVSMatrix.deviceBuilder((CuVSResources)resourcesHolder.resources(), (long)numVectors, (long)fieldInfo.getVectorDimension(), (CuVSMatrix.DataType)CuVSMatrix.DataType.FLOAT);
                    for (float[] vector : vectorsInSortedOrder) {
                        builder.addVector(vector);
                    }
                    try (CuVSDeviceMatrix dataset = (CuVSDeviceMatrix)builder.build();){
                        this.generateGpuGraphAndWriteMeta(resourcesHolder, fieldInfo, (CuVSMatrix)dataset, cagraIndexParams);
                    }
                }
            }
            long elapsed = System.nanoTime() - started;
            logger.debug("Flushed [{}] vectors in [{}ms]", new Object[]{numVectors, (double)elapsed / 1000000.0});
        }
    }

    private List<float[]> getVectorsInSortedOrder(FieldWriter field, Sorter.DocMap sortMap, List<float[]> originalVectors) throws IOException {
        DocsWithFieldSet docsWithField = field.getDocsWithFieldSet();
        int[] ordMap = new int[docsWithField.cardinality()];
        DocsWithFieldSet newDocsWithField = new DocsWithFieldSet();
        KnnVectorsWriter.mapOldOrdToNewOrd((DocsWithFieldSet)docsWithField, (Sorter.DocMap)sortMap, null, (int[])ordMap, (DocsWithFieldSet)newDocsWithField);
        ArrayList<float[]> vectorsInSortedOrder = new ArrayList<float[]>(ordMap.length);
        for (int oldOrd : ordMap) {
            vectorsInSortedOrder.add(originalVectors.get(oldOrd));
        }
        return vectorsInSortedOrder;
    }

    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        this.flatVectorWriter.finish();
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.writeFooter((IndexOutput)this.meta);
        }
        if (this.vectorIndex != null) {
            CodecUtil.writeFooter((IndexOutput)this.vectorIndex);
        }
    }

    public long ramBytesUsed() {
        long total = SHALLOW_RAM_BYTES_USED;
        for (FieldWriter field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    private void generateGpuGraphAndWriteMeta(ResourcesHolder resourcesHolder, FieldInfo fieldInfo, CuVSMatrix dataset, CagraIndexParams cagraIndexParams) throws IOException {
        try {
            HnswGraph graph;
            int[][] graphLevelNodeOffsets;
            long vectorIndexOffset;
            block18: {
                assert (dataset.size() >= 2L);
                vectorIndexOffset = this.vectorIndex.getFilePointer();
                graphLevelNodeOffsets = new int[1][];
                try (CagraIndex index = this.buildGPUIndex(resourcesHolder.resources(), cagraIndexParams, dataset);){
                    assert (index != null) : "GPU index should be built for field: " + fieldInfo.name;
                    CuVSDeviceMatrix deviceGraph = index.getGraph();
                    long graphSize = deviceGraph.size() * deviceGraph.columns() * 4L;
                    if (graphSize < 0x8000000L) {
                        try (CuVSHostMatrix hostGraph = deviceGraph.toHost();){
                            resourcesHolder.close();
                            graph = this.writeGraph((CuVSMatrix)hostGraph, graphLevelNodeOffsets);
                            break block18;
                        }
                    }
                    graph = this.writeGraph((CuVSMatrix)deviceGraph, graphLevelNodeOffsets);
                }
            }
            long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
            this.writeMeta(fieldInfo, vectorIndexOffset, vectorIndexLength, (int)dataset.size(), graph, graphLevelNodeOffsets);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Failed to write GPU index: ", t);
        }
    }

    private void generateMockGraphAndWriteMeta(FieldInfo fieldInfo, int datasetSize) throws IOException {
        try {
            long vectorIndexOffset = this.vectorIndex.getFilePointer();
            int[][] graphLevelNodeOffsets = new int[1][];
            HnswGraph graph = this.writeMockGraph(datasetSize, graphLevelNodeOffsets);
            long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
            this.writeMeta(fieldInfo, vectorIndexOffset, vectorIndexLength, datasetSize, graph, graphLevelNodeOffsets);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Failed to write GPU index: ", t);
        }
    }

    private CagraIndex buildGPUIndex(CuVSResourceManager.ManagedCuVSResources cuVSResources, CagraIndexParams cagraIndexParams, CuVSMatrix dataset) throws Throwable {
        long startTime = System.nanoTime();
        CagraIndex.Builder indexBuilder = CagraIndex.newBuilder((CuVSResources)cuVSResources).withDataset(dataset).withIndexParams(cagraIndexParams);
        CagraIndex index = indexBuilder.build();
        this.cuVSResourceManager.finishedComputation(cuVSResources);
        if (logger.isDebugEnabled()) {
            logger.debug("Carga index created in: {} ms; #num vectors: {}", new Object[]{(double)(System.nanoTime() - startTime) / 1000000.0, dataset.size()});
        }
        return index;
    }

    private CagraIndexParams createCagraIndexParams(VectorSimilarityFunction similarityFunction, int numVectors, int dims) {
        CagraIndexParams params;
        long requiredMemoryForNnDescent;
        long totalDeviceMemory;
        CagraIndexParams.CuvsDistanceType distanceType = switch (similarityFunction) {
            default -> throw new MatchException(null, null);
            case VectorSimilarityFunction.COSINE -> CagraIndexParams.CuvsDistanceType.CosineExpanded;
            case VectorSimilarityFunction.EUCLIDEAN -> CagraIndexParams.CuvsDistanceType.L2Expanded;
            case VectorSimilarityFunction.DOT_PRODUCT -> {
                if (this.dataType == CuVSMatrix.DataType.BYTE) {
                    yield CagraIndexParams.CuvsDistanceType.CosineExpanded;
                }
                yield CagraIndexParams.CuvsDistanceType.InnerProduct;
            }
            case VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT -> {
                if (!$assertionsDisabled && this.dataType == CuVSMatrix.DataType.BYTE) {
                    throw new AssertionError();
                }
                yield CagraIndexParams.CuvsDistanceType.InnerProduct;
            }
        };
        int numCPUThreads = 1;
        boolean useIvfPQ = false;
        if (distanceType != CagraIndexParams.CuvsDistanceType.CosineExpanded && (long)numVectors >= 5000000L) {
            useIvfPQ = true;
        }
        if (!useIvfPQ && distanceType != CagraIndexParams.CuvsDistanceType.CosineExpanded && (totalDeviceMemory = GPUSupport.getTotalGpuMemory()) > 0L && (requiredMemoryForNnDescent = CuVSResourceManager.estimateNNDescentMemory(numVectors, dims, this.dataType)) > totalDeviceMemory) {
            useIvfPQ = true;
            logger.debug("Using IVF_PQ algorithm due to insufficient GPU memory for NN_DESCENT; required [{}B] > total [{}B]", new Object[]{requiredMemoryForNnDescent, totalDeviceMemory});
        }
        if (useIvfPQ) {
            CuVSIvfPqParams ivfPqParams = CuVSIvfPqParamsFactory.create(numVectors, dims, distanceType, this.beamWidth);
            params = new CagraIndexParams.Builder().withNumWriterThreads(numCPUThreads).withCagraGraphBuildAlgo(CagraIndexParams.CagraGraphBuildAlgo.IVF_PQ).withCuVSIvfPqParams(ivfPqParams).withMetric(distanceType).build();
        } else {
            params = new CagraIndexParams.Builder().withNumWriterThreads(numCPUThreads).withCagraGraphBuildAlgo(CagraIndexParams.CagraGraphBuildAlgo.NN_DESCENT).withGraphDegree(this.M).withIntermediateGraphDegree(this.beamWidth).withNNDescentNumIterations(5).withMetric(distanceType).build();
        }
        return params;
    }

    private HnswGraph writeGraph(CuVSMatrix cagraGraph, int[][] levelNodeOffsets) throws IOException {
        long startTime = System.nanoTime();
        int maxElementCount = (int)cagraGraph.size();
        int maxGraphDegree = (int)cagraGraph.columns();
        int[] neighbors = new int[maxGraphDegree];
        levelNodeOffsets[0] = new int[maxElementCount];
        int[] scratch = new int[maxGraphDegree];
        for (int node = 0; node < maxElementCount; ++node) {
            cagraGraph.getRow((long)node).toArray(neighbors);
            long offsetStart = this.vectorIndex.getFilePointer();
            Arrays.sort(neighbors);
            int actualSize = 0;
            if (maxGraphDegree > 0) {
                scratch[0] = neighbors[0];
                actualSize = 1;
            }
            for (int i = 1; i < maxGraphDegree; ++i) {
                assert (neighbors[i] < maxElementCount) : "node too large: " + neighbors[i] + ">=" + maxElementCount;
                if (neighbors[i - 1] == neighbors[i]) continue;
                scratch[actualSize++] = neighbors[i] - neighbors[i - 1];
            }
            this.vectorIndex.writeVInt(actualSize);
            this.vectorIndex.writeGroupVInts(scratch, actualSize);
            levelNodeOffsets[0][node] = Math.toIntExact(this.vectorIndex.getFilePointer() - offsetStart);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("cagra_hnws index serialized to Lucene HNSW in: {} ms", new Object[]{(double)(System.nanoTime() - startTime) / 1000000.0});
        }
        return ES92GpuHnswVectorsWriter.createMockGraph(maxElementCount, maxGraphDegree);
    }

    private HnswGraph writeMockGraph(int elementCount, int[][] levelNodeOffsets) throws IOException {
        if (elementCount == 0) {
            return null;
        }
        int nodeDegree = elementCount - 1;
        levelNodeOffsets[0] = new int[elementCount];
        int[] neighbors = new int[nodeDegree];
        int[] scratch = new int[nodeDegree];
        for (int node = 0; node < elementCount; ++node) {
            if (nodeDegree > 0) {
                for (int j = 0; j < nodeDegree; ++j) {
                    neighbors[j] = j < node ? j : j + 1;
                }
                scratch[0] = neighbors[0];
                for (int i = 1; i < nodeDegree; ++i) {
                    scratch[i] = neighbors[i] - neighbors[i - 1];
                }
            }
            long offsetStart = this.vectorIndex.getFilePointer();
            this.vectorIndex.writeVInt(nodeDegree);
            this.vectorIndex.writeGroupVInts(scratch, nodeDegree);
            levelNodeOffsets[0][node] = Math.toIntExact(this.vectorIndex.getFilePointer() - offsetStart);
        }
        return ES92GpuHnswVectorsWriter.createMockGraph(elementCount, nodeDegree);
    }

    private static HnswGraph createMockGraph(final int elementCount, final int graphDegree) {
        return new HnswGraph(){

            public int nextNeighbor() {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            public void seek(int level, int target) {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            public int size() {
                return elementCount;
            }

            public int numLevels() {
                return 1;
            }

            public int maxConn() {
                return graphDegree;
            }

            public int entryNode() {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            public int neighborCount() {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            public HnswGraph.NodesIterator getNodesOnLevel(int level) {
                return new HnswGraph.ArrayNodesIterator(this.size());
            }
        };
    }

    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        try (CloseableRandomVectorScorerSupplier scorerSupplier = this.flatVectorWriter.mergeOneFieldToIndex(fieldInfo, mergeState);){
            long started = System.nanoTime();
            int numVectors = scorerSupplier.totalVectorCount();
            if (numVectors < 2) {
                this.generateMockGraphAndWriteMeta(fieldInfo, numVectors);
            } else if (this.dataType == CuVSMatrix.DataType.FLOAT) {
                randomScorerSupplier = VectorsFormatReflectionUtils.getFlatRandomVectorScorerInnerSupplier((CloseableRandomVectorScorerSupplier)scorerSupplier);
                this.mergeFloatVectorField(fieldInfo, mergeState, randomScorerSupplier, numVectors);
            } else {
                assert (this.dataType == CuVSMatrix.DataType.BYTE);
                randomScorerSupplier = VectorsFormatReflectionUtils.getScalarQuantizedRandomVectorScorerInnerSupplier((CloseableRandomVectorScorerSupplier)scorerSupplier);
                this.mergeByteVectorField(fieldInfo, mergeState, randomScorerSupplier, numVectors);
            }
            long elapsed = System.nanoTime() - started;
            logger.debug("Merged [{}] vectors in [{}ms]", new Object[]{numVectors, (double)elapsed / 1000000.0});
        }
        catch (Throwable t) {
            throw new IOException("Failed to merge GPU index: ", t);
        }
    }

    private void mergeByteVectorField(FieldInfo fieldInfo, MergeState mergeState, RandomVectorScorerSupplier randomScorerSupplier, int numVectors) throws IOException, InterruptedException {
        block44: {
            HasIndexSlice vectorValues = randomScorerSupplier == null ? null : VectorsFormatReflectionUtils.getByteScoringSupplierVectorOrNull((RandomVectorScorerSupplier)randomScorerSupplier);
            CagraIndexParams cagraIndexParams = this.createCagraIndexParams(fieldInfo.getVectorSimilarityFunction(), numVectors, fieldInfo.getVectorDimension());
            if (vectorValues != null) {
                IndexInput slice = vectorValues.getSlice();
                IndexInput input = FilterIndexInput.unwrapOnlyTest((IndexInput)slice);
                if (input instanceof MemorySegmentAccessInput) {
                    MemorySegmentAccessInput memorySegmentAccessInput = (MemorySegmentAccessInput)input;
                    int sourceRowPitch = fieldInfo.getVectorDimension() + 4;
                    int packedRowSize = fieldInfo.getVectorDimension();
                    long packedVectorsDataSize = (long)numVectors * (long)packedRowSize;
                    try (Arena arena = Arena.ofConfined();){
                        MemorySegment packedSegment = arena.allocate(packedVectorsDataSize, 64L);
                        MemorySegment sourceSegment = memorySegmentAccessInput.segmentSliceOrNull(0L, memorySegmentAccessInput.length());
                        for (int i = 0; i < numVectors; ++i) {
                            MemorySegment.copy(sourceSegment, (long)i * (long)sourceRowPitch, packedSegment, (long)i * (long)packedRowSize, packedRowSize);
                        }
                        try (CuVSMatrix dataset = DatasetUtilsImpl.fromMemorySegment(packedSegment, numVectors, packedRowSize, this.dataType);
                             ResourcesHolder resourcesHolder = new ResourcesHolder(this.cuVSResourceManager, this.cuVSResourceManager.acquire(numVectors, fieldInfo.getVectorDimension(), this.dataType, cagraIndexParams));){
                            this.generateGpuGraphAndWriteMeta(resourcesHolder, fieldInfo, dataset, cagraIndexParams);
                            break block44;
                        }
                    }
                }
                logger.info(() -> "Cannot mmap merged raw vectors temporary file. IndexInput type [" + input.getClass().getSimpleName() + "]");
                CuVSMatrix.Builder builder = CuVSMatrix.hostBuilder((long)numVectors, (long)fieldInfo.getVectorDimension(), (CuVSMatrix.DataType)this.dataType);
                byte[] vector = new byte[fieldInfo.getVectorDimension()];
                for (int i = 0; i < numVectors; ++i) {
                    input.readBytes(vector, 0, fieldInfo.getVectorDimension());
                    builder.addVector(vector);
                }
                try (CuVSHostMatrix dataset = (CuVSHostMatrix)builder.build();
                     ResourcesHolder resourcesHolder = new ResourcesHolder(this.cuVSResourceManager, this.cuVSResourceManager.acquire(numVectors, fieldInfo.getVectorDimension(), this.dataType, cagraIndexParams));){
                    this.generateGpuGraphAndWriteMeta(resourcesHolder, fieldInfo, (CuVSMatrix)dataset, cagraIndexParams);
                    break block44;
                }
            }
            logger.warn("Cannot get merged raw vectors from scorer.");
            ByteVectorValues byteVectorValues = this.getMergedByteVectorValues(fieldInfo, mergeState);
            CuVSMatrix.Builder builder = CuVSMatrix.hostBuilder((long)numVectors, (long)fieldInfo.getVectorDimension(), (CuVSMatrix.DataType)this.dataType);
            KnnVectorValues.DocIndexIterator iterator = byteVectorValues.iterator();
            int docV = iterator.nextDoc();
            while (docV != Integer.MAX_VALUE) {
                builder.addVector(byteVectorValues.vectorValue(iterator.index()));
                docV = iterator.nextDoc();
            }
            try (CuVSHostMatrix dataset = (CuVSHostMatrix)builder.build();
                 ResourcesHolder resourcesHolder = new ResourcesHolder(this.cuVSResourceManager, this.cuVSResourceManager.acquire(numVectors, fieldInfo.getVectorDimension(), this.dataType, cagraIndexParams));){
                this.generateGpuGraphAndWriteMeta(resourcesHolder, fieldInfo, (CuVSMatrix)dataset, cagraIndexParams);
            }
        }
    }

    private void mergeFloatVectorField(FieldInfo fieldInfo, MergeState mergeState, RandomVectorScorerSupplier randomScorerSupplier, int numVectors) throws IOException, InterruptedException {
        block37: {
            HasIndexSlice vectorValues = randomScorerSupplier == null ? null : VectorsFormatReflectionUtils.getFloatScoringSupplierVectorOrNull((RandomVectorScorerSupplier)randomScorerSupplier);
            CagraIndexParams cagraIndexParams = this.createCagraIndexParams(fieldInfo.getVectorSimilarityFunction(), numVectors, fieldInfo.getVectorDimension());
            if (vectorValues != null) {
                IndexInput slice = vectorValues.getSlice();
                IndexInput input = FilterIndexInput.unwrapOnlyTest((IndexInput)slice);
                if (input instanceof MemorySegmentAccessInput) {
                    MemorySegmentAccessInput memorySegmentAccessInput = (MemorySegmentAccessInput)input;
                    try (CuVSMatrix dataset = DatasetUtils.getInstance().fromInput(memorySegmentAccessInput, numVectors, fieldInfo.getVectorDimension(), this.dataType);
                         ResourcesHolder resourcesHolder = new ResourcesHolder(this.cuVSResourceManager, this.cuVSResourceManager.acquire(numVectors, fieldInfo.getVectorDimension(), this.dataType, cagraIndexParams));){
                        this.generateGpuGraphAndWriteMeta(resourcesHolder, fieldInfo, dataset, cagraIndexParams);
                        break block37;
                    }
                }
                logger.info(() -> "Cannot mmap merged raw vectors temporary file. IndexInput type [" + input.getClass().getSimpleName() + "]");
                CuVSMatrix.Builder builder = CuVSMatrix.hostBuilder((long)numVectors, (long)fieldInfo.getVectorDimension(), (CuVSMatrix.DataType)this.dataType);
                float[] vector = new float[fieldInfo.getVectorDimension()];
                for (int i = 0; i < numVectors; ++i) {
                    input.readFloats(vector, 0, fieldInfo.getVectorDimension());
                    builder.addVector(vector);
                }
                try (CuVSHostMatrix dataset = (CuVSHostMatrix)builder.build();
                     ResourcesHolder resourcesHolder = new ResourcesHolder(this.cuVSResourceManager, this.cuVSResourceManager.acquire(numVectors, fieldInfo.getVectorDimension(), this.dataType, cagraIndexParams));){
                    this.generateGpuGraphAndWriteMeta(resourcesHolder, fieldInfo, (CuVSMatrix)dataset, cagraIndexParams);
                    break block37;
                }
            }
            logger.warn("Cannot get merged raw vectors from scorer.");
            FloatVectorValues floatVectorValues = KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues((FieldInfo)fieldInfo, (MergeState)mergeState);
            CuVSMatrix.Builder builder = CuVSMatrix.hostBuilder((long)numVectors, (long)fieldInfo.getVectorDimension(), (CuVSMatrix.DataType)this.dataType);
            KnnVectorValues.DocIndexIterator iterator = floatVectorValues.iterator();
            int docV = iterator.nextDoc();
            while (docV != Integer.MAX_VALUE) {
                float[] vector = floatVectorValues.vectorValue(iterator.index());
                builder.addVector(vector);
                docV = iterator.nextDoc();
            }
            try (CuVSHostMatrix dataset = (CuVSHostMatrix)builder.build();
                 ResourcesHolder resourcesHolder = new ResourcesHolder(this.cuVSResourceManager, this.cuVSResourceManager.acquire(numVectors, fieldInfo.getVectorDimension(), this.dataType, cagraIndexParams));){
                this.generateGpuGraphAndWriteMeta(resourcesHolder, fieldInfo, (CuVSMatrix)dataset, cagraIndexParams);
            }
        }
    }

    private ByteVectorValues getMergedByteVectorValues(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        int bits = 7;
        Float confidenceInterval = null;
        ScalarQuantizer quantizer = Lucene99ScalarQuantizedVectorsWriter.mergeAndRecalculateQuantiles((MergeState)mergeState, (FieldInfo)fieldInfo, confidenceInterval, (byte)7);
        return MergedQuantizedVectorValues.mergeQuantizedByteVectorValues(fieldInfo, mergeState, quantizer);
    }

    private void writeMeta(FieldInfo field, long vectorIndexOffset, long vectorIndexLength, int count, HnswGraph graph, int[][] graphLevelNodeOffsets) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeInt(field.getVectorEncoding().ordinal());
        this.meta.writeInt(ES92GpuHnswVectorsWriter.distFuncToOrd(field.getVectorSimilarityFunction()));
        this.meta.writeVLong(vectorIndexOffset);
        this.meta.writeVLong(vectorIndexLength);
        this.meta.writeVInt(field.getVectorDimension());
        this.meta.writeInt(count);
        if (graph == null) {
            this.meta.writeVInt(this.M);
            this.meta.writeVInt(0);
        } else {
            this.meta.writeVInt(graph.maxConn());
            this.meta.writeVInt(graph.numLevels());
            long valueCount = 0L;
            for (int level = 0; level < graph.numLevels(); ++level) {
                HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
                valueCount += (long)nodesOnLevel.size();
                if (level > 0) {
                    int[] nol = new int[nodesOnLevel.size()];
                    int numberConsumed = nodesOnLevel.consume(nol);
                    Arrays.sort(nol);
                    assert (numberConsumed == nodesOnLevel.size());
                    this.meta.writeVInt(nol.length);
                    for (int i = nodesOnLevel.size() - 1; i > 0; --i) {
                        int n = i;
                        nol[n] = nol[n] - nol[i - 1];
                    }
                    for (int n : nol) {
                        assert (n >= 0) : "delta encoding for nodes failed; expected nodes to be sorted";
                        this.meta.writeVInt(n);
                    }
                    continue;
                }
                assert (nodesOnLevel.size() == count) : "Level 0 expects to have all nodes";
            }
            long start = this.vectorIndex.getFilePointer();
            this.meta.writeLong(start);
            this.meta.writeVInt(16);
            DirectMonotonicWriter memoryOffsetsWriter = DirectMonotonicWriter.getInstance((IndexOutput)this.meta, (IndexOutput)this.vectorIndex, (long)valueCount, (int)16);
            long cumulativeOffsetSum = 0L;
            int[][] nArray = graphLevelNodeOffsets;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] levelOffsets;
                for (int v : levelOffsets = nArray[i]) {
                    memoryOffsetsWriter.add(cumulativeOffsetSum);
                    cumulativeOffsetSum += (long)v;
                }
            }
            memoryOffsetsWriter.finish();
            this.meta.writeLong(this.vectorIndex.getFilePointer() - start);
        }
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.meta, this.vectorIndex, this.flatVectorWriter});
    }

    static int distFuncToOrd(VectorSimilarityFunction func) {
        for (int i = 0; i < Lucene99HnswVectorsReader.SIMILARITY_FUNCTIONS.size(); ++i) {
            if (!((VectorSimilarityFunction)Lucene99HnswVectorsReader.SIMILARITY_FUNCTIONS.get(i)).equals((Object)func)) continue;
            return (byte)i;
        }
        throw new IllegalArgumentException("invalid distance function: " + String.valueOf(func));
    }

    private static class FieldWriter
    extends KnnFieldVectorsWriter<float[]> {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldWriter.class);
        private final FieldInfo fieldInfo;
        private int lastDocID = -1;
        private final FlatFieldVectorsWriter<float[]> flatFieldVectorsWriter;

        FieldWriter(FlatFieldVectorsWriter<float[]> flatFieldVectorsWriter, FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            this.flatFieldVectorsWriter = Objects.requireNonNull(flatFieldVectorsWriter);
        }

        public void addValue(int docID, float[] vectorValue) throws IOException {
            if (docID == this.lastDocID) {
                throw new IllegalArgumentException("VectorValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
            }
            this.flatFieldVectorsWriter.addValue(docID, (Object)vectorValue);
            this.lastDocID = docID;
        }

        public float[] copyValue(float[] vectorValue) {
            throw new UnsupportedOperationException();
        }

        public long ramBytesUsed() {
            return SHALLOW_SIZE + this.flatFieldVectorsWriter.ramBytesUsed();
        }

        public DocsWithFieldSet getDocsWithFieldSet() {
            return this.flatFieldVectorsWriter.getDocsWithFieldSet();
        }
    }
}

