/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import org.bouncycastle.crypto.asymmetric.DSAValidationParameters;
import org.bouncycastle.crypto.fips.DSAOutputSigner;
import org.bouncycastle.crypto.fips.DSAOutputVerifier;
import org.bouncycastle.crypto.fips.DsaKeyPairGenerator;
import org.bouncycastle.crypto.fips.DsaParametersGenerator;
import org.bouncycastle.crypto.fips.DsaSigner;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsOutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.fips.FipsOutputVerifier;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsSignatureOperatorFactory;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.NullDigest;
import org.bouncycastle.crypto.fips.PrivilegedUtils;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.EngineProvider;
import org.bouncycastle.crypto.internal.ExtendedDigest;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.crypto.internal.PrimeCertaintyCalculator;
import org.bouncycastle.crypto.internal.params.DsaKeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.DsaParameterGenerationParameters;
import org.bouncycastle.crypto.internal.params.DsaParameters;
import org.bouncycastle.crypto.internal.params.DsaPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DsaPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.DsaValidationParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;
import org.bouncycastle.math.internal.Primes;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.TestRandomBigInteger;

public final class FipsDSA {
    public static final FipsAlgorithm ALGORITHM = new FipsAlgorithm("DSA", null);
    public static final Parameters DSA = new Parameters();
    private static final EngineProvider<DsaSigner> ENGINE_PROVIDER;

    private FipsDSA() {
    }

    private static DsaParameters getDomainParams(DSADomainParameters dSADomainParameters) {
        return new DsaParameters(dSADomainParameters.getP(), dSADomainParameters.getQ(), dSADomainParameters.getG());
    }

    private static DsaPrivateKeyParameters getLwKey(final AsymmetricDSAPrivateKey asymmetricDSAPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<DsaPrivateKeyParameters>(){

            @Override
            public DsaPrivateKeyParameters run() {
                return new DsaPrivateKeyParameters(asymmetricDSAPrivateKey.getX(), FipsDSA.getDomainParams(asymmetricDSAPrivateKey.getDomainParameters()));
            }
        });
    }

    private static void validateKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        SelfTestExecutor.validate(ALGORITHM, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

            @Override
            public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                byte[] byArray = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");
                DsaSigner dsaSigner = new DsaSigner();
                dsaSigner.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), Utils.testRandom));
                BigInteger[] bigIntegerArray = dsaSigner.generateSignature(byArray);
                dsaSigner.init(false, asymmetricCipherKeyPair.getPublic());
                return dsaSigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
            }
        });
    }

    static {
        DsaProvider dsaProvider = new DsaProvider();
        dsaProvider.createEngine();
        ENGINE_PROVIDER = dsaProvider;
    }

    public static final class DomainGenParameters
    extends FipsParameters {
        private final int L;
        private final int N;
        private final int certainty;
        private final BigInteger p;
        private final BigInteger q;
        private final byte[] seed;
        private final int usageIndex;

        public DomainGenParameters(int n) {
            this(n, n > 1024 ? 256 : 160, PrimeCertaintyCalculator.getDefaultCertainty(n));
        }

        public DomainGenParameters(int n, int n2) {
            this(n, n > 1024 ? 256 : 160, n2);
        }

        public DomainGenParameters(int n, int n2, int n3) {
            this(n, n2, n3, null, null, null, -1);
        }

        public DomainGenParameters(int n, int n2, int n3, int n4) {
            this(n, n2, n3, null, null, null, n4);
        }

        public DomainGenParameters(BigInteger bigInteger, BigInteger bigInteger2) {
            this(bigInteger.bitLength(), bigInteger2.bitLength(), 0, bigInteger, bigInteger2, null, -1);
        }

        public DomainGenParameters(BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n) {
            this(bigInteger.bitLength(), bigInteger2.bitLength(), 0, bigInteger, bigInteger2, Arrays.clone(byArray), n);
        }

        DomainGenParameters(int n, int n2, int n3, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n4) {
            super(ALGORITHM);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && bigInteger == null && n3 < PrimeCertaintyCalculator.getDefaultCertainty(n)) {
                throw new FipsUnapprovedOperationError("Prime generation certainty " + n3 + " inadequate for parameters of " + n + " bits", this.getAlgorithm());
            }
            if (n4 > 255) {
                throw new IllegalArgumentException("Usage index must be in range 0 to 255 (or -1 to ignore)");
            }
            this.L = n;
            this.N = n2;
            this.certainty = n3;
            this.p = bigInteger;
            this.q = bigInteger2;
            this.seed = byArray;
            this.usageIndex = n4;
        }
    }

    public static final class DomainParametersGenerator {
        private final SecureRandom random;
        private final DomainGenParameters parameters;
        private final FipsDigestAlgorithm digestAlgorithm;

        public DomainParametersGenerator(DomainGenParameters domainGenParameters, SecureRandom secureRandom) {
            this(FipsSHS.Algorithm.SHA256, domainGenParameters, secureRandom);
        }

        public DomainParametersGenerator(FipsDigestAlgorithm fipsDigestAlgorithm, DomainGenParameters domainGenParameters, SecureRandom secureRandom) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                int n = domainGenParameters.L;
                if (n != 2048 && n != 3072) {
                    throw new FipsUnapprovedOperationError("Attempt to create parameters with unapproved key size [" + n + "]", ALGORITHM);
                }
                Utils.validateRandom(secureRandom, Utils.getAsymmetricSecurityStrength(n), ALGORITHM, "Attempt to create parameters with unapproved RNG");
            }
            this.digestAlgorithm = fipsDigestAlgorithm;
            this.parameters = domainGenParameters;
            this.random = secureRandom;
        }

        public DSADomainParameters generateDomainParameters() {
            if (this.parameters.p != null) {
                if (this.parameters.seed != null && this.parameters.usageIndex >= 0) {
                    BigInteger bigInteger = DsaParametersGenerator.calculateGenerator_FIPS186_3_Verifiable(FipsSHS.createDigest(this.digestAlgorithm), this.parameters.p, this.parameters.q, this.parameters.seed, this.parameters.usageIndex);
                    return new DSADomainParameters(this.parameters.p, this.parameters.q, bigInteger, new DSAValidationParameters(this.parameters.seed, -1, this.parameters.usageIndex));
                }
                BigInteger bigInteger = DsaParametersGenerator.calculateGenerator_FIPS186_3_Unverifiable(this.parameters.p, this.parameters.q, this.random);
                return new DSADomainParameters(this.parameters.p, this.parameters.q, bigInteger, null);
            }
            DsaParametersGenerator dsaParametersGenerator = new DsaParametersGenerator(FipsSHS.createDigest(this.digestAlgorithm));
            DsaParameterGenerationParameters dsaParameterGenerationParameters = new DsaParameterGenerationParameters(this.parameters.L, this.parameters.N, this.parameters.certainty, this.random, this.parameters.usageIndex);
            dsaParametersGenerator.init(dsaParameterGenerationParameters);
            DsaParameters dsaParameters = dsaParametersGenerator.generateParameters();
            DsaValidationParameters dsaValidationParameters = dsaParameters.getValidationParameters();
            return new DSADomainParameters(dsaParameters.getP(), dsaParameters.getQ(), dsaParameters.getG(), new DSAValidationParameters(dsaValidationParameters.getSeed(), dsaValidationParameters.getCounter(), dsaValidationParameters.getUsageIndex()));
        }
    }

    public static final class DomainParametersValidator {
        private final Version version;
        private final FipsDigestAlgorithm digestAlgorithm;
        private final SecureRandom random;

        public DomainParametersValidator(FipsDigestAlgorithm fipsDigestAlgorithm, SecureRandom secureRandom) {
            this(Version.FIPS_PUB_186_4, fipsDigestAlgorithm, secureRandom);
        }

        public DomainParametersValidator(Version version, FipsDigestAlgorithm fipsDigestAlgorithm, SecureRandom secureRandom) {
            if (Version.FIPS_PUB_186_2 == version && fipsDigestAlgorithm != FipsSHS.Algorithm.SHA1) {
                throw new IllegalArgumentException("186-2 can only validate with SHA-1");
            }
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                Utils.validateRandom(secureRandom, "FIPS SecureRandom required for DSA parameter validation in approved mode.");
            }
            this.version = version;
            this.digestAlgorithm = fipsDigestAlgorithm;
            this.random = secureRandom;
        }

        private static int getMinimumIterations(int n) {
            return n <= 1024 ? 40 : 48 + 8 * ((n - 1) / 1024);
        }

        public boolean isValidPAndQ(BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n) {
            ExtendedDigest extendedDigest = FipsSHS.createDigest(this.digestAlgorithm);
            if (Version.FIPS_PUB_186_2 == this.version) {
                int n2;
                if (bigInteger.bitLength() != 1024 || bigInteger2.bitLength() != 160 || n > 4095) {
                    return false;
                }
                if (byArray.length < 20) {
                    return false;
                }
                BigInteger bigInteger3 = this.digest(extendedDigest, byArray).xor(this.digest(extendedDigest, this.seedPlus1(byArray)));
                if (!bigInteger2.equals(bigInteger3 = bigInteger3.setBit(0).setBit(159)) || !this.isProbablePrime(bigInteger2, DomainParametersValidator.getMinimumIterations(1024))) {
                    return false;
                }
                BigInteger bigInteger4 = BigInteger.ONE.shiftLeft(64);
                byte[] byArray2 = Arrays.clone(byArray);
                this.inc(byArray2);
                boolean bl = false;
                BigInteger bigInteger5 = null;
                for (n2 = 0; n2 <= n; ++n2) {
                    BigInteger bigInteger6 = BigInteger.ZERO;
                    for (int i = 0; i <= 5; ++i) {
                        this.inc(byArray2);
                        bigInteger6 = bigInteger6.add(this.digest(extendedDigest, byArray2).shiftLeft(160 * i));
                    }
                    this.inc(byArray2);
                    bigInteger6 = bigInteger6.add(this.digest(extendedDigest, byArray2).mod(bigInteger4).shiftLeft(960));
                    BigInteger bigInteger7 = bigInteger6.setBit(1023);
                    BigInteger bigInteger8 = bigInteger7.mod(bigInteger2.shiftLeft(1));
                    bigInteger5 = bigInteger7.subtract(bigInteger8.subtract(BigInteger.ONE));
                    if (bigInteger5.bitLength() != 1024 || !this.isProbablePrime(bigInteger5, DomainParametersValidator.getMinimumIterations(1024))) continue;
                    bl = true;
                    break;
                }
                if (n2 != n || !bigInteger.equals(bigInteger5) || !bl) {
                    return false;
                }
            } else {
                int n3;
                int n4 = bigInteger.bitLength();
                int n5 = bigInteger2.bitLength();
                if (!(n4 == 1024 && n5 == 160 || n4 == 2048 && n5 == 224 || n4 == 2048 && n5 == 256 || n4 == 3072 && n5 == 256)) {
                    return false;
                }
                if (n > 4 * n4 - 1) {
                    return false;
                }
                if (byArray.length * 8 < n5) {
                    return false;
                }
                BigInteger bigInteger9 = BigInteger.ONE.shiftLeft(n5 - 1);
                BigInteger bigInteger10 = this.digest(extendedDigest, byArray).mod(bigInteger9);
                BigInteger bigInteger11 = bigInteger10.setBit(0).setBit(n5 - 1);
                if (!bigInteger2.equals(bigInteger11) || !this.isProbablePrime(bigInteger2, DomainParametersValidator.getMinimumIterations(n4))) {
                    return false;
                }
                int n6 = extendedDigest.getDigestSize() * 8;
                int n7 = (n4 + n6 - 1) / n6 - 1;
                int n8 = n4 - n7 * n6;
                BigInteger bigInteger12 = BigInteger.ONE.shiftLeft(n8);
                byte[] byArray3 = Arrays.clone(byArray);
                boolean bl = false;
                BigInteger bigInteger13 = null;
                for (n3 = 0; n3 <= n; ++n3) {
                    BigInteger bigInteger14 = BigInteger.ZERO;
                    for (int i = 0; i < n7; ++i) {
                        this.inc(byArray3);
                        bigInteger14 = bigInteger14.add(this.digest(extendedDigest, byArray3).shiftLeft(n6 * i));
                    }
                    this.inc(byArray3);
                    bigInteger14 = bigInteger14.add(this.digest(extendedDigest, byArray3).mod(bigInteger12).shiftLeft(n6 * n7));
                    BigInteger bigInteger15 = bigInteger14.setBit(n4 - 1);
                    BigInteger bigInteger16 = bigInteger15.mod(bigInteger2.shiftLeft(1));
                    bigInteger13 = bigInteger15.subtract(bigInteger16.subtract(BigInteger.ONE));
                    if (bigInteger13.bitLength() != n4 || !this.isProbablePrime(bigInteger13, DomainParametersValidator.getMinimumIterations(n4))) continue;
                    bl = true;
                    break;
                }
                if (n3 != n || !bigInteger.equals(bigInteger13) || !bl) {
                    return false;
                }
            }
            return true;
        }

        public boolean isPartiallyValidG(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            if (BigInteger.valueOf(2L).compareTo(bigInteger3) > 0 || bigInteger.subtract(BigInteger.ONE).compareTo(bigInteger3) < 0) {
                return false;
            }
            return bigInteger3.modPow(bigInteger2, bigInteger).equals(BigInteger.ONE);
        }

        public boolean isValidG(BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n, BigInteger bigInteger3) {
            ExtendedDigest extendedDigest = FipsSHS.createDigest(this.digestAlgorithm);
            if (n >>> 8 != 0) {
                return false;
            }
            if (BigInteger.valueOf(2L).compareTo(bigInteger3) > 0 || bigInteger.subtract(BigInteger.ONE).compareTo(bigInteger3) < 0) {
                return false;
            }
            if (!bigInteger3.modPow(bigInteger2, bigInteger).equals(BigInteger.ONE)) {
                return false;
            }
            BigInteger bigInteger4 = bigInteger.subtract(BigInteger.ONE).divide(bigInteger2);
            int n2 = 0;
            byte[] byArray2 = new byte[3];
            byArray2[0] = (byte)n;
            byte[] byArray3 = Arrays.concatenate(byArray, Hex.decode("6767656E"), byArray2);
            BigInteger bigInteger5 = null;
            while (++n2 < 65536) {
                this.inc(byArray3);
                bigInteger5 = this.digest(extendedDigest, byArray3).modPow(bigInteger4, bigInteger);
                if (bigInteger5.compareTo(BigInteger.ONE) <= 0) continue;
            }
            return bigInteger3.equals(bigInteger5);
        }

        private BigInteger digest(Digest digest, byte[] byArray) {
            byte[] byArray2 = new byte[digest.getDigestSize()];
            digest.update(byArray, 0, byArray.length);
            digest.doFinal(byArray2, 0);
            return new BigInteger(1, byArray2);
        }

        private byte[] seedPlus1(byte[] byArray) {
            return this.inc(Arrays.clone(byArray));
        }

        private byte[] inc(byte[] byArray) {
            int n = byArray.length - 1;
            while (n >= 0) {
                int n2 = n--;
                byArray[n2] = (byte)(byArray[n2] + 1);
                if (byArray[n2] == 0) continue;
            }
            return byArray;
        }

        private boolean isProbablePrime(BigInteger bigInteger, int n) {
            return !Primes.hasAnySmallFactors(bigInteger) && Primes.isMRProbablePrime(bigInteger, this.random, n);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Version {
            FIPS_PUB_186_2,
            FIPS_PUB_186_4;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DsaProvider
    extends FipsEngineProvider<DsaSigner> {
        private DsaProvider() {
        }

        @Override
        public DsaSigner createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new DsaSigner(), new VariantKatTest<DsaSigner>(){

                @Override
                void evaluate(DsaSigner dsaSigner) throws Exception {
                    BigInteger bigInteger = new BigInteger("90EAF4D1AF0708B1B612FF35E0A2997EB9E9D263C9CE659528945C0D", 16);
                    BigInteger bigInteger2 = new BigInteger("C196BA05AC29E1F9C3C72D56DFFC6154A033F1477AC88EC37F09BE6C5BB95F51C296DD20D1A28A067CCC4D4316A4BD1DCA55ED1066D438C35AEBAABF57E7DAE428782A95ECA1C143DB701FD48533A3C18F0FE23557EA7AE619ECACC7E0B51652A8776D02A425567DED36EABD90CA33A1E8D988F0BBB92D02D1D20290113BB562CE1FC856EEB7CDD92D33EEA6F410859B179E7E789A8F75F645FAE2E136D252BFFAFF89528945C1ABE705A38DBC2D364AADE99BE0D0AAD82E5320121496DC65B3930E38047294FF877831A16D5228418DE8AB275D7D75651CEFED65F78AFC3EA7FE4D79B35F62A0402A1117599ADAC7B269A59F353CF450E6982D3B1702D9CA83", 16);
                    BigInteger bigInteger3 = new BigInteger("A59A749A11242C58C894E9E5A91804E8FA0AC64B56288F8D47D51B1EDC4D65444FECA0111D78F35FC9FDD4CB1F1B79A3BA9CBEE83A3F811012503C8117F98E5048B089E387AF6949BF8784EBD9EF45876F2E6A5A495BE64B6E770409494B7FEE1DBB1E4B2BC2A53D4F893D418B7159592E4FFFDF6969E91D770DAEBD0B5CB14C00AD68EC7DC1E5745EA55C706C4A1C5C88964E34D09DEB753AD418C1AD0F4FDFD049A955E5D78491C0B7A2F1575A008CCD727AB376DB6E695515B05BD412F5B8C2F4C77EE10DA48ABD53F5DD498927EE7B692BBBCDA2FB23A516C5B4533D73980B2A3B60E384ED200AE21B40D273651AD6060C13D97FD69AA13C5611A51B9085", 16);
                    DsaKeyPairGenerator dsaKeyPairGenerator = new DsaKeyPairGenerator();
                    dsaKeyPairGenerator.init(new DsaKeyGenerationParameters((SecureRandom)new TestRandomBigInteger("947813B589EDBA642411AD79205E43CE9B859327A4F84CF4B02628DB058A7B22771EA185", 16), new DsaParameters(bigInteger2, bigInteger, bigInteger3)));
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = dsaKeyPairGenerator.generateKeyPair();
                    dsaSigner.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), new TestRandomBigInteger(224, Hex.decode("735959CC4463B8B440E407EECA8A473BF6A6D1FE657546F67D401F0500000000"))));
                    byte[] byArray = Hex.decode("23097D223405D8228642A477BDA255B32AADBCE4BDA0B3F7E36C9DA7");
                    BigInteger[] bigIntegerArray = dsaSigner.generateSignature(byArray);
                    dsaSigner.init(false, asymmetricCipherKeyPair.getPublic());
                    if (!dsaSigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1])) {
                        this.fail("KAT signature not verified");
                    }
                }
            });
        }
    }

    public static final class KeyGenParameters
    extends FipsParameters {
        private final DSADomainParameters domainParameters;

        public KeyGenParameters(DSADomainParameters dSADomainParameters) {
            super(ALGORITHM);
            this.domainParameters = dSADomainParameters;
        }

        public DSADomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends FipsAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey> {
        private final DsaKeyPairGenerator engine = new DsaKeyPairGenerator();
        private final DSADomainParameters domainParameters;
        private final DsaKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                int n = keyGenParameters.getDomainParameters().getP().bitLength();
                if (n != 2048 && n != 3072) {
                    throw new FipsUnapprovedOperationError("Attempt to create key pair with unapproved key size [" + n + "]", keyGenParameters.getAlgorithm());
                }
                Utils.validateKeyPairGenRandom(secureRandom, Utils.getAsymmetricSecurityStrength(n), keyGenParameters.getAlgorithm());
            }
            this.domainParameters = keyGenParameters.getDomainParameters();
            this.param = new DsaKeyGenerationParameters(secureRandom, FipsDSA.getDomainParams(this.domainParameters));
            this.engine.init(this.param);
        }

        @Override
        public AsymmetricKeyPair<AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey> generateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            DsaPublicKeyParameters dsaPublicKeyParameters = (DsaPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            DsaPrivateKeyParameters dsaPrivateKeyParameters = (DsaPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            FipsAlgorithm fipsAlgorithm = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            FipsDSA.validateKeyPair(asymmetricCipherKeyPair);
            return new AsymmetricKeyPair<AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey>(new AsymmetricDSAPublicKey(fipsAlgorithm, this.domainParameters, dsaPublicKeyParameters.getY()), new AsymmetricDSAPrivateKey(fipsAlgorithm, this.domainParameters, dsaPrivateKeyParameters.getX()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends FipsSignatureOperatorFactory<Parameters> {
        @Override
        public FipsOutputSignerUsingSecureRandom<Parameters> createSigner(AsymmetricPrivateKey asymmetricPrivateKey, Parameters parameters) {
            DsaSigner dsaSigner = (DsaSigner)ENGINE_PROVIDER.createEngine();
            Digest digest = parameters.digestAlgorithm != null ? FipsSHS.createDigest(parameters.digestAlgorithm) : new NullDigest();
            AsymmetricDSAPrivateKey asymmetricDSAPrivateKey = (AsymmetricDSAPrivateKey)asymmetricPrivateKey;
            final DsaPrivateKeyParameters dsaPrivateKeyParameters = FipsDSA.getLwKey(asymmetricDSAPrivateKey);
            int n = dsaPrivateKeyParameters.getParameters().getP().bitLength();
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && n != 2048 && n != 3072) {
                throw new FipsUnapprovedOperationError("Attempt to create signer with unapproved keysize [" + n + "]", ALGORITHM);
            }
            return new DSAOutputSigner<Parameters>(dsaSigner, digest, parameters, new DSAOutputSigner.Initializer(){

                public void initialize(DSA dSA, SecureRandom secureRandom) {
                    dSA.init(true, new ParametersWithRandom(dsaPrivateKeyParameters, secureRandom));
                }
            });
        }

        @Override
        public FipsOutputVerifier<Parameters> createVerifier(AsymmetricPublicKey asymmetricPublicKey, Parameters parameters) {
            DsaSigner dsaSigner = (DsaSigner)ENGINE_PROVIDER.createEngine();
            Digest digest = parameters.digestAlgorithm != null ? FipsSHS.createDigest(parameters.digestAlgorithm) : new NullDigest();
            AsymmetricDSAPublicKey asymmetricDSAPublicKey = (AsymmetricDSAPublicKey)asymmetricPublicKey;
            DsaPublicKeyParameters dsaPublicKeyParameters = new DsaPublicKeyParameters(asymmetricDSAPublicKey.getY(), FipsDSA.getDomainParams(asymmetricDSAPublicKey.getDomainParameters()));
            int n = dsaPublicKeyParameters.getParameters().getP().bitLength();
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && n != 1024 && n != 2048 && n != 3072) {
                throw new FipsUnapprovedOperationError("Attempt to create verifier with unapproved keysize [" + n + "]", ALGORITHM);
            }
            dsaSigner.init(false, dsaPublicKeyParameters);
            return new DSAOutputVerifier<Parameters>(dsaSigner, digest, parameters);
        }
    }

    public static final class Parameters
    extends FipsParameters {
        private final FipsDigestAlgorithm digestAlgorithm;

        Parameters() {
            super(ALGORITHM);
            this.digestAlgorithm = FipsSHS.Algorithm.SHA1;
        }

        private Parameters(FipsDigestAlgorithm fipsDigestAlgorithm) {
            super(ALGORITHM);
            if (fipsDigestAlgorithm == null && CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                PrivilegedUtils.checkPermission(Permissions.TlsNullDigestEnabled);
            }
            this.digestAlgorithm = fipsDigestAlgorithm;
        }

        public FipsDigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public Parameters withDigestAlgorithm(FipsDigestAlgorithm fipsDigestAlgorithm) {
            return new Parameters(fipsDigestAlgorithm);
        }
    }
}

