/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.monitor.jvm.HotThreads;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class ClusterApplierRecordingService {
    private static final Logger logger = LogManager.getLogger(ClusterApplierRecordingService.class);
    private final Map<String, MeanMetric> recordedActions = new HashMap<String, MeanMetric>();

    synchronized Stats getStats() {
        return new Stats(this.recordedActions.entrySet().stream().sorted(Comparator.comparingLong(o -> ((MeanMetric)o.getValue()).sum()).reversed()).collect(Maps.toUnmodifiableOrderedMap(Map.Entry::getKey, v -> new Stats.Recording(((MeanMetric)v.getValue()).count(), ((MeanMetric)v.getValue()).sum()))));
    }

    synchronized void updateStats(Recorder recorder) {
        HashSet<String> seenActions = new HashSet<String>();
        for (Tuple<String, Long> entry2 : recorder.recordings) {
            String action = (String)entry2.v1();
            long timeSpentMS = (Long)entry2.v2();
            MeanMetric metric = this.recordedActions.computeIfAbsent(action, key -> new MeanMetric());
            metric.inc(timeSpentMS);
            seenActions.add(action);
        }
        this.recordedActions.entrySet().removeIf(entry -> !seenActions.contains(entry.getKey()));
    }

    public static class Stats
    implements Writeable,
    ToXContentFragment {
        private final Map<String, Recording> recordings;

        public Stats(Map<String, Recording> recordings) {
            this.recordings = recordings;
        }

        public Map<String, Recording> getRecordings() {
            return this.recordings;
        }

        public Stats(StreamInput in) throws IOException {
            this(in.readOrderedMap(StreamInput::readString, Recording::new));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("cluster_applier_stats");
            builder.startArray("recordings");
            for (Map.Entry<String, Recording> entry : this.recordings.entrySet()) {
                builder.startObject();
                builder.field("name", entry.getKey());
                String name = "cumulative_execution";
                builder.field(name + "_count", entry.getValue().count);
                builder.humanReadableField(name + "_time_millis", name + "_time", (Object)TimeValue.timeValueMillis((long)entry.getValue().sum));
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.recordings, StreamOutput::writeWriteable);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stats stats = (Stats)o;
            return Objects.equals(this.recordings, stats.recordings);
        }

        public int hashCode() {
            return Objects.hash(this.recordings);
        }

        public static class Recording
        implements Writeable {
            private final long count;
            private final long sum;

            public Recording(long count, long sum) {
                this.count = count;
                this.sum = sum;
            }

            public Recording(StreamInput in) throws IOException {
                this(in.readVLong(), in.readVLong());
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeVLong(this.count);
                out.writeVLong(this.sum);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Recording recording = (Recording)o;
                return this.count == recording.count && this.sum == recording.sum;
            }

            public int hashCode() {
                return Objects.hash(this.count, this.sum);
            }

            public String toString() {
                return "Recording{count=" + this.count + ", sum=" + this.sum + "}";
            }
        }
    }

    static final class Recorder {
        private String currentAction;
        private long startMillis;
        private boolean recording;
        private SubscribableListener<Void> currentListener;
        private final List<Tuple<String, Long>> recordings = new LinkedList<Tuple<String, Long>>();
        private final ThreadPool threadPool;
        private final TimeValue debugLoggingTimeout;

        Recorder(ThreadPool threadPool, TimeValue debugLoggingTimeout) {
            this.threadPool = threadPool;
            this.debugLoggingTimeout = debugLoggingTimeout;
        }

        Releasable record(String action) {
            if (this.recording) {
                throw new IllegalStateException("already recording");
            }
            this.recording = true;
            this.currentAction = action;
            this.startMillis = this.threadPool.rawRelativeTimeInMillis();
            if (logger.isDebugEnabled()) {
                this.currentListener = new SubscribableListener();
                this.currentListener.addTimeout(this.debugLoggingTimeout, this.threadPool, this.threadPool.generic());
                this.currentListener.addListener(new ActionListener<Void>(){

                    @Override
                    public void onResponse(Void unused) {
                    }

                    @Override
                    public void onFailure(Exception e) {
                        assert (e instanceof ElasticsearchTimeoutException) : e;
                        HotThreads.logLocalHotThreads(logger, Level.DEBUG, "hot threads while applying cluster state [" + currentAction + "]", ReferenceDocs.LOGGING);
                    }
                });
            }
            return this::stop;
        }

        void stop() {
            this.recording = false;
            long elapsedMillis = this.threadPool.rawRelativeTimeInMillis() - this.startMillis;
            this.recordings.add((Tuple<String, Long>)new Tuple((Object)this.currentAction, (Object)elapsedMillis));
            if (this.currentListener != null) {
                this.currentListener.onResponse(null);
                this.currentListener = null;
            }
        }

        List<Tuple<String, Long>> getRecordings() {
            return this.recordings;
        }
    }
}

