/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.request;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.azureaistudio.rerank.AzureAiStudioRerankTaskSettings;

public record AzureAiStudioRerankRequestEntity(String query, List<String> input, @Nullable Boolean returnDocuments, @Nullable Integer topN, AzureAiStudioRerankTaskSettings taskSettings) implements ToXContentObject
{
    public AzureAiStudioRerankRequestEntity {
        Objects.requireNonNull(query);
        Objects.requireNonNull(input);
        Objects.requireNonNull(taskSettings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("documents", this.input);
        builder.field("query", this.query);
        if (this.returnDocuments != null) {
            builder.field("return_documents", this.returnDocuments);
        } else if (this.taskSettings.returnDocuments() != null) {
            builder.field("return_documents", this.taskSettings.returnDocuments());
        }
        if (this.topN != null) {
            builder.field("top_n", this.topN);
        } else if (this.taskSettings.topN() != null) {
            builder.field("top_n", this.taskSettings.topN());
        }
        builder.endObject();
        return builder;
    }
}

