/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class ConnectorIngestPipeline
implements Writeable,
ToXContentObject {
    private final Boolean extractBinaryContent;
    private final String name;
    private final Boolean reduceWhitespace;
    private final Boolean runMlInference;
    private static final ParseField EXTRACT_BINARY_CONTENT_FIELD = new ParseField("extract_binary_content", new String[0]);
    private static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    private static final ParseField REDUCE_WHITESPACE_FIELD = new ParseField("reduce_whitespace", new String[0]);
    private static final ParseField RUN_ML_INFERENCE_FIELD = new ParseField("run_ml_inference", new String[0]);
    private static final ConstructingObjectParser<ConnectorIngestPipeline, Void> PARSER = new ConstructingObjectParser("connector_ingest_pipeline", true, args -> new Builder().setExtractBinaryContent((Boolean)args[0]).setName((String)args[1]).setReduceWhitespace((Boolean)args[2]).setRunMlInference((Boolean)args[3]).build());

    private ConnectorIngestPipeline(Boolean extractBinaryContent, String name, Boolean reduceWhitespace, Boolean runMlInference) {
        this.extractBinaryContent = Objects.requireNonNull(extractBinaryContent, EXTRACT_BINARY_CONTENT_FIELD.getPreferredName());
        this.name = Objects.requireNonNull(name, NAME_FIELD.getPreferredName());
        this.reduceWhitespace = Objects.requireNonNull(reduceWhitespace, REDUCE_WHITESPACE_FIELD.getPreferredName());
        this.runMlInference = Objects.requireNonNull(runMlInference, RUN_ML_INFERENCE_FIELD.getPreferredName());
    }

    public ConnectorIngestPipeline(StreamInput in) throws IOException {
        this.extractBinaryContent = in.readBoolean();
        this.name = in.readString();
        this.reduceWhitespace = in.readBoolean();
        this.runMlInference = in.readBoolean();
    }

    public static ConnectorIngestPipeline fromXContentBytes(BytesReference source, XContentType xContentType) {
        ConnectorIngestPipeline connectorIngestPipeline;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                connectorIngestPipeline = ConnectorIngestPipeline.fromXContent(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse: " + source.utf8ToString(), (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return connectorIngestPipeline;
    }

    public static ConnectorIngestPipeline fromXContent(XContentParser parser) throws IOException {
        return (ConnectorIngestPipeline)PARSER.parse(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(EXTRACT_BINARY_CONTENT_FIELD.getPreferredName(), this.extractBinaryContent);
        builder.field(NAME_FIELD.getPreferredName(), this.name);
        builder.field(REDUCE_WHITESPACE_FIELD.getPreferredName(), this.reduceWhitespace);
        builder.field(RUN_ML_INFERENCE_FIELD.getPreferredName(), this.runMlInference);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.extractBinaryContent.booleanValue());
        out.writeString(this.name);
        out.writeBoolean(this.reduceWhitespace.booleanValue());
        out.writeBoolean(this.runMlInference.booleanValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorIngestPipeline that = (ConnectorIngestPipeline)o;
        return Objects.equals(this.extractBinaryContent, that.extractBinaryContent) && Objects.equals(this.name, that.name) && Objects.equals(this.reduceWhitespace, that.reduceWhitespace) && Objects.equals(this.runMlInference, that.runMlInference);
    }

    public int hashCode() {
        return Objects.hash(this.extractBinaryContent, this.name, this.reduceWhitespace, this.runMlInference);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), EXTRACT_BINARY_CONTENT_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), REDUCE_WHITESPACE_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), RUN_ML_INFERENCE_FIELD);
    }

    public static class Builder {
        private Boolean extractBinaryContent;
        private String name;
        private Boolean reduceWhitespace;
        private Boolean runMlInference;

        public Builder setExtractBinaryContent(Boolean extractBinaryContent) {
            this.extractBinaryContent = extractBinaryContent;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setReduceWhitespace(Boolean reduceWhitespace) {
            this.reduceWhitespace = reduceWhitespace;
            return this;
        }

        public Builder setRunMlInference(Boolean runMlInference) {
            this.runMlInference = runMlInference;
            return this;
        }

        public ConnectorIngestPipeline build() {
            return new ConnectorIngestPipeline(this.extractBinaryContent, this.name, this.reduceWhitespace, this.runMlInference);
        }
    }
}

