/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application;

import java.util.Collections;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.analytics.action.GetAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.rules.QueryRulesetListItem;
import org.elasticsearch.xpack.application.rules.action.ListQueryRulesetsAction;
import org.elasticsearch.xpack.application.search.action.ListSearchApplicationAction;
import org.elasticsearch.xpack.application.utils.LicenseUtils;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.application.EnterpriseSearchFeatureSetUsage;

public class EnterpriseSearchUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final XPackLicenseState licenseState;
    private final OriginSettingClient clientWithOrigin;
    private final IndicesAdminClient indicesAdminClient;
    private final boolean enabled;

    @Inject
    public EnterpriseSearchUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Settings settings, XPackLicenseState licenseState, Client client) {
        super(XPackUsageFeatureAction.ENTERPRISE_SEARCH.name(), transportService, clusterService, threadPool, actionFilters);
        this.licenseState = licenseState;
        this.clientWithOrigin = new OriginSettingClient(client, "enterprise_search");
        this.indicesAdminClient = this.clientWithOrigin.admin().indices();
        this.enabled = (Boolean)XPackSettings.ENTERPRISE_SEARCH_ENABLED.get(settings);
    }

    protected void localClusterStateOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        if (!this.enabled) {
            EnterpriseSearchFeatureSetUsage usage = new EnterpriseSearchFeatureSetUsage(LicenseUtils.PLATINUM_LICENSED_FEATURE.checkWithoutTracking(this.licenseState), this.enabled, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
            listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureUsage)usage));
            return;
        }
        HashMap searchApplicationsUsage = new HashMap();
        HashMap analyticsCollectionsUsage = new HashMap();
        HashMap queryRulesUsage = new HashMap();
        ListSearchApplicationAction.Request searchApplicationsCountRequest = new ListSearchApplicationAction.Request("*", new PageParams(0, 0));
        ActionListener searchApplicationsCountListener = ActionListener.wrap(response -> {
            EnterpriseSearchUsageTransportAction.addSearchApplicationsUsage(response, searchApplicationsUsage);
            listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureUsage)new EnterpriseSearchFeatureSetUsage(LicenseUtils.PLATINUM_LICENSED_FEATURE.checkWithoutTracking(this.licenseState), this.enabled, searchApplicationsUsage, analyticsCollectionsUsage, queryRulesUsage)));
        }, e -> listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureUsage)new EnterpriseSearchFeatureSetUsage(LicenseUtils.PLATINUM_LICENSED_FEATURE.checkWithoutTracking(this.licenseState), this.enabled, Collections.emptyMap(), analyticsCollectionsUsage, queryRulesUsage))));
        final ActionListener listQueryRulesetsListener = ActionListener.wrap(response -> {
            this.addQueryRulesetUsage((ListQueryRulesetsAction.Response)((Object)response), queryRulesUsage);
            this.clientWithOrigin.execute(ListSearchApplicationAction.INSTANCE, (ActionRequest)searchApplicationsCountRequest, searchApplicationsCountListener);
        }, e -> this.clientWithOrigin.execute(ListSearchApplicationAction.INSTANCE, (ActionRequest)searchApplicationsCountRequest, searchApplicationsCountListener));
        IndicesStatsRequest indicesStatsRequest = (IndicesStatsRequest)this.indicesAdminClient.prepareStats(new String[]{".query-rules"}).setDocs(true).request();
        GetAnalyticsCollectionAction.Request analyticsCollectionsCountRequest = new GetAnalyticsCollectionAction.Request(request.masterTimeout(), new String[]{"*"});
        ActionListener analyticsCollectionsCountListener = ActionListener.wrap(response -> {
            EnterpriseSearchUsageTransportAction.addAnalyticsCollectionsUsage(response, analyticsCollectionsUsage);
            this.indicesAdminClient.execute((ActionType)IndicesStatsAction.INSTANCE, (ActionRequest)indicesStatsRequest, (ActionListener)new ActionListener<IndicesStatsResponse>(){

                public void onResponse(IndicesStatsResponse indicesStatsResponse) {
                    Map indicesStats = indicesStatsResponse.getIndices();
                    int queryRulesetCount = indicesStats.values().stream().map(indexShardStats -> indexShardStats.getPrimaries().getDocs()).filter(Objects::nonNull).mapToInt(docsStats -> (int)docsStats.getCount()).sum();
                    ListQueryRulesetsAction.Request queryRulesetsCountRequest = new ListQueryRulesetsAction.Request(new PageParams(0, queryRulesetCount));
                    EnterpriseSearchUsageTransportAction.this.clientWithOrigin.execute(ListQueryRulesetsAction.INSTANCE, (ActionRequest)queryRulesetsCountRequest, listQueryRulesetsListener);
                }

                public void onFailure(Exception e) {
                    ListQueryRulesetsAction.Request queryRulesetsCountRequest = new ListQueryRulesetsAction.Request(new PageParams(0, 0));
                    EnterpriseSearchUsageTransportAction.this.clientWithOrigin.execute(ListQueryRulesetsAction.INSTANCE, (ActionRequest)queryRulesetsCountRequest, listQueryRulesetsListener);
                }
            });
        }, e -> {
            ListQueryRulesetsAction.Request queryRulesetsCountRequest = new ListQueryRulesetsAction.Request(new PageParams(0, 0));
            this.clientWithOrigin.execute(ListQueryRulesetsAction.INSTANCE, (ActionRequest)queryRulesetsCountRequest, listQueryRulesetsListener);
        });
        this.clientWithOrigin.execute(GetAnalyticsCollectionAction.INSTANCE, (ActionRequest)analyticsCollectionsCountRequest, analyticsCollectionsCountListener);
    }

    private static void addSearchApplicationsUsage(ListSearchApplicationAction.Response response, Map<String, Object> searchApplicationsUsage) {
        long count = response.queryPage().count();
        searchApplicationsUsage.put("count", count);
    }

    private static void addAnalyticsCollectionsUsage(GetAnalyticsCollectionAction.Response response, Map<String, Object> analyticsCollectionsUsage) {
        long count = response.getAnalyticsCollections().size();
        analyticsCollectionsUsage.put("count", count);
    }

    private void addQueryRulesetUsage(ListQueryRulesetsAction.Response response, Map<String, Object> queryRulesUsage) {
        List results = response.queryPage().results();
        IntSummaryStatistics ruleStats = results.stream().mapToInt(QueryRulesetListItem::ruleTotalCount).summaryStatistics();
        HashMap ruleCriteriaTypeCountMap = new HashMap();
        HashMap ruleTypeCountMap = new HashMap();
        results.forEach(result -> {
            this.populateCounts(ruleCriteriaTypeCountMap, result.criteriaTypeToCountMap());
            this.populateCounts(ruleTypeCountMap, result.ruleTypeToCountMap());
        });
        queryRulesUsage.put("total_count", response.queryPage().count());
        queryRulesUsage.put("total_rule_count", ruleStats.getSum());
        queryRulesUsage.put("min_rule_count", results.isEmpty() ? 0 : ruleStats.getMin());
        queryRulesUsage.put("max_rule_count", results.isEmpty() ? 0 : ruleStats.getMax());
        if (!ruleCriteriaTypeCountMap.isEmpty()) {
            queryRulesUsage.put("rule_criteria_total_counts", ruleCriteriaTypeCountMap);
        }
        if (!ruleTypeCountMap.isEmpty()) {
            queryRulesUsage.put("rule_type_total_counts", ruleTypeCountMap);
        }
    }

    private void populateCounts(Map<String, Object> targetMap, Map<? extends Enum<?>, Integer> sourceMap) {
        sourceMap.forEach((key, value) -> targetMap.merge(key.name().toLowerCase(Locale.ROOT), value, (v1, v2) -> (Integer)v1 + (Integer)v2));
    }
}

