/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.math.BigDecimal;
import org.ojalgo.array.operation.COPY;
import org.ojalgo.data.domain.finance.FinanceUtils;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.Primitive64Matrix;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.TypeUtils;

public class MarketEquilibrium {
    private static final BigDecimal DEFAULT_RISK_AVERSION = BigMath.ONE;
    private static final String STRING_ZERO = "0";
    private static final String SYMBOL = "Asset_";
    private final String[] myAssetKeys;
    private final Primitive64Matrix myCovariances;
    private BigDecimal myRiskAversion;

    public static Scalar<?> calculatePortfolioReturn(Primitive64Matrix assetWeights, Primitive64Matrix assetReturns) {
        return PrimitiveScalar.valueOf(assetWeights.dot(assetReturns));
    }

    private static String[] makeSymbols(int count) {
        String[] retVal = new String[count];
        int tmpMaxLength = Integer.toString(count - 1).length();
        for (int i = 0; i < count; ++i) {
            String tmpNumberString = Integer.toString(i);
            while (tmpNumberString.length() < tmpMaxLength) {
                tmpNumberString = STRING_ZERO + tmpNumberString;
            }
            retVal[i] = SYMBOL + tmpNumberString;
        }
        return retVal;
    }

    public MarketEquilibrium(Access2D<?> covarianceMatrix) {
        this(covarianceMatrix, DEFAULT_RISK_AVERSION);
    }

    public MarketEquilibrium(Access2D<?> covarianceMatrix, Comparable<?> riskAversionFactor) {
        this(MarketEquilibrium.makeSymbols((int)covarianceMatrix.countRows()), covarianceMatrix, riskAversionFactor);
    }

    public MarketEquilibrium(String[] assetNamesOrKeys, Access2D<?> covarianceMatrix) {
        this(assetNamesOrKeys, covarianceMatrix, DEFAULT_RISK_AVERSION);
    }

    public MarketEquilibrium(String[] assetNamesOrKeys, Access2D<?> covarianceMatrix, Comparable<?> riskAversionFactor) {
        this.myAssetKeys = COPY.copyOf(assetNamesOrKeys);
        this.myCovariances = covarianceMatrix instanceof Primitive64Matrix ? (Primitive64Matrix)covarianceMatrix : (Primitive64Matrix)Primitive64Matrix.FACTORY.copy((Access2D)covarianceMatrix);
        this.myRiskAversion = TypeUtils.toBigDecimal(riskAversionFactor);
    }

    MarketEquilibrium(MarketEquilibrium marketEquilibrium) {
        this(marketEquilibrium.getAssetKeys(), marketEquilibrium.getCovariances(), (Comparable)marketEquilibrium.getRiskAversion().get());
    }

    public Primitive64Matrix calculateAssetReturns(Primitive64Matrix assetWeights) {
        Primitive64Matrix tmpAssetWeights = this.myRiskAversion.compareTo(DEFAULT_RISK_AVERSION) == 0 ? assetWeights : (Primitive64Matrix)assetWeights.multiply(this.myRiskAversion.doubleValue());
        return (Primitive64Matrix)this.myCovariances.multiply(tmpAssetWeights);
    }

    public Primitive64Matrix calculateAssetWeights(Primitive64Matrix assetReturns) {
        Primitive64Matrix tmpAssetWeights = (Primitive64Matrix)this.myCovariances.solve((Access2D)assetReturns);
        if (this.myRiskAversion.compareTo(DEFAULT_RISK_AVERSION) == 0) {
            return tmpAssetWeights;
        }
        return (Primitive64Matrix)tmpAssetWeights.divide(this.myRiskAversion.doubleValue());
    }

    public Scalar<?> calculatePortfolioVariance(Primitive64Matrix assetWeights) {
        Primitive64Matrix tmpRight;
        Primitive64Matrix tmpLeft;
        if (assetWeights.countColumns() == 1L) {
            tmpLeft = (Primitive64Matrix)assetWeights.transpose();
            tmpRight = assetWeights;
        } else {
            tmpLeft = assetWeights;
            tmpRight = (Primitive64Matrix)assetWeights.transpose();
        }
        return ((Primitive64Matrix)tmpLeft.multiply(this.myCovariances.multiply(tmpRight))).toScalar(0L, 0L);
    }

    public void calibrate(Primitive64Matrix assetWeights, Primitive64Matrix assetReturns) {
        Scalar<?> tmpImpliedRiskAversion = this.calculateImpliedRiskAversion(assetWeights, assetReturns);
        this.setRiskAversion((Comparable)tmpImpliedRiskAversion.get());
    }

    public MarketEquilibrium clean() {
        Primitive64Matrix tmpAssetVolatilities = FinanceUtils.toVolatilities(this.myCovariances, true);
        Primitive64Matrix tmpCleanedCorrelations = FinanceUtils.toCorrelations(this.myCovariances, true);
        Primitive64Matrix tmpCovariances = FinanceUtils.toCovariances(tmpAssetVolatilities, tmpCleanedCorrelations);
        return new MarketEquilibrium(this.myAssetKeys, tmpCovariances, this.myRiskAversion);
    }

    public MarketEquilibrium copy() {
        return new MarketEquilibrium(this);
    }

    public String getAssetKey(int index) {
        return this.myAssetKeys[index];
    }

    public String[] getAssetKeys() {
        return COPY.copyOf(this.myAssetKeys);
    }

    public Primitive64Matrix getCovariances() {
        return this.myCovariances;
    }

    public Scalar<?> getRiskAversion() {
        return BigScalar.of(this.myRiskAversion);
    }

    public void setRiskAversion(Comparable<?> factor) {
        BigDecimal tmpFactor = TypeUtils.toBigDecimal(factor);
        this.myRiskAversion = tmpFactor.signum() == 0 ? DEFAULT_RISK_AVERSION : (tmpFactor.signum() < 0 ? tmpFactor.negate() : tmpFactor);
    }

    public int size() {
        return (int)Math.min(this.myCovariances.countRows(), this.myCovariances.countColumns());
    }

    public Primitive64Matrix toCorrelations() {
        return FinanceUtils.toCorrelations(this.myCovariances, false);
    }

    Scalar<?> calculateImpliedRiskAversion(Primitive64Matrix assetWeights, Primitive64Matrix assetReturns) {
        Scalar<BigDecimal> retVal = ((Primitive64Matrix)((Primitive64Matrix)this.myCovariances.multiply(assetWeights)).solve((Access2D)assetReturns)).toScalar(0L, 0L);
        if (retVal.isSmall(PrimitiveMath.ONE)) {
            retVal = BigScalar.ONE;
        } else if (!retVal.isAbsolute()) {
            retVal = (Scalar)retVal.negate();
        }
        return retVal;
    }

    boolean isDefaultRiskAversion() {
        return this.myRiskAversion.compareTo(DEFAULT_RISK_AVERSION) == 0;
    }
}

