/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.action;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.datastreams.DataStreamsActionUtil;
import org.elasticsearch.action.datastreams.lifecycle.GetDataStreamLifecycleAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetentionSettings;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportGetDataStreamLifecycleAction
extends TransportLocalProjectMetadataAction<GetDataStreamLifecycleAction.Request, GetDataStreamLifecycleAction.Response> {
    private final ClusterSettings clusterSettings;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final DataStreamGlobalRetentionSettings globalRetentionSettings;

    @Inject
    public TransportGetDataStreamLifecycleAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver, DataStreamGlobalRetentionSettings globalRetentionSettings) {
        super(GetDataStreamLifecycleAction.INSTANCE.name(), actionFilters, transportService.getTaskManager(), clusterService, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE, projectResolver);
        this.clusterSettings = clusterService.getClusterSettings();
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.globalRetentionSettings = globalRetentionSettings;
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, GetDataStreamLifecycleAction.Request::new, (request, channel, task) -> this.executeDirect(task, (ActionRequest)request, (ActionListener)new ChannelActionListener(channel)));
    }

    protected void localClusterStateOperation(Task task, GetDataStreamLifecycleAction.Request request, ProjectState state, ActionListener<GetDataStreamLifecycleAction.Response> listener) {
        List results = DataStreamsActionUtil.getDataStreamNames((IndexNameExpressionResolver)this.indexNameExpressionResolver, (ProjectMetadata)state.metadata(), (String[])request.getNames(), (IndicesOptions)request.indicesOptions());
        Map dataStreams = state.metadata().dataStreams();
        ((CancellableTask)task).ensureNotCancelled();
        listener.onResponse((Object)new GetDataStreamLifecycleAction.Response(results.stream().map(dataStreams::get).filter(Objects::nonNull).map(dataStream -> new GetDataStreamLifecycleAction.Response.DataStreamLifecycle(dataStream.getName(), dataStream.getDataLifecycle(), dataStream.isSystem())).sorted(Comparator.comparing(GetDataStreamLifecycleAction.Response.DataStreamLifecycle::dataStreamName)).toList(), request.includeDefaults() ? (RolloverConfiguration)this.clusterSettings.get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING) : null, this.globalRetentionSettings.get()));
    }

    protected ClusterBlockException checkBlock(GetDataStreamLifecycleAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(state.projectId(), ClusterBlockLevel.METADATA_READ);
    }
}

