/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.ql.async.AsyncTaskManagementService;
import org.elasticsearch.xpack.ql.type.Schema;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.action.SqlQueryAction;
import org.elasticsearch.xpack.sql.action.SqlQueryRequest;
import org.elasticsearch.xpack.sql.action.SqlQueryResponse;
import org.elasticsearch.xpack.sql.action.SqlQueryTask;
import org.elasticsearch.xpack.sql.execution.PlanExecutor;
import org.elasticsearch.xpack.sql.expression.literal.geo.GeoShape;
import org.elasticsearch.xpack.sql.expression.literal.interval.Interval;
import org.elasticsearch.xpack.sql.plugin.SqlLicenseChecker;
import org.elasticsearch.xpack.sql.plugin.Transports;
import org.elasticsearch.xpack.sql.proto.ColumnInfo;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.Cursors;
import org.elasticsearch.xpack.sql.session.RowSet;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;
import org.elasticsearch.xpack.sql.session.SqlConfiguration;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public final class TransportSqlQueryAction
extends HandledTransportAction<SqlQueryRequest, SqlQueryResponse>
implements AsyncTaskManagementService.AsyncOperation<SqlQueryRequest, SqlQueryResponse, SqlQueryTask> {
    private static final Logger log = LogManager.getLogger(TransportSqlQueryAction.class);
    private final SecurityContext securityContext;
    private final ClusterService clusterService;
    private final PlanExecutor planExecutor;
    private final SqlLicenseChecker sqlLicenseChecker;
    private final TransportService transportService;
    private final AsyncTaskManagementService<SqlQueryRequest, SqlQueryResponse, SqlQueryTask> asyncTaskManagementService;

    @Inject
    public TransportSqlQueryAction(Settings settings, ClusterService clusterService, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, PlanExecutor planExecutor, SqlLicenseChecker sqlLicenseChecker, BigArrays bigArrays) {
        super("indices:data/read/sql", transportService, actionFilters, SqlQueryRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.clusterService = clusterService;
        this.planExecutor = planExecutor;
        this.sqlLicenseChecker = sqlLicenseChecker;
        this.transportService = transportService;
        this.asyncTaskManagementService = new AsyncTaskManagementService(".async-search", planExecutor.client(), "async_search", planExecutor.writeableRegistry(), this.taskManager, SqlQueryAction.INSTANCE.name(), (AsyncTaskManagementService.AsyncOperation)this, SqlQueryTask.class, clusterService, threadPool, bigArrays);
    }

    protected void doExecute(Task task, SqlQueryRequest request, ActionListener<SqlQueryResponse> listener) {
        this.sqlLicenseChecker.checkIfSqlAllowed(request.mode());
        if (request.waitForCompletionTimeout() != null && request.waitForCompletionTimeout().getMillis() >= 0L) {
            this.asyncTaskManagementService.asyncExecute((TaskAwareRequest)request, request.waitForCompletionTimeout(), request.keepAlive(), request.keepOnCompletion(), listener);
        } else {
            TransportSqlQueryAction.operation(this.planExecutor, (SqlQueryTask)task, request, listener, Transports.username(this.securityContext), this.transportService, this.clusterService);
        }
    }

    public static void operation(PlanExecutor planExecutor, SqlQueryTask task, SqlQueryRequest request, ActionListener<SqlQueryResponse> listener, String username, TransportService transportService, ClusterService clusterService) {
        SqlConfiguration cfg = new SqlConfiguration(request.zoneId(), request.catalog(), request.fetchSize(), request.requestTimeout(), request.pageTimeout(), request.filter(), request.runtimeMappings(), request.mode(), request.clientId(), request.version(), username, Transports.clusterName(clusterService), request.fieldMultiValueLeniency(), request.indexIncludeFrozen(), new TaskId(clusterService.localNode().getId(), task.getId()), task, request.allowPartialSearchResults());
        if (!Strings.hasText((String)request.cursor())) {
            planExecutor.sql(cfg, request.query(), request.params(), (ActionListener<Cursor.Page>)ActionListener.wrap(p -> listener.onResponse((Object)TransportSqlQueryAction.createResponseWithSchema(request, p, task)), arg_0 -> listener.onFailure(arg_0)));
        } else {
            Tuple<Cursor, ZoneId> decoded = Cursors.decodeFromStringWithZone(request.cursor(), planExecutor.writeableRegistry());
            planExecutor.nextPage(cfg, (Cursor)decoded.v1(), (ActionListener<Cursor.Page>)listener.delegateFailureAndWrap((l, p) -> l.onResponse((Object)TransportSqlQueryAction.createResponse(request, (ZoneId)decoded.v2(), null, p, task))));
        }
    }

    private static SqlQueryResponse createResponseWithSchema(SqlQueryRequest request, Cursor.Page page, SqlQueryTask task) {
        RowSet rset = page.rowSet();
        if (!(rset instanceof SchemaRowSet)) {
            throw new SqlIllegalArgumentException("No schema found inside {}", rset.getClass());
        }
        SchemaRowSet rowSet = (SchemaRowSet)rset;
        ArrayList<ColumnInfo> columns = new ArrayList(rowSet.columnCount());
        for (Schema.Entry entry : rowSet.schema()) {
            if (Mode.isDriver((Mode)request.mode())) {
                columns.add(new ColumnInfo("", entry.name(), entry.type().typeName(), Integer.valueOf(SqlDataTypes.displaySize(entry.type()))));
                continue;
            }
            columns.add(new ColumnInfo("", entry.name(), entry.type().typeName()));
        }
        columns = Collections.unmodifiableList(columns);
        return TransportSqlQueryAction.createResponse(request, request.zoneId(), columns, page, task);
    }

    private static SqlQueryResponse createResponse(SqlQueryRequest request, ZoneId zoneId, List<ColumnInfo> header, Cursor.Page page, SqlQueryTask task) {
        ArrayList rows = new ArrayList();
        page.rowSet().forEachRow(rowView -> {
            ArrayList row = new ArrayList(rowView.columnCount());
            rowView.forEachColumn(r -> row.add(TransportSqlQueryAction.value(r, request.mode())));
            rows.add(Collections.unmodifiableList(row));
        });
        AsyncExecutionId executionId = task.getExecutionId();
        return new SqlQueryResponse(Cursors.encodeToString(page.next(), zoneId), request.mode(), request.version(), request.columnar().booleanValue(), header, rows, executionId == null ? null : executionId.getEncoded(), false, false);
    }

    private static Object value(Object r, Mode mode) {
        if (r instanceof GeoShape) {
            r = r.toString();
        } else if (r instanceof Interval) {
            r = mode == Mode.CLI ? r.toString() : ((Interval)r).value();
        }
        return r;
    }

    public SqlQueryTask createTask(SqlQueryRequest request, long id, String type, String action, TaskId parentTaskId, Map<String, String> headers, Map<String, String> originHeaders, AsyncExecutionId asyncExecutionId) {
        return new SqlQueryTask(id, type, action, request.getDescription(), parentTaskId, headers, originHeaders, asyncExecutionId, request.keepAlive(), request.mode(), request.version(), request.columnar().booleanValue());
    }

    public void execute(SqlQueryRequest request, SqlQueryTask task, ActionListener<SqlQueryResponse> listener) {
        TransportSqlQueryAction.operation(this.planExecutor, task, request, listener, Transports.username(this.securityContext), this.transportService, this.clusterService);
    }

    public SqlQueryResponse initialResponse(SqlQueryTask task) {
        return task.getCurrentResult();
    }

    public SqlQueryResponse readResponse(StreamInput inputStream) throws IOException {
        return new SqlQueryResponse(inputStream);
    }
}

