/*
 * Decompiled with CFR 0.152.
 */
package io.github.stduritemplate;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StdUriTemplate {
    public static String expand(String template, Map<String, Object> substitutions) {
        return StdUriTemplate.expandImpl(template, substitutions);
    }

    private static void validateLiteral(Character c, int col) {
        switch (c.charValue()) {
            case ' ': 
            case '!': 
            case '#': 
            case '$': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '|': 
            case '~': {
                throw new IllegalArgumentException("Illegal character identified in the token at col:" + col);
            }
        }
    }

    private static int getMaxChar(StringBuilder buffer, int col) {
        if (buffer == null || buffer.length() == 0) {
            return -1;
        }
        String value = buffer.toString();
        if (value.isEmpty()) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parse max chars at col:" + col);
        }
    }

    private static Operator getOperator(Character c, StringBuilder token, int col) {
        switch (c.charValue()) {
            case '+': {
                return Operator.PLUS;
            }
            case '#': {
                return Operator.HASH;
            }
            case '.': {
                return Operator.DOT;
            }
            case '/': {
                return Operator.SLASH;
            }
            case ';': {
                return Operator.SEMICOLON;
            }
            case '?': {
                return Operator.QUESTION_MARK;
            }
            case '&': {
                return Operator.AMP;
            }
        }
        StdUriTemplate.validateLiteral(c, col);
        token.append(c);
        return Operator.NO_OP;
    }

    private static String expandImpl(String str, Map<String, Object> substitutions) {
        StringBuilder result = new StringBuilder(str.length() * 2);
        boolean toToken = false;
        StringBuilder token = new StringBuilder();
        Operator operator = null;
        boolean composite = false;
        boolean toMaxCharBuffer = false;
        StringBuilder maxCharBuffer = new StringBuilder(3);
        boolean firstToken = true;
        block5: for (int i = 0; i < str.length(); ++i) {
            char character = str.charAt(i);
            switch (character) {
                case '{': {
                    toToken = true;
                    token.setLength(0);
                    firstToken = true;
                    continue block5;
                }
                case '}': {
                    boolean expanded;
                    if (toToken) {
                        expanded = StdUriTemplate.expandToken(operator, token.toString(), composite, StdUriTemplate.getMaxChar(maxCharBuffer, i), firstToken, substitutions, result, i);
                        if (expanded && firstToken) {
                            firstToken = false;
                        }
                        toToken = false;
                        token.setLength(0);
                        operator = null;
                        composite = false;
                        toMaxCharBuffer = false;
                        maxCharBuffer.setLength(0);
                        continue block5;
                    }
                    throw new IllegalArgumentException("Failed to expand token, invalid at col:" + i);
                }
                case ',': {
                    boolean expanded;
                    if (toToken) {
                        expanded = StdUriTemplate.expandToken(operator, token.toString(), composite, StdUriTemplate.getMaxChar(maxCharBuffer, i), firstToken, substitutions, result, i);
                        if (expanded && firstToken) {
                            firstToken = false;
                        }
                        token.setLength(0);
                        composite = false;
                        toMaxCharBuffer = false;
                        maxCharBuffer.setLength(0);
                        continue block5;
                    }
                }
                default: {
                    if (toToken) {
                        if (operator == null) {
                            operator = StdUriTemplate.getOperator(Character.valueOf(character), token, i);
                            continue block5;
                        }
                        if (toMaxCharBuffer) {
                            if (Character.isDigit(character)) {
                                maxCharBuffer.append(character);
                                continue block5;
                            }
                            throw new IllegalArgumentException("Illegal character identified in the token at col:" + i);
                        }
                        if (character == ':') {
                            toMaxCharBuffer = true;
                            maxCharBuffer.setLength(0);
                            continue block5;
                        }
                        if (character == '*') {
                            composite = true;
                            continue block5;
                        }
                        StdUriTemplate.validateLiteral(Character.valueOf(character), i);
                        token.append(character);
                        continue block5;
                    }
                    result.append(character);
                }
            }
        }
        if (!toToken) {
            return result.toString();
        }
        throw new IllegalArgumentException("Unterminated token");
    }

    private static void addPrefix(Operator op, StringBuilder result) {
        switch (op) {
            case HASH: {
                result.append('#');
                break;
            }
            case DOT: {
                result.append('.');
                break;
            }
            case SLASH: {
                result.append('/');
                break;
            }
            case SEMICOLON: {
                result.append(';');
                break;
            }
            case QUESTION_MARK: {
                result.append('?');
                break;
            }
            case AMP: {
                result.append('&');
                break;
            }
            default: {
                return;
            }
        }
    }

    private static void addSeparator(Operator op, StringBuilder result) {
        switch (op) {
            case DOT: {
                result.append('.');
                break;
            }
            case SLASH: {
                result.append('/');
                break;
            }
            case SEMICOLON: {
                result.append(';');
                break;
            }
            case QUESTION_MARK: 
            case AMP: {
                result.append('&');
                break;
            }
            default: {
                result.append(',');
                return;
            }
        }
    }

    private static void addValue(Operator op, String token, Object value, StringBuilder result, int maxChar) {
        switch (op) {
            case HASH: 
            case PLUS: {
                StdUriTemplate.addExpandedValue(null, value, result, maxChar, false);
                break;
            }
            case QUESTION_MARK: 
            case AMP: {
                result.append(token + '=');
                StdUriTemplate.addExpandedValue(null, value, result, maxChar, true);
                break;
            }
            case SEMICOLON: {
                result.append(token);
                StdUriTemplate.addExpandedValue("=", value, result, maxChar, true);
                break;
            }
            case DOT: 
            case SLASH: 
            case NO_OP: {
                StdUriTemplate.addExpandedValue(null, value, result, maxChar, true);
            }
        }
    }

    private static void addValueElement(Operator op, String token, Object value, StringBuilder result, int maxChar) {
        switch (op) {
            case HASH: 
            case PLUS: {
                StdUriTemplate.addExpandedValue(null, value, result, maxChar, false);
                break;
            }
            case DOT: 
            case SLASH: 
            case SEMICOLON: 
            case QUESTION_MARK: 
            case AMP: 
            case NO_OP: {
                StdUriTemplate.addExpandedValue(null, value, result, maxChar, true);
            }
        }
    }

    private static boolean isSurrogate(char cp) {
        return cp >= '\ud800' && cp <= '\udfff';
    }

    private static boolean isIprivate(char cp) {
        return '\ue000' <= cp && cp <= '\uf8ff';
    }

    private static boolean isUcschar(char cp) {
        return '\u00a0' <= cp && cp <= '\ud7ff' || '\uf900' <= cp && cp <= '\ufdcf' || '\ufdf0' <= cp && cp <= '\uffef';
    }

    private static void addExpandedValue(String prefix, Object value, StringBuilder result, int maxChar, boolean replaceReserved) {
        String stringValue = StdUriTemplate.convertNativeTypes(value);
        int max = maxChar != -1 ? Math.min(maxChar, stringValue.length()) : stringValue.length();
        result.ensureCapacity(max * 2);
        boolean toReserved = false;
        StringBuilder reservedBuffer = new StringBuilder(3);
        if (max > 0 && prefix != null) {
            result.append(prefix);
        }
        for (int i = 0; i < max; ++i) {
            char character = stringValue.charAt(i);
            if (character == '%' && !replaceReserved) {
                toReserved = true;
                reservedBuffer.setLength(0);
            }
            String toAppend = Character.toString(character);
            try {
                if (StdUriTemplate.isSurrogate(character)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(Character.toChars(stringValue.codePointAt(i++)));
                    toAppend = URLEncoder.encode(sb.toString(), StandardCharsets.UTF_8.name());
                } else if (replaceReserved || StdUriTemplate.isUcschar(character) || StdUriTemplate.isIprivate(character)) {
                    toAppend = URLEncoder.encode(toAppend, StandardCharsets.UTF_8.name());
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (toReserved) {
                reservedBuffer.append(toAppend);
                if (reservedBuffer.length() != 3) continue;
                boolean isEncoded = false;
                try {
                    URLDecoder.decode(reservedBuffer.toString(), StandardCharsets.UTF_8.name());
                    isEncoded = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (isEncoded) {
                    result.append((CharSequence)reservedBuffer);
                } else {
                    result.append("%25");
                    result.append(reservedBuffer.substring(1));
                }
                toReserved = false;
                reservedBuffer.setLength(0);
                continue;
            }
            if (character == ' ') {
                result.append("%20");
                continue;
            }
            if (character == '%') {
                result.append("%25");
                continue;
            }
            result.append(toAppend);
        }
        if (toReserved) {
            result.append("%25");
            result.append(reservedBuffer.substring(1));
        }
    }

    private static boolean isList(Object value) {
        return value instanceof ArrayList || value instanceof List;
    }

    private static boolean isMap(Object value) {
        return value instanceof HashMap || value instanceof Map;
    }

    private static SubstitutionType getSubstitutionType(Object value, int col) {
        if (value == null) {
            return SubstitutionType.EMPTY;
        }
        if (StdUriTemplate.isNativeType(value)) {
            return SubstitutionType.STRING;
        }
        if (StdUriTemplate.isList(value)) {
            return SubstitutionType.LIST;
        }
        if (StdUriTemplate.isMap(value)) {
            return SubstitutionType.MAP;
        }
        throw new IllegalArgumentException("Illegal class passed as substitution, found " + value.getClass() + " at col:" + col);
    }

    private static boolean isEmpty(SubstitutionType substType, Object value) {
        if (value == null) {
            return true;
        }
        switch (substType) {
            case STRING: {
                return false;
            }
            case LIST: {
                return ((List)value).isEmpty();
            }
            case MAP: {
                return ((Map)value).isEmpty();
            }
        }
        return true;
    }

    private static boolean isNativeType(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double;
    }

    private static String convertNativeTypes(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return value.toString();
        }
        throw new IllegalArgumentException("Illegal class passed as substitution, found " + value.getClass());
    }

    private static boolean expandToken(Operator operator, String token, boolean composite, int maxChar, boolean firstToken, Map<String, Object> substitutions, StringBuilder result, int col) {
        if (token.isEmpty()) {
            throw new IllegalArgumentException("Found an empty token at col:" + col);
        }
        Object value = substitutions.get(token);
        SubstitutionType substType = StdUriTemplate.getSubstitutionType(value, col);
        if (substType == SubstitutionType.EMPTY || StdUriTemplate.isEmpty(substType, value)) {
            return false;
        }
        if (firstToken) {
            StdUriTemplate.addPrefix(operator, result);
        } else {
            StdUriTemplate.addSeparator(operator, result);
        }
        switch (substType) {
            case STRING: {
                StdUriTemplate.addStringValue(operator, token, value, result, maxChar);
                break;
            }
            case LIST: {
                StdUriTemplate.addListValue(operator, token, (List)value, result, maxChar, composite);
                break;
            }
            case MAP: {
                StdUriTemplate.addMapValue(operator, token, (Map)value, result, maxChar, composite);
            }
        }
        return true;
    }

    private static boolean addStringValue(Operator operator, String token, Object value, StringBuilder result, int maxChar) {
        StdUriTemplate.addValue(operator, token, value, result, maxChar);
        return true;
    }

    private static boolean addListValue(Operator operator, String token, List<Object> value, StringBuilder result, int maxChar, boolean composite) {
        boolean first = true;
        for (Object v : value) {
            if (first) {
                StdUriTemplate.addValue(operator, token, v, result, maxChar);
                first = false;
                continue;
            }
            if (composite) {
                StdUriTemplate.addSeparator(operator, result);
                StdUriTemplate.addValue(operator, token, v, result, maxChar);
                continue;
            }
            result.append(',');
            StdUriTemplate.addValueElement(operator, token, v, result, maxChar);
        }
        return !first;
    }

    private static boolean addMapValue(Operator operator, String token, Map<String, Object> value, StringBuilder result, int maxChar, boolean composite) {
        boolean first = true;
        if (maxChar != -1) {
            throw new IllegalArgumentException("Value trimming is not allowed on Maps");
        }
        for (Map.Entry<String, Object> v : value.entrySet()) {
            if (composite) {
                if (!first) {
                    StdUriTemplate.addSeparator(operator, result);
                }
                StdUriTemplate.addValueElement(operator, token, v.getKey(), result, maxChar);
                result.append('=');
            } else {
                if (first) {
                    StdUriTemplate.addValue(operator, token, v.getKey(), result, maxChar);
                } else {
                    result.append(',');
                    StdUriTemplate.addValueElement(operator, token, v.getKey(), result, maxChar);
                }
                result.append(',');
            }
            StdUriTemplate.addValueElement(operator, token, v.getValue(), result, maxChar);
            first = false;
        }
        return !first;
    }

    static enum SubstitutionType {
        EMPTY,
        STRING,
        LIST,
        MAP;

    }

    private static enum Operator {
        NO_OP,
        PLUS,
        HASH,
        DOT,
        SLASH,
        SEMICOLON,
        QUESTION_MARK,
        AMP;

    }
}

