/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.azure.PolicyViolation;
import com.microsoft.azure.TypedErrorInfo;
import java.io.IOException;
import java.util.Iterator;

public class TypedErrorInfoDeserializer
extends JsonDeserializer<TypedErrorInfo> {
    private static final String TYPE_FIELD_NAME = "type";
    private static final String INFO_FIELD_NAME = "info";

    public TypedErrorInfo deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode errorInfoNode = (JsonNode)p.readValueAsTree();
        if (errorInfoNode == null) {
            return null;
        }
        JsonNode typeNode = errorInfoNode.get(TYPE_FIELD_NAME);
        JsonNode infoNode = errorInfoNode.get(INFO_FIELD_NAME);
        if (typeNode == null || infoNode == null) {
            Iterator fieldNames = errorInfoNode.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                if (typeNode == null && TYPE_FIELD_NAME.equalsIgnoreCase(fieldName)) {
                    typeNode = errorInfoNode.get(fieldName);
                }
                if (infoNode != null || !INFO_FIELD_NAME.equalsIgnoreCase(fieldName)) continue;
                infoNode = errorInfoNode.get(fieldName);
            }
        }
        if (typeNode == null || infoNode == null || !(infoNode instanceof ObjectNode)) {
            return null;
        }
        switch (typeNode.asText()) {
            case "PolicyViolation": {
                return new PolicyViolation(typeNode.asText(), (ObjectNode)infoNode);
            }
        }
        return new TypedErrorInfo(typeNode.asText(), (ObjectNode)infoNode);
    }
}

