/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.util.List;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentCartesianPointDocValuesAggregator;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentGroupingState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SpatialExtentCartesianPointDocValuesGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("minX", ElementType.INT), new IntermediateStateDesc("maxX", ElementType.INT), new IntermediateStateDesc("maxY", ElementType.INT), new IntermediateStateDesc("minY", ElementType.INT));
    private final SpatialExtentGroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public SpatialExtentCartesianPointDocValuesGroupingAggregatorFunction(List<Integer> channels, SpatialExtentGroupingState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static SpatialExtentCartesianPointDocValuesGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new SpatialExtentCartesianPointDocValuesGroupingAggregatorFunction(channels, SpatialExtentCartesianPointDocValuesAggregator.initGrouping(), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final LongBlock vBlock = (LongBlock)page.getBlock(this.channels.get(0));
        final LongVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.maybeEnableGroupIdTracking(seenGroupIds, vBlock);
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    SpatialExtentCartesianPointDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vBlock);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    SpatialExtentCartesianPointDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    SpatialExtentCartesianPointDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                SpatialExtentCartesianPointDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                SpatialExtentCartesianPointDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                SpatialExtentCartesianPointDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, LongBlock vBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || vBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int vStart = vBlock.getFirstValueIndex(valuesPosition);
                int vEnd = vStart + vBlock.getValueCount(valuesPosition);
                for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                    long vValue = vBlock.getLong(vOffset);
                    SpatialExtentCartesianPointDocValuesAggregator.combine(this.state, groupId, vValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, LongVector vVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                long vValue = vVector.getLong(valuesPosition);
                SpatialExtentCartesianPointDocValuesAggregator.combine(this.state, groupId, vValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object minXUncast = page.getBlock(this.channels.get(0));
        if (minXUncast.areAllValuesNull()) {
            return;
        }
        IntVector minX = ((IntBlock)minXUncast).asVector();
        Object maxXUncast = page.getBlock(this.channels.get(1));
        if (maxXUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxX = ((IntBlock)maxXUncast).asVector();
        Object maxYUncast = page.getBlock(this.channels.get(2));
        if (maxYUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxY = ((IntBlock)maxYUncast).asVector();
        Object minYUncast = page.getBlock(this.channels.get(3));
        if (minYUncast.areAllValuesNull()) {
            return;
        }
        IntVector minY = ((IntBlock)minYUncast).asVector();
        assert (minX.getPositionCount() == maxX.getPositionCount() && minX.getPositionCount() == maxY.getPositionCount() && minX.getPositionCount() == minY.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                SpatialExtentCartesianPointDocValuesAggregator.combineIntermediate(this.state, groupId, minX.getInt(valuesPosition), maxX.getInt(valuesPosition), maxY.getInt(valuesPosition), minY.getInt(valuesPosition));
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, LongBlock vBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || vBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int vStart = vBlock.getFirstValueIndex(valuesPosition);
                int vEnd = vStart + vBlock.getValueCount(valuesPosition);
                for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                    long vValue = vBlock.getLong(vOffset);
                    SpatialExtentCartesianPointDocValuesAggregator.combine(this.state, groupId, vValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, LongVector vVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                long vValue = vVector.getLong(valuesPosition);
                SpatialExtentCartesianPointDocValuesAggregator.combine(this.state, groupId, vValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object minXUncast = page.getBlock(this.channels.get(0));
        if (minXUncast.areAllValuesNull()) {
            return;
        }
        IntVector minX = ((IntBlock)minXUncast).asVector();
        Object maxXUncast = page.getBlock(this.channels.get(1));
        if (maxXUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxX = ((IntBlock)maxXUncast).asVector();
        Object maxYUncast = page.getBlock(this.channels.get(2));
        if (maxYUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxY = ((IntBlock)maxYUncast).asVector();
        Object minYUncast = page.getBlock(this.channels.get(3));
        if (minYUncast.areAllValuesNull()) {
            return;
        }
        IntVector minY = ((IntBlock)minYUncast).asVector();
        assert (minX.getPositionCount() == maxX.getPositionCount() && minX.getPositionCount() == maxY.getPositionCount() && minX.getPositionCount() == minY.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                SpatialExtentCartesianPointDocValuesAggregator.combineIntermediate(this.state, groupId, minX.getInt(valuesPosition), maxX.getInt(valuesPosition), maxY.getInt(valuesPosition), minY.getInt(valuesPosition));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, LongBlock vBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            if (vBlock.isNull(valuesPosition)) continue;
            int groupId = groups.getInt(groupPosition);
            int vStart = vBlock.getFirstValueIndex(valuesPosition);
            int vEnd = vStart + vBlock.getValueCount(valuesPosition);
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                long vValue = vBlock.getLong(vOffset);
                SpatialExtentCartesianPointDocValuesAggregator.combine(this.state, groupId, vValue);
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, LongVector vVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            int groupId = groups.getInt(groupPosition);
            long vValue = vVector.getLong(valuesPosition);
            SpatialExtentCartesianPointDocValuesAggregator.combine(this.state, groupId, vValue);
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object minXUncast = page.getBlock(this.channels.get(0));
        if (minXUncast.areAllValuesNull()) {
            return;
        }
        IntVector minX = ((IntBlock)minXUncast).asVector();
        Object maxXUncast = page.getBlock(this.channels.get(1));
        if (maxXUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxX = ((IntBlock)maxXUncast).asVector();
        Object maxYUncast = page.getBlock(this.channels.get(2));
        if (maxYUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxY = ((IntBlock)maxYUncast).asVector();
        Object minYUncast = page.getBlock(this.channels.get(3));
        if (minYUncast.areAllValuesNull()) {
            return;
        }
        IntVector minY = ((IntBlock)minYUncast).asVector();
        assert (minX.getPositionCount() == maxX.getPositionCount() && minX.getPositionCount() == maxY.getPositionCount() && minX.getPositionCount() == minY.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuesPosition = groupPosition + positionOffset;
            SpatialExtentCartesianPointDocValuesAggregator.combineIntermediate(this.state, groupId, minX.getInt(valuesPosition), maxX.getInt(valuesPosition), maxY.getInt(valuesPosition), minY.getInt(valuesPosition));
        }
    }

    private void maybeEnableGroupIdTracking(SeenGroupIds seenGroupIds, LongBlock vBlock) {
        if (vBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        blocks[offset] = SpatialExtentCartesianPointDocValuesAggregator.evaluateFinal(this.state, selected, ctx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

