/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.security.authc.CrossClusterAccessAuthenticationService;
import org.elasticsearch.xpack.security.support.ReloadableSecurityComponent;
import org.elasticsearch.xpack.security.transport.CrossClusterAccessTransportInterceptor;
import org.elasticsearch.xpack.security.transport.CrossClusterApiKeySignatureManager;
import org.elasticsearch.xpack.security.transport.CrossClusterApiKeySigningConfigReloader;
import org.elasticsearch.xpack.security.transport.CrossClusterApiKeySigningSettings;
import org.elasticsearch.xpack.security.transport.extension.RemoteClusterSecurityExtension;

public class CrossClusterAccessSecurityExtension
implements RemoteClusterSecurityExtension,
ReloadableSecurityComponent {
    private static final Logger logger = LogManager.getLogger(CrossClusterAccessSecurityExtension.class);
    private final CrossClusterAccessAuthenticationService authenticationService;
    private final CrossClusterAccessTransportInterceptor transportInterceptor;
    private final CrossClusterApiKeySigningConfigReloader crossClusterApiKeySignerReloader;
    private final CrossClusterApiKeySignatureManager crossClusterApiKeySignatureManager;

    private CrossClusterAccessSecurityExtension(RemoteClusterSecurityExtension.Components components) {
        this.crossClusterApiKeySignerReloader = new CrossClusterApiKeySigningConfigReloader(components.environment(), components.resourceWatcherService(), components.clusterService().getClusterSettings());
        this.crossClusterApiKeySignatureManager = new CrossClusterApiKeySignatureManager(components.environment());
        this.crossClusterApiKeySignerReloader.setSigningConfigLoader(this.crossClusterApiKeySignatureManager);
        this.authenticationService = new CrossClusterAccessAuthenticationService(components.clusterService(), components.apiKeyService(), components.authenticationService());
        this.transportInterceptor = new CrossClusterAccessTransportInterceptor(components.settings(), components.threadPool(), components.authenticationService(), components.authorizationService(), components.securityContext(), this.authenticationService, this.crossClusterApiKeySignatureManager, components.licenseState());
    }

    @Override
    public CrossClusterAccessTransportInterceptor getTransportInterceptor() {
        return this.transportInterceptor;
    }

    @Override
    public CrossClusterAccessAuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    @Override
    public void reload(Settings settings) {
        this.crossClusterApiKeySignerReloader.reload(settings);
    }

    public static class Provider
    implements RemoteClusterSecurityExtension.Provider {
        @Override
        public RemoteClusterSecurityExtension getExtension(RemoteClusterSecurityExtension.Components components) {
            logger.trace("Creating remote cluster security extension for [{}]", CrossClusterAccessSecurityExtension.class);
            return new CrossClusterAccessSecurityExtension(components);
        }

        @Override
        public List<Setting<?>> getSettings() {
            return CrossClusterApiKeySigningSettings.getSettings();
        }
    }
}

