/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.Collection;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.test.AbstractXContentSerializingTestCase;
import org.elasticsearch.test.BWCVersions;
import org.elasticsearch.xcontent.ToXContent;

public abstract class AbstractBWCSerializationTestCase<T extends Writeable & ToXContent>
extends AbstractXContentSerializingTestCase<T> {
    protected abstract T mutateInstanceForVersion(T var1, TransportVersion var2);

    protected Collection<TransportVersion> bwcVersions() {
        return BWCVersions.DEFAULT_BWC_VERSIONS;
    }

    public final void testBwcSerialization() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            Writeable testInstance = (Writeable)this.createTestInstance();
            for (TransportVersion bwcVersion : this.bwcVersions()) {
                this.assertBwcSerialization(testInstance, bwcVersion);
            }
        }
    }

    protected final void assertBwcSerialization(T testInstance, TransportVersion version) throws IOException {
        T deserializedInstance = AbstractBWCSerializationTestCase.copyWriteable(testInstance, this.getNamedWriteableRegistry(), this.instanceReader(), version);
        this.assertOnBWCObject(deserializedInstance, this.mutateInstanceForVersion(testInstance, version), version);
    }

    protected void assertOnBWCObject(T bwcSerializedObject, T testInstance, TransportVersion version) {
        AbstractBWCSerializationTestCase.assertNotSame((String)version.toString(), bwcSerializedObject, testInstance);
        AbstractBWCSerializationTestCase.assertEquals((String)version.toString(), bwcSerializedObject, testInstance);
        AbstractBWCSerializationTestCase.assertEquals((String)version.toString(), (long)bwcSerializedObject.hashCode(), (long)testInstance.hashCode());
    }
}

