/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.session.Configuration;

public class LogicalOptimizerContext {
    private final Configuration configuration;
    private final FoldContext foldCtx;
    private final TransportVersion minimumVersion;

    public LogicalOptimizerContext(Configuration configuration, FoldContext foldCtx, TransportVersion minimumVersion) {
        this.configuration = configuration;
        this.foldCtx = foldCtx;
        this.minimumVersion = minimumVersion;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public FoldContext foldCtx() {
        return this.foldCtx;
    }

    public TransportVersion minimumVersion() {
        return this.minimumVersion;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LogicalOptimizerContext that = (LogicalOptimizerContext)obj;
        return this.configuration.equals(that.configuration) && this.foldCtx.equals((Object)that.foldCtx) && Objects.equals(this.minimumVersion, that.minimumVersion);
    }

    public int hashCode() {
        return Objects.hash(this.configuration, this.foldCtx, this.minimumVersion);
    }

    public String toString() {
        return "LogicalOptimizerContext[configuration=" + String.valueOf(this.configuration) + ", foldCtx=" + String.valueOf(this.foldCtx) + ", minimumVersion=" + String.valueOf(this.minimumVersion) + "]";
    }
}

