/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashBoundedPredicate;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialGridFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohashFromFieldAndLiteralAndLiteralEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohashFromFieldAndLiteralEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohashFromFieldDocValuesAndLiteralAndLiteralEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohashFromFieldDocValuesAndLiteralEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeotile;

public class StGeohash
extends SpatialGridFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "StGeohash", StGeohash::new);
    public static final SpatialGridFunction.UnboundedGrid unboundedGrid = (point, precision) -> Geohash.longEncode((double)point.getX(), (double)point.getY(), (int)StGeohash.checkPrecisionRange(precision));

    private static int checkPrecisionRange(int precision) {
        if (precision < 1 || precision > 12) {
            throw new IllegalArgumentException("Invalid geohash_grid precision of " + precision + ". Must be between 1 and 12.");
        }
        return precision;
    }

    @FunctionInfo(returnType={"geohash"}, preview=true, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW)}, description="Calculates the `geohash` of the supplied geo_point at the specified precision.\nThe result is long encoded. Use [TO_STRING](#esql-to_string) to convert the result to a string,\n[TO_LONG](#esql-to_long) to convert it to a `long`, or [TO_GEOSHAPE](#esql-to_geoshape) to calculate\nthe `geo_shape` bounding geometry.\n\nThese functions are related to the [`geo_grid` query](/reference/query-languages/query-dsl/query-dsl-geo-grid-query.md)\nand the [`geohash_grid` aggregation](/reference/aggregations/search-aggregations-bucket-geohashgrid-aggregation.md).", examples={@Example(file="spatial-grid", tag="st_geohash-grid")})
    public StGeohash(Source source, @Param(name="geometry", type={"geo_point"}, description="Expression of type `geo_point`. If `null`, the function returns `null`.") Expression field, @Param(name="precision", type={"integer"}, description="Expression of type `integer`. If `null`, the function returns `null`.\nValid values are between [1 and 12](https://en.wikipedia.org/wiki/Geohash).") Expression precision, @Param(name="bounds", type={"geo_shape"}, description="Optional bounds to filter the grid tiles, a `geo_shape` of type `BBOX`.\nUse [`ST_ENVELOPE`](#esql-st_envelope) if the `geo_shape` is of any other type.", optional=true) Expression bounds) {
        this(source, field, precision, bounds, false);
    }

    private StGeohash(Source source, Expression field, Expression precision, Expression bounds, boolean spatialDocValues) {
        super(source, field, precision, bounds, spatialDocValues);
    }

    private StGeohash(StreamInput in) throws IOException {
        super(in, false);
    }

    @Override
    public SpatialGridFunction withDocValues(boolean useDocValues) {
        boolean docValues = this.spatialDocsValues || useDocValues;
        return new StGeohash(this.source(), this.spatialField, this.parameter, this.bounds, docValues);
    }

    public String getWriteableName() {
        return StGeohash.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.GEOHASH;
    }

    @Override
    protected SpatialGridFunction replaceChildren(Expression newSpatialField, Expression newParameter, Expression newBounds) {
        return new StGeohash(this.source(), newSpatialField, newParameter, newBounds);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, StGeohash::new, (Object)this.spatialField, (Object)this.parameter, (Object)this.bounds);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        if (!this.parameter().foldable()) {
            throw new IllegalArgumentException("precision must be foldable");
        }
        if (this.bounds != null) {
            if (!this.bounds.foldable()) {
                throw new IllegalArgumentException("bounds must be foldable");
            }
            GeoBoundingBox bbox = StGeohash.asGeoBoundingBox(this.bounds.fold(toEvaluator.foldCtx()));
            int precision = (Integer)this.parameter.fold(toEvaluator.foldCtx());
            GeoHashBoundedGrid.Factory bounds = new GeoHashBoundedGrid.Factory(precision, bbox);
            return this.spatialDocsValues ? new StGeohashFromFieldDocValuesAndLiteralAndLiteralEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField()), bounds::get) : new StGeohashFromFieldAndLiteralAndLiteralEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField), bounds::get);
        }
        int precision = StGeohash.checkPrecisionRange((Integer)this.parameter.fold(toEvaluator.foldCtx()));
        return this.spatialDocsValues ? new StGeohashFromFieldDocValuesAndLiteralEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField()), precision) : new StGeohashFromFieldAndLiteralEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField), precision);
    }

    public Object fold(FoldContext ctx) {
        BytesRef point = (BytesRef)this.spatialField().fold(ctx);
        int precision = (Integer)this.parameter().fold(ctx);
        if (this.bounds() == null) {
            return unboundedGrid.calculateGridId(SpatialCoordinateTypes.GEO.wkbAsPoint(point), precision);
        }
        GeoBoundingBox bbox = StGeohash.asGeoBoundingBox(this.bounds().fold(ctx));
        GeoHashBoundedGrid bounds = new GeoHashBoundedGrid(precision, bbox);
        long gridId = bounds.calculateGridId(SpatialCoordinateTypes.GEO.wkbAsPoint(point));
        return gridId < 0L ? null : Long.valueOf(gridId);
    }

    static void fromFieldAndLiteral(LongBlock.Builder results, int p, BytesRefBlock wkbBlock, int precision) {
        StGeohash.fromWKB(results, p, wkbBlock, precision, unboundedGrid);
    }

    static void fromFieldDocValuesAndLiteral(LongBlock.Builder results, int p, LongBlock encoded, int precision) {
        StGeohash.fromEncodedLong(results, p, encoded, precision, unboundedGrid);
    }

    static void fromFieldAndLiteralAndLiteral(LongBlock.Builder results, int p, BytesRefBlock in, GeoHashBoundedGrid bounds) {
        StGeohash.fromWKB(results, p, in, bounds);
    }

    static void fromFieldDocValuesAndLiteralAndLiteral(LongBlock.Builder results, int p, LongBlock encoded, GeoHashBoundedGrid bounds) {
        StGeohash.fromEncodedLong(results, p, encoded, bounds);
    }

    public static BytesRef toBounds(long gridId) {
        return StGeotile.fromRectangle(Geohash.toBoundingBox((String)Geohash.stringEncode((long)gridId)));
    }

    protected static class GeoHashBoundedGrid
    implements SpatialGridFunction.BoundedGrid {
        private final int precision;
        private final GeoHashBoundedPredicate bounds;

        private GeoHashBoundedGrid(int precision, GeoBoundingBox bbox) {
            this.precision = StGeohash.checkPrecisionRange(precision);
            this.bounds = new GeoHashBoundedPredicate(precision, bbox);
        }

        @Override
        public long calculateGridId(Point point) {
            String geohash = Geohash.stringEncode((double)point.getX(), (double)point.getY(), (int)this.precision);
            if (this.bounds.validHash(geohash)) {
                return Geohash.longEncode((String)geohash);
            }
            return -1L;
        }

        @Override
        public int precision() {
            return this.precision;
        }

        protected static class Factory {
            private final int precision;
            private final GeoBoundingBox bbox;

            Factory(int precision, GeoBoundingBox bbox) {
                this.precision = StGeohash.checkPrecisionRange(precision);
                this.bbox = bbox;
            }

            public GeoHashBoundedGrid get(DriverContext context) {
                return new GeoHashBoundedGrid(this.precision, this.bbox);
            }
        }
    }
}

