/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.transport.Transport;

public abstract class CloseableConnection
extends AbstractRefCounted
implements Transport.Connection {
    private final SubscribableListener<Void> closeContext = new SubscribableListener();
    private final SubscribableListener<Void> removeContext = new SubscribableListener();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean removed = new AtomicBoolean(false);

    @Override
    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(listener);
    }

    @Override
    public void addRemovedListener(ActionListener<Void> listener) {
        this.removeContext.addListener(listener);
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.closeContext.onResponse(null);
        }
    }

    public void closeAndFail(Exception e) {
        if (this.closed.compareAndSet(false, true)) {
            this.closeContext.onFailure(e);
        }
    }

    @Override
    public void onRemoved() {
        if (this.removed.compareAndSet(false, true)) {
            this.removeContext.onResponse(null);
        }
    }

    protected void closeInternal() {
        this.close();
    }
}

