/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.CommunicationException;
import com.microsoft.azure.eventhubs.ConnectionStringBuilder;
import com.microsoft.azure.eventhubs.EventHubClientOptions;
import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.ITokenProvider;
import com.microsoft.azure.eventhubs.ManagedIdentityTokenProvider;
import com.microsoft.azure.eventhubs.OperationCancelledException;
import com.microsoft.azure.eventhubs.ProxyConfiguration;
import com.microsoft.azure.eventhubs.RetryPolicy;
import com.microsoft.azure.eventhubs.TimeoutException;
import com.microsoft.azure.eventhubs.TransportType;
import com.microsoft.azure.eventhubs.impl.AmqpConnection;
import com.microsoft.azure.eventhubs.impl.BaseLinkHandler;
import com.microsoft.azure.eventhubs.impl.CBSChannel;
import com.microsoft.azure.eventhubs.impl.ClientConstants;
import com.microsoft.azure.eventhubs.impl.ClientEntity;
import com.microsoft.azure.eventhubs.impl.ConnectionHandler;
import com.microsoft.azure.eventhubs.impl.DispatchHandler;
import com.microsoft.azure.eventhubs.impl.ExceptionUtil;
import com.microsoft.azure.eventhubs.impl.ManagementChannel;
import com.microsoft.azure.eventhubs.impl.MessageReceiver;
import com.microsoft.azure.eventhubs.impl.OperationResult;
import com.microsoft.azure.eventhubs.impl.ProtonUtil;
import com.microsoft.azure.eventhubs.impl.ReactorDispatcher;
import com.microsoft.azure.eventhubs.impl.ReactorHandler;
import com.microsoft.azure.eventhubs.impl.SchedulerProvider;
import com.microsoft.azure.eventhubs.impl.SessionHandler;
import com.microsoft.azure.eventhubs.impl.SessionProvider;
import com.microsoft.azure.eventhubs.impl.SharedAccessSignatureTokenProvider;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import com.microsoft.azure.eventhubs.impl.Timer;
import java.io.IOException;
import java.nio.channels.UnresolvedAddressException;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.HandlerException;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.reactor.Reactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessagingFactory
extends ClientEntity
implements AmqpConnection,
SessionProvider,
SchedulerProvider {
    public static final Duration DefaultOperationTimeout = Duration.ofSeconds(60L);
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(MessagingFactory.class);
    private final String hostName;
    private final CompletableFuture<Void> closeTask;
    private final ConnectionHandler connectionHandler;
    private final LinkedList<Link> registeredLinks;
    private final Object reactorLock;
    private final Object cbsChannelCreateLock;
    private final Object mgmtChannelCreateLock;
    private final ITokenProvider tokenProvider;
    private final ReactorFactory reactorFactory;
    private static final long WATCHDOG_SCAN_DIVISOR = 2L;
    private final LinkedList<MessageReceiver> watchdogReceivers;
    private final Object watchdogSyncObject;
    private final Duration watchdogTriggerTime;
    private ScheduledFuture<?> watchdogFuture;
    private final long watchdogScanSeconds;
    private boolean watchdogCleanupDone;
    private Reactor reactor;
    private ReactorDispatcher reactorDispatcher;
    private Connection connection;
    private CBSChannel cbsChannel;
    private ManagementChannel mgmtChannel;
    private Duration operationTimeout;
    private RetryPolicy retryPolicy;
    private CompletableFuture<MessagingFactory> open;
    private CompletableFuture<?> openTimer;
    private CompletableFuture<?> closeTimer;
    private String reactorCreationTime;

    MessagingFactory(String hostname, Duration operationTimeout, TransportType transportType, ITokenProvider tokenProvider, RetryPolicy retryPolicy, ScheduledExecutorService executor, ReactorFactory reactorFactory, ProxyConfiguration proxyConfiguration, Duration watchdogTriggerTime, SslDomain.VerifyMode verifyMode) {
        super(StringUtil.getRandomString("MF"), null, executor);
        if (StringUtil.isNullOrWhiteSpace(hostname)) {
            throw new IllegalArgumentException("Endpoint hostname cannot be null or empty");
        }
        Objects.requireNonNull(operationTimeout, "Operation timeout cannot be null.");
        Objects.requireNonNull(transportType, "Transport type cannot be null.");
        Objects.requireNonNull(tokenProvider, "Token provider cannot be null.");
        Objects.requireNonNull(retryPolicy, "Retry policy cannot be null.");
        Objects.requireNonNull(executor, "Executor cannot be null.");
        Objects.requireNonNull(reactorFactory, "Reactor factory cannot be null.");
        this.hostName = hostname;
        this.reactorFactory = reactorFactory;
        this.operationTimeout = operationTimeout;
        this.retryPolicy = retryPolicy;
        this.connectionHandler = ConnectionHandler.create(transportType, this, this.getClientId(), proxyConfiguration, verifyMode);
        this.tokenProvider = tokenProvider;
        this.registeredLinks = new LinkedList();
        this.reactorLock = new Object();
        this.cbsChannelCreateLock = new Object();
        this.mgmtChannelCreateLock = new Object();
        this.watchdogTriggerTime = watchdogTriggerTime;
        this.watchdogScanSeconds = watchdogTriggerTime.toMillis() / 2L / 1000L;
        this.watchdogReceivers = new LinkedList();
        this.watchdogSyncObject = new Object();
        this.closeTask = new CompletableFuture();
    }

    public static CompletableFuture<MessagingFactory> createFromConnectionString(String connectionString, ScheduledExecutorService executor) throws IOException {
        return MessagingFactory.createFromConnectionString(connectionString, null, executor, null);
    }

    public static CompletableFuture<MessagingFactory> createFromConnectionString(String connectionString, RetryPolicy retryPolicy, ScheduledExecutorService executor, ProxyConfiguration proxyConfiguration) throws IOException {
        return MessagingFactory.createFromConnectionString(connectionString, retryPolicy, executor, null, proxyConfiguration, EventHubClientOptions.SILENT_OFF);
    }

    public static CompletableFuture<MessagingFactory> createFromConnectionString(String connectionString, RetryPolicy retryPolicy, ScheduledExecutorService executor, ProxyConfiguration proxyConfiguration, Duration watchdogTriggerTime) throws IOException {
        return MessagingFactory.createFromConnectionString(connectionString, retryPolicy, executor, null, proxyConfiguration, watchdogTriggerTime);
    }

    public static CompletableFuture<MessagingFactory> createFromConnectionString(String connectionString, RetryPolicy retryPolicy, ScheduledExecutorService executor, ReactorFactory reactorFactory, ProxyConfiguration proxyConfiguration, Duration watchdogTriggerTime) throws IOException {
        ConnectionStringBuilder csb = new ConnectionStringBuilder(connectionString);
        ITokenProvider tokenProvider = null;
        if (!StringUtil.isNullOrWhiteSpace(csb.getSharedAccessSignature())) {
            tokenProvider = new SharedAccessSignatureTokenProvider(csb.getSharedAccessSignature());
        } else if (!StringUtil.isNullOrWhiteSpace(csb.getSasKey())) {
            tokenProvider = new SharedAccessSignatureTokenProvider(csb.getSasKeyName(), csb.getSasKey());
        } else if (csb.getAuthentication() != null && csb.getAuthentication().equalsIgnoreCase("Managed Identity")) {
            tokenProvider = new ManagedIdentityTokenProvider();
        } else {
            throw new IllegalArgumentException("Connection string must specify a Shared Access Signature, Shared Access Key, or Managed Identity");
        }
        MessagingFactoryBuilder builder = new MessagingFactoryBuilder(csb.getEndpoint().getHost(), tokenProvider, executor).setOperationTimeout(csb.getOperationTimeout()).setTransportType(csb.getTransportType()).setRetryPolicy(retryPolicy).setReactorFactory(reactorFactory).setProxyConfiguration(proxyConfiguration).setWatchdogTriggerTime(watchdogTriggerTime);
        return builder.build();
    }

    private static CompletableFuture<MessagingFactory> factoryStartup(final MessagingFactory messagingFactory) throws IOException {
        messagingFactory.createConnection();
        messagingFactory.startWatchdog();
        Timer timer = new Timer(messagingFactory);
        messagingFactory.openTimer = timer.schedule(new Runnable(){

            @Override
            public void run() {
                if (!messagingFactory.open.isDone()) {
                    messagingFactory.open.completeExceptionally(new TimeoutException("Opening MessagingFactory timed out."));
                    messagingFactory.getReactor().stop();
                }
            }
        }, messagingFactory.getOperationTimeout());
        messagingFactory.openTimer.handleAsync((unUsed, exception) -> {
            if (exception != null && !(exception instanceof CancellationException)) {
                messagingFactory.open.completeExceptionally((Throwable)exception);
                messagingFactory.getReactor().stop();
            }
            return null;
        }, (Executor)messagingFactory.executor);
        return messagingFactory.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForWatchdog(MessageReceiver rcvr) {
        if (this.watchdogTriggerTime.compareTo(EventHubClientOptions.SILENT_OFF) > 0) {
            TRACE_LOGGER.info("Registering for watchdog: " + rcvr.getClientId());
            Object object = this.watchdogSyncObject;
            synchronized (object) {
                this.watchdogReceivers.add(rcvr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForWatchdog(MessageReceiver rcvr) {
        if (this.watchdogTriggerTime.compareTo(EventHubClientOptions.SILENT_OFF) > 0) {
            TRACE_LOGGER.info("Unregistering for watchdog: " + rcvr.getClientId());
            Object object = this.watchdogSyncObject;
            synchronized (object) {
                this.watchdogReceivers.remove(rcvr);
            }
        }
    }

    private void startWatchdog() {
        if (this.watchdogTriggerTime.compareTo(EventHubClientOptions.SILENT_OFF) > 0) {
            TRACE_LOGGER.info("Watchdog scheduling first run in " + this.watchdogScanSeconds + " seconds");
            this.watchdogFuture = this.executor.schedule(new WatchDog(), this.watchdogScanSeconds, TimeUnit.SECONDS);
        } else {
            TRACE_LOGGER.info("Watchdog is OFF");
        }
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reactor getReactor() {
        Object object = this.reactorLock;
        synchronized (object) {
            return this.reactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReactorDispatcher getReactorDispatcher() {
        Object object = this.reactorLock;
        synchronized (object) {
            return this.reactorDispatcher;
        }
    }

    public ITokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    private void createConnection() throws IOException {
        this.open = new CompletableFuture();
        this.startReactor(new ReactorHandlerWithConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReactor(ReactorHandler reactorHandler) throws IOException {
        Reactor newReactor = this.reactorFactory.create(reactorHandler, this.connectionHandler.getMaxFrameSize(), this.getClientId());
        Object object = this.reactorLock;
        synchronized (object) {
            this.reactor = newReactor;
            this.reactorDispatcher = new ReactorDispatcher(newReactor);
            reactorHandler.unsafeSetReactorDispatcher(this.reactorDispatcher);
        }
        this.reactorCreationTime = Instant.now().toString();
        this.executor.execute(new RunReactor(newReactor, this.executor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CBSChannel getCBSChannel() {
        Object object = this.cbsChannelCreateLock;
        synchronized (object) {
            if (this.cbsChannel == null) {
                this.cbsChannel = new CBSChannel(this, this, this.getClientId(), this.executor);
            }
        }
        return this.cbsChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagementChannel getManagementChannel() {
        Object object = this.mgmtChannelCreateLock;
        synchronized (object) {
            if (this.mgmtChannel == null) {
                this.mgmtChannel = new ManagementChannel(this, this, this.getClientId(), this.executor);
            }
        }
        return this.mgmtChannel;
    }

    @Override
    public Session getSession(String path, Consumer<Session> onRemoteSessionOpen, BiConsumer<ErrorCondition, Exception> onRemoteSessionOpenError) {
        if (this.getIsClosingOrClosed()) {
            onRemoteSessionOpenError.accept(null, new OperationCancelledException("underlying messagingFactory instance is closed"));
            return null;
        }
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "messagingFactory[%s], hostName[%s], getting a session.", this.getClientId(), this.getHostName()));
        }
        if (this.connection == null || this.connection.getLocalState() == EndpointState.CLOSED || this.connection.getRemoteState() == EndpointState.CLOSED) {
            this.connection = this.getReactor().connectionToHost(this.connectionHandler.getRemoteHostName(), this.connectionHandler.getRemotePort(), (Handler)this.connectionHandler);
        }
        Session session = this.connection.session();
        BaseHandler.setHandler((Extendable)session, (Handler)new SessionHandler(path, onRemoteSessionOpen, onRemoteSessionOpenError, this.operationTimeout, this.getClientId()));
        session.open();
        return session;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Override
    public void onOpenComplete(Exception exception) {
        if (exception == null) {
            this.open.complete(this);
            if (this.getIsClosingOrClosed()) {
                this.connection.close();
            }
        } else {
            this.open.completeExceptionally(exception);
        }
        if (this.openTimer != null) {
            this.openTimer.cancel(false);
        }
    }

    @Override
    public void onConnectionError(ErrorCondition error) {
        this.watchdogCleanupDone = true;
        if (TRACE_LOGGER.isWarnEnabled()) {
            TRACE_LOGGER.warn(String.format(Locale.US, "onConnectionError messagingFactory[%s], hostname[%s], error[%s]", this.getClientId(), this.hostName, error != null ? error.getDescription() : "n/a"));
        }
        if (!this.open.isDone()) {
            if (TRACE_LOGGER.isWarnEnabled()) {
                TRACE_LOGGER.warn(String.format(Locale.US, "onConnectionError messagingFactory[%s], hostname[%s], open hasn't complete, stopping the reactor", this.getClientId(), this.hostName));
            }
            this.getReactor().stop();
            this.onOpenComplete(ExceptionUtil.toException(error));
        } else {
            Connection oldConnection = this.connection;
            LinkedList<Link> oldRegisteredLinksCopy = new LinkedList<Link>(this.registeredLinks);
            LinkedList<Link> closedLinks = new LinkedList<Link>();
            for (Link link : oldRegisteredLinksCopy) {
                if (link.getLocalState() == EndpointState.CLOSED) continue;
                if (TRACE_LOGGER.isWarnEnabled()) {
                    TRACE_LOGGER.warn(String.format(Locale.US, "onConnectionError messagingFactory[%s], hostname[%s], closing link [%s]", this.getClientId(), this.hostName, link.getName()));
                }
                link.setCondition(error);
                link.close();
                closedLinks.add(link);
            }
            if (oldConnection.getLocalState() != EndpointState.CLOSED) {
                if (TRACE_LOGGER.isWarnEnabled()) {
                    TRACE_LOGGER.warn(String.format(Locale.US, "onConnectionError messagingFactory[%s], hostname[%s], closing current connection", this.getClientId(), this.hostName));
                }
                oldConnection.setCondition(error);
                oldConnection.close();
            }
            for (Link link : closedLinks) {
                Handler handler = BaseHandler.getHandler((Extendable)link);
                if (!(handler instanceof BaseLinkHandler)) continue;
                BaseLinkHandler linkHandler = (BaseLinkHandler)handler;
                linkHandler.processOnClose(link, error);
            }
        }
        if (this.getIsClosingOrClosed() && !this.closeTask.isDone()) {
            this.getReactor().stop();
        }
    }

    private void onReactorError(Exception cause) {
        if (!this.open.isDone()) {
            this.onOpenComplete(cause);
        } else {
            if (this.getIsClosingOrClosed()) {
                return;
            }
            TRACE_LOGGER.warn(String.format(Locale.US, "onReactorError messagingFactory[%s], hostName[%s], error[%s]", this.getClientId(), this.getHostName(), cause.getMessage()));
            Connection oldConnection = this.connection;
            LinkedList<Link> oldRegisteredLinksCopy = new LinkedList<Link>(this.registeredLinks);
            try {
                TRACE_LOGGER.info(String.format(Locale.US, "onReactorError messagingFactory[%s], hostName[%s], message[%s]", this.getClientId(), this.getHostName(), "starting new reactor"));
                this.startReactor(new ReactorHandlerWithConnection());
            }
            catch (IOException e) {
                TRACE_LOGGER.error(String.format(Locale.US, "messagingFactory[%s], hostName[%s], error[%s]", this.getClientId(), this.getHostName(), ExceptionUtil.toStackTraceString(e, "Re-starting reactor failed with error")));
                this.onReactorError(cause);
            }
            ErrorCondition errorCondition = new ErrorCondition(Symbol.getSymbol((String)"messagingfactory.onreactorerror"), cause.getMessage());
            if (oldConnection.getLocalState() != EndpointState.CLOSED) {
                if (TRACE_LOGGER.isWarnEnabled()) {
                    TRACE_LOGGER.warn(String.format(Locale.US, "onReactorError: messagingFactory[%s], hostname[%s], closing current connection", this.getClientId(), this.hostName));
                }
                oldConnection.setCondition(errorCondition);
                oldConnection.close();
            }
            for (Link link : oldRegisteredLinksCopy) {
                Handler handler;
                if (link.getLocalState() != EndpointState.CLOSED) {
                    link.setCondition(errorCondition);
                    link.close();
                }
                if (!((handler = BaseHandler.getHandler((Extendable)link)) instanceof BaseLinkHandler)) continue;
                BaseLinkHandler linkHandler = (BaseLinkHandler)handler;
                linkHandler.processOnClose(link, cause);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<Void> onClose() {
        if (!this.getIsClosed()) {
            Object object = this.watchdogSyncObject;
            synchronized (object) {
                if (this.watchdogFuture != null) {
                    this.watchdogFuture.cancel(true);
                }
            }
            Timer timer = new Timer(this);
            this.closeTimer = timer.schedule(new Runnable(){

                @Override
                public void run() {
                    if (!MessagingFactory.this.closeTask.isDone()) {
                        MessagingFactory.this.closeTask.completeExceptionally(new TimeoutException("Closing MessagingFactory timed out."));
                        MessagingFactory.this.getReactor().stop();
                    }
                }
            }, this.operationTimeout);
            if (this.closeTimer.isCompletedExceptionally()) {
                this.closeTask.completeExceptionally(ExceptionUtil.getExceptionFromCompletedFuture(this.closeTimer));
            } else {
                try {
                    this.scheduleOnReactorThread(new CloseWork());
                }
                catch (IOException | RejectedExecutionException schedulerException) {
                    this.closeTask.completeExceptionally(schedulerException);
                }
            }
        }
        return this.closeTask;
    }

    @Override
    public void registerForConnectionError(Link link) {
        this.registeredLinks.add(link);
    }

    @Override
    public void deregisterForConnectionError(Link link) {
        this.registeredLinks.remove(link);
    }

    public void scheduleOnReactorThread(DispatchHandler handler) throws IOException, RejectedExecutionException {
        this.getReactorDispatcher().invoke(handler);
    }

    public void scheduleOnReactorThread(int delay, DispatchHandler handler) throws IOException, RejectedExecutionException {
        this.getReactorDispatcher().invoke(delay, handler);
    }

    private class ReactorHandlerWithConnection
    extends ReactorHandler {
        ReactorHandlerWithConnection() {
            super(MessagingFactory.this.getClientId());
        }

        @Override
        public void onReactorInit(Event e) {
            super.onReactorInit(e);
            Reactor r = e.getReactor();
            MessagingFactory.this.connection = r.connectionToHost(MessagingFactory.this.connectionHandler.getRemoteHostName(), MessagingFactory.this.connectionHandler.getRemotePort(), (Handler)MessagingFactory.this.connectionHandler);
        }
    }

    private class RunReactor
    implements Runnable {
        private final Reactor rctr;
        private final ScheduledExecutorService executor;
        volatile boolean hasStarted;

        RunReactor(Reactor reactor, ScheduledExecutorService executor) {
            this.rctr = reactor;
            this.executor = executor;
            this.hasStarted = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean reScheduledReactor = false;
            try {
                if (!this.hasStarted) {
                    if (TRACE_LOGGER.isInfoEnabled()) {
                        TRACE_LOGGER.info(String.format(Locale.US, "messagingFactory[%s], hostName[%s], info[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), "starting reactor instance."));
                    }
                    this.rctr.start();
                    this.hasStarted = true;
                }
                if (!Thread.interrupted() && this.rctr.process()) {
                    try {
                        this.executor.execute(this);
                        reScheduledReactor = true;
                    }
                    catch (RejectedExecutionException exception) {
                        if (TRACE_LOGGER.isWarnEnabled()) {
                            TRACE_LOGGER.warn(String.format(Locale.US, "messagingFactory[%s], hostName[%s], error[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), ExceptionUtil.toStackTraceString(exception, "scheduling reactor failed because the executor has been shut down")));
                        }
                        this.rctr.attachments().set(RejectedExecutionException.class, RejectedExecutionException.class, (Object)exception);
                    }
                    return;
                }
                if (TRACE_LOGGER.isWarnEnabled()) {
                    TRACE_LOGGER.warn(String.format(Locale.US, "messagingFactory[%s], hostName[%s], message[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), "stopping the reactor because thread was interrupted or the reactor has no more events to process."));
                }
                this.rctr.stop();
            }
            catch (HandlerException handlerException) {
                Throwable cause = handlerException.getCause();
                if (cause == null) {
                    cause = handlerException;
                }
                if (TRACE_LOGGER.isWarnEnabled()) {
                    TRACE_LOGGER.warn(String.format(Locale.US, "messagingFactory[%s], hostName[%s], error[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), ExceptionUtil.toStackTraceString(handlerException, "Unhandled exception while processing events in reactor, report this error.")));
                }
                String message = !StringUtil.isNullOrEmpty(cause.getMessage()) ? cause.getMessage() : (!StringUtil.isNullOrEmpty(handlerException.getMessage()) ? handlerException.getMessage() : "Reactor encountered unrecoverable error");
                EventHubException sbException = cause instanceof UnresolvedAddressException ? new CommunicationException(String.format(Locale.US, "%s. This is usually caused by incorrect hostname or network configuration. Check correctness of namespace information. %s", message, ExceptionUtil.getTrackingIDAndTimeToLog()), cause) : new EventHubException(true, String.format(Locale.US, "%s, %s", message, ExceptionUtil.getTrackingIDAndTimeToLog()), cause);
                MessagingFactory.this.onReactorError(sbException);
            }
            finally {
                if (reScheduledReactor) {
                    return;
                }
                if (MessagingFactory.this.getIsClosingOrClosed() && !MessagingFactory.this.closeTask.isDone()) {
                    this.rctr.free();
                    MessagingFactory.this.closeTask.complete(null);
                    if (MessagingFactory.this.closeTimer != null) {
                        MessagingFactory.this.closeTimer.cancel(false);
                    }
                } else {
                    this.scheduleCompletePendingTasks();
                }
            }
        }

        private void scheduleCompletePendingTasks() {
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    if (TRACE_LOGGER.isWarnEnabled()) {
                        TRACE_LOGGER.warn(String.format(Locale.US, "messagingFactory[%s], hostName[%s], message[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), "Processing all pending tasks and closing old reactor."));
                    }
                    try {
                        RunReactor.this.rctr.stop();
                        RunReactor.this.rctr.process();
                    }
                    catch (HandlerException e) {
                        if (TRACE_LOGGER.isWarnEnabled()) {
                            TRACE_LOGGER.warn(String.format(Locale.US, "messagingFactory[%s], hostName[%s], error[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), ExceptionUtil.toStackTraceString(e, "scheduleCompletePendingTasks - exception occurred while processing events.")));
                        }
                    }
                    finally {
                        RunReactor.this.rctr.free();
                    }
                }
            }, MessagingFactory.this.getOperationTimeout().getSeconds(), TimeUnit.SECONDS);
        }
    }

    private class CloseWork
    extends DispatchHandler {
        private CloseWork() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent() {
            ReactorDispatcher dispatcher = MessagingFactory.this.getReactorDispatcher();
            Object object = MessagingFactory.this.cbsChannelCreateLock;
            synchronized (object) {
                if (MessagingFactory.this.cbsChannel != null) {
                    MessagingFactory.this.cbsChannel.close(dispatcher, new OperationResult<Void, Exception>(){

                        @Override
                        public void onComplete(Void result) {
                            if (TRACE_LOGGER.isInfoEnabled()) {
                                TRACE_LOGGER.info(String.format(Locale.US, "messagingFactory[%s], hostName[%s], info[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), "cbsChannel closed"));
                            }
                        }

                        @Override
                        public void onError(Exception error) {
                            if (TRACE_LOGGER.isWarnEnabled()) {
                                TRACE_LOGGER.warn(String.format(Locale.US, "messagingFactory[%s], hostName[%s], cbsChannelCloseError[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), error.getMessage()));
                            }
                        }
                    });
                }
            }
            object = MessagingFactory.this.mgmtChannelCreateLock;
            synchronized (object) {
                if (MessagingFactory.this.mgmtChannel != null) {
                    MessagingFactory.this.mgmtChannel.close(dispatcher, new OperationResult<Void, Exception>(){

                        @Override
                        public void onComplete(Void result) {
                            if (TRACE_LOGGER.isInfoEnabled()) {
                                TRACE_LOGGER.info(String.format(Locale.US, "messagingFactory[%s], hostName[%s], info[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), "mgmtChannel closed"));
                            }
                        }

                        @Override
                        public void onError(Exception error) {
                            if (TRACE_LOGGER.isWarnEnabled()) {
                                TRACE_LOGGER.warn(String.format(Locale.US, "messagingFactory[%s], hostName[%s], mgmtChannelCloseError[%s]", MessagingFactory.this.getClientId(), MessagingFactory.this.getHostName(), error.getMessage()));
                            }
                        }
                    });
                }
            }
            if (MessagingFactory.this.connection != null && MessagingFactory.this.connection.getRemoteState() != EndpointState.CLOSED && MessagingFactory.this.connection.getLocalState() != EndpointState.CLOSED) {
                MessagingFactory.this.connection.close();
            }
        }
    }

    public static class ReactorFactory {
        public Reactor create(ReactorHandler reactorHandler, int maxFrameSize, String name) throws IOException {
            return ProtonUtil.reactor(reactorHandler, maxFrameSize, name);
        }
    }

    private class WatchDog
    implements Runnable {
        private WatchDog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TRACE_LOGGER.debug("Watchdog run");
            if (MessagingFactory.this.getIsClosingOrClosed()) {
                return;
            }
            LinkedList copiedList = null;
            Object object = MessagingFactory.this.watchdogSyncObject;
            synchronized (object) {
                copiedList = new LinkedList(MessagingFactory.this.watchdogReceivers);
            }
            if (!copiedList.isEmpty()) {
                boolean anyReceiverIsAlive = false;
                long longestAgoAllowable = Instant.now().getEpochSecond() - MessagingFactory.this.watchdogTriggerTime.toMillis() / 1000L;
                for (MessageReceiver rcvr : copiedList) {
                    TRACE_LOGGER.debug("Watchdog checking receiver " + rcvr.getClientId() + " last: " + rcvr.getLastReceivedTime() + "  allowable: " + longestAgoAllowable);
                    if (rcvr.getIsClosingOrClosed() || rcvr.getLastReceivedTime() < longestAgoAllowable) continue;
                    anyReceiverIsAlive = true;
                    break;
                }
                if (!anyReceiverIsAlive && !MessagingFactory.this.getIsClosingOrClosed()) {
                    TRACE_LOGGER.warn("Watchdog forcing connection closed");
                    ErrorCondition suspect = new ErrorCondition(ClientConstants.WATCHDOG_ERROR, "receiver watchdog has fired, all receivers silent");
                    MessagingFactory.this.watchdogCleanupDone = false;
                    MessagingFactory.this.connection.setCondition(suspect);
                    MessagingFactory.this.connection.close();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!MessagingFactory.this.watchdogCleanupDone) {
                        TRACE_LOGGER.warn("Watchdog forcing cleanup");
                        MessagingFactory.this.onConnectionError(suspect);
                    } else {
                        TRACE_LOGGER.info("Watchdog cleanup already in progress");
                    }
                }
            }
            Object object2 = MessagingFactory.this.watchdogSyncObject;
            synchronized (object2) {
                if (!MessagingFactory.this.getIsClosingOrClosed() && !MessagingFactory.this.watchdogFuture.isCancelled()) {
                    TRACE_LOGGER.debug("Watchdog scheduling next run");
                    MessagingFactory.this.watchdogFuture = MessagingFactory.this.executor.schedule(this, MessagingFactory.this.watchdogScanSeconds, TimeUnit.SECONDS);
                } else {
                    TRACE_LOGGER.info("Watchdog stopping due to MessagingFactory close");
                }
            }
        }
    }

    public static class MessagingFactoryBuilder {
        private final String hostname;
        private final ITokenProvider tokenProvider;
        private final ScheduledExecutorService executor;
        private Duration operationTimeout = DefaultOperationTimeout;
        private TransportType transportType = TransportType.AMQP;
        private RetryPolicy retryPolicy = RetryPolicy.getDefault();
        private ReactorFactory reactorFactory = new ReactorFactory();
        private ProxyConfiguration proxyConfiguration;
        private Duration watchdogTriggerTime = EventHubClientOptions.SILENT_OFF;
        private SslDomain.VerifyMode verifyMode;

        public MessagingFactoryBuilder(String hostname, ITokenProvider tokenProvider, ScheduledExecutorService executor) {
            if (StringUtil.isNullOrWhiteSpace(hostname)) {
                throw new IllegalArgumentException("Endpoint hostname cannot be null or empty");
            }
            this.hostname = hostname;
            this.tokenProvider = Objects.requireNonNull(tokenProvider);
            this.executor = Objects.requireNonNull(executor);
        }

        public MessagingFactoryBuilder setOperationTimeout(Duration operationTimeout) {
            if (operationTimeout != null) {
                this.operationTimeout = operationTimeout;
            }
            return this;
        }

        public MessagingFactoryBuilder setTransportType(TransportType transportType) {
            if (transportType != null) {
                this.transportType = transportType;
            }
            return this;
        }

        public MessagingFactoryBuilder setRetryPolicy(RetryPolicy retryPolicy) {
            if (retryPolicy != null) {
                this.retryPolicy = retryPolicy;
            }
            return this;
        }

        public MessagingFactoryBuilder setReactorFactory(ReactorFactory reactorFactory) {
            if (reactorFactory != null) {
                this.reactorFactory = reactorFactory;
            }
            return this;
        }

        public MessagingFactoryBuilder setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public MessagingFactoryBuilder setWatchdogTriggerTime(Duration watchdogTriggerTime) {
            this.watchdogTriggerTime = watchdogTriggerTime;
            return this;
        }

        MessagingFactoryBuilder setVerifyMode(SslDomain.VerifyMode verifyMode) {
            this.verifyMode = verifyMode;
            return this;
        }

        public CompletableFuture<MessagingFactory> build() throws IOException {
            SslDomain.VerifyMode mode = this.verifyMode != null ? this.verifyMode : SslDomain.VerifyMode.VERIFY_PEER_NAME;
            MessagingFactory messagingFactory = new MessagingFactory(this.hostname, this.operationTimeout, this.transportType, this.tokenProvider, this.retryPolicy, this.executor, this.reactorFactory, this.proxyConfiguration, this.watchdogTriggerTime, mode);
            return MessagingFactory.factoryStartup(messagingFactory);
        }
    }
}

