/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.comparators.DoubleComparator;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.LeafPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.plain.LatLonPointIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.GeoValidationMethod;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortFieldAndFormat;
import org.elasticsearch.search.sort.SortMode;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class GeoDistanceSortBuilder
extends SortBuilder<GeoDistanceSortBuilder> {
    public static final String NAME = "_geo_distance";
    public static final String ALTERNATIVE_NAME = "_geoDistance";
    public static final GeoValidationMethod DEFAULT_VALIDATION = GeoValidationMethod.DEFAULT;
    private static final ParseField UNIT_FIELD = new ParseField("unit", new String[0]);
    private static final ParseField DISTANCE_TYPE_FIELD = new ParseField("distance_type", new String[0]);
    private static final ParseField VALIDATION_METHOD_FIELD = new ParseField("validation_method", new String[0]);
    private static final ParseField SORTMODE_FIELD = new ParseField("mode", "sort_mode");
    private static final ParseField IGNORE_UNMAPPED = new ParseField("ignore_unmapped", new String[0]);
    private final String fieldName;
    private final List<GeoPoint> points = new ArrayList<GeoPoint>();
    private GeoDistance geoDistance = GeoDistance.ARC;
    private DistanceUnit unit = DistanceUnit.DEFAULT;
    private SortMode sortMode = null;
    private NestedSortBuilder nestedSort;
    private GeoValidationMethod validation = DEFAULT_VALIDATION;
    private boolean ignoreUnmapped = false;

    public GeoDistanceSortBuilder(String fieldName, GeoPoint ... points) {
        this.fieldName = fieldName;
        if (points.length == 0) {
            throw new IllegalArgumentException("Geo distance sorting needs at least one point.");
        }
        this.points.addAll(Arrays.asList(points));
    }

    public GeoDistanceSortBuilder(String fieldName, double lat, double lon) {
        this(fieldName, new GeoPoint(lat, lon));
    }

    public GeoDistanceSortBuilder(String fieldName, String ... geohashes) {
        if (geohashes.length == 0) {
            throw new IllegalArgumentException("Geo distance sorting needs at least one point.");
        }
        for (String geohash : geohashes) {
            this.points.add(GeoPoint.fromGeohash(geohash));
        }
        this.fieldName = fieldName;
    }

    GeoDistanceSortBuilder(GeoDistanceSortBuilder original) {
        this.fieldName = original.fieldName();
        this.points.addAll(original.points);
        this.geoDistance = original.geoDistance;
        this.unit = original.unit;
        this.order = original.order;
        this.sortMode = original.sortMode;
        this.validation = original.validation;
        this.nestedSort = original.nestedSort;
        this.ignoreUnmapped = original.ignoreUnmapped;
    }

    public GeoDistanceSortBuilder(StreamInput in) throws IOException {
        this.fieldName = in.readString();
        this.points.addAll((List)in.readGenericValue());
        this.geoDistance = GeoDistance.readFromStream(in);
        this.unit = DistanceUnit.readFromStream(in);
        this.order = SortOrder.readFromStream(in);
        this.sortMode = in.readOptionalWriteable(SortMode::readFromStream);
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0) && (in.readOptionalNamedWriteable(QueryBuilder.class) != null || in.readOptionalString() != null)) {
            throw new IOException("the [sort] options [nested_path] and [nested_filter] are removed in 8.x, please use [nested] instead");
        }
        this.nestedSort = in.readOptionalWriteable(NestedSortBuilder::new);
        this.validation = GeoValidationMethod.readFromStream(in);
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.points);
        this.geoDistance.writeTo(out);
        this.unit.writeTo(out);
        this.order.writeTo(out);
        out.writeOptionalWriteable(this.sortMode);
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeOptionalNamedWriteable(null);
            out.writeOptionalString(null);
        }
        out.writeOptionalWriteable(this.nestedSort);
        this.validation.writeTo(out);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public GeoDistanceSortBuilder point(double lat, double lon) {
        this.points.add(new GeoPoint(lat, lon));
        return this;
    }

    public GeoDistanceSortBuilder points(GeoPoint ... points) {
        this.points.addAll(Arrays.asList(points));
        return this;
    }

    public GeoPoint[] points() {
        return this.points.toArray(new GeoPoint[this.points.size()]);
    }

    public GeoDistanceSortBuilder geoDistance(GeoDistance geoDistance) {
        this.geoDistance = geoDistance;
        return this;
    }

    public GeoDistance geoDistance() {
        return this.geoDistance;
    }

    public GeoDistanceSortBuilder unit(DistanceUnit unit) {
        this.unit = unit;
        return this;
    }

    public DistanceUnit unit() {
        return this.unit;
    }

    public GeoDistanceSortBuilder validation(GeoValidationMethod method) {
        this.validation = method;
        return this;
    }

    public GeoValidationMethod validation() {
        return this.validation;
    }

    public GeoDistanceSortBuilder sortMode(SortMode sortMode) {
        Objects.requireNonNull(sortMode, "sort mode cannot be null");
        if (sortMode == SortMode.SUM) {
            throw new IllegalArgumentException("sort_mode [sum] isn't supported for sorting by geo distance");
        }
        this.sortMode = sortMode;
        return this;
    }

    public SortMode sortMode() {
        return this.sortMode;
    }

    public NestedSortBuilder getNestedSort() {
        return this.nestedSort;
    }

    public GeoDistanceSortBuilder setNestedSort(NestedSortBuilder nestedSort) {
        this.nestedSort = nestedSort;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    public GeoDistanceSortBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.startArray(this.fieldName);
        for (GeoPoint point : this.points) {
            builder.value(point);
        }
        builder.endArray();
        builder.field(UNIT_FIELD.getPreferredName(), this.unit);
        builder.field(DISTANCE_TYPE_FIELD.getPreferredName(), this.geoDistance.name().toLowerCase(Locale.ROOT));
        builder.field(ORDER_FIELD.getPreferredName(), this.order);
        if (this.sortMode != null) {
            builder.field(SORTMODE_FIELD.getPreferredName(), this.sortMode);
        }
        if (this.nestedSort != null) {
            builder.field(NestedSortBuilder.NESTED_FIELD.getPreferredName(), this.nestedSort);
        }
        builder.field(VALIDATION_METHOD_FIELD.getPreferredName(), this.validation);
        builder.field(IGNORE_UNMAPPED.getPreferredName(), this.ignoreUnmapped);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GeoDistanceSortBuilder other = (GeoDistanceSortBuilder)object;
        return Objects.equals(this.fieldName, other.fieldName) && Objects.deepEquals(this.points, other.points) && Objects.equals(this.geoDistance, other.geoDistance) && Objects.equals(this.unit, other.unit) && Objects.equals(this.sortMode, other.sortMode) && Objects.equals(this.order, other.order) && Objects.equals(this.validation, other.validation) && Objects.equals(this.nestedSort, other.nestedSort) && this.ignoreUnmapped == other.ignoreUnmapped;
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.points, this.geoDistance, this.unit, this.sortMode, this.order, this.validation, this.nestedSort, this.ignoreUnmapped);
    }

    public static GeoDistanceSortBuilder fromXContent(XContentParser parser, String elementName) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
        DistanceUnit unit = DistanceUnit.DEFAULT;
        GeoDistance geoDistance = GeoDistance.ARC;
        SortOrder order = SortOrder.ASC;
        SortMode sortMode = null;
        NestedSortBuilder nestedSort = null;
        GeoValidationMethod validation = null;
        boolean ignoreUnmapped = false;
        String currentName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                GeoDistanceSortBuilder.parseGeoPoints(parser, geoPoints);
                fieldName = currentName;
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (NestedSortBuilder.NESTED_FIELD.match(currentName, parser.getDeprecationHandler())) {
                    nestedSort = NestedSortBuilder.fromXContent(parser);
                    continue;
                }
                if (fieldName != null && !fieldName.equals(currentName)) {
                    throw new ParsingException(parser.getTokenLocation(), "Trying to reset fieldName to [{}], already set to [{}].", currentName, fieldName);
                }
                fieldName = currentName;
                geoPoints.add(GeoUtils.parseGeoPoint(parser));
                continue;
            }
            if (!token.isValue()) continue;
            if (ORDER_FIELD.match(currentName, parser.getDeprecationHandler())) {
                order = SortOrder.fromString(parser.text());
                continue;
            }
            if (UNIT_FIELD.match(currentName, parser.getDeprecationHandler())) {
                unit = DistanceUnit.fromString(parser.text());
                continue;
            }
            if (DISTANCE_TYPE_FIELD.match(currentName, parser.getDeprecationHandler())) {
                geoDistance = GeoDistance.fromString(parser.text());
                continue;
            }
            if (VALIDATION_METHOD_FIELD.match(currentName, parser.getDeprecationHandler())) {
                validation = GeoValidationMethod.fromString(parser.text());
                continue;
            }
            if (SORTMODE_FIELD.match(currentName, parser.getDeprecationHandler())) {
                sortMode = SortMode.fromString(parser.text());
                continue;
            }
            if (IGNORE_UNMAPPED.match(currentName, parser.getDeprecationHandler())) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (fieldName != null && !fieldName.equals(currentName)) {
                    throw new ParsingException(parser.getTokenLocation(), "Trying to reset fieldName to [{}], already set to [{}].", currentName, fieldName);
                }
                GeoPoint point = new GeoPoint();
                point.resetFromString(parser.text());
                geoPoints.add(point);
                fieldName = currentName;
                continue;
            }
            if (fieldName.equals(currentName)) {
                throw new ParsingException(parser.getTokenLocation(), "Only geohashes of type string supported for field [{}]", currentName);
            }
            throw new ParsingException(parser.getTokenLocation(), "[{}] does not support [{}]", NAME, currentName);
        }
        GeoDistanceSortBuilder result = new GeoDistanceSortBuilder(fieldName, geoPoints.toArray(new GeoPoint[geoPoints.size()]));
        result.geoDistance(geoDistance);
        result.unit(unit);
        result.order(order);
        if (sortMode != null) {
            result.sortMode(sortMode);
        }
        if (nestedSort != null) {
            result.setNestedSort(nestedSort);
        }
        if (validation != null) {
            result.validation(validation);
        }
        result.ignoreUnmapped(ignoreUnmapped);
        return result;
    }

    @Override
    public SortFieldAndFormat build(SearchExecutionContext context) throws IOException {
        GeoPoint[] localPoints = this.localPoints();
        boolean reverse = this.order == SortOrder.DESC;
        MultiValueMode localSortMode = this.localSortMode();
        IndexGeoPointFieldData geoIndexFieldData = this.fieldData(context);
        IndexFieldData.XFieldComparatorSource.Nested nested = this.nested(context);
        if (geoIndexFieldData.getClass() == LatLonPointIndexFieldData.class && nested == null && localSortMode == MultiValueMode.MIN && this.unit == DistanceUnit.METERS && !reverse && localPoints.length == 1) {
            return new SortFieldAndFormat(LatLonDocValuesField.newDistanceSort(this.fieldName, localPoints[0].lat(), localPoints[0].lon()), DocValueFormat.RAW);
        }
        return new SortFieldAndFormat(new SortField(this.fieldName, this.comparatorSource(localPoints, localSortMode, geoIndexFieldData, nested), reverse), DocValueFormat.RAW);
    }

    @Override
    public BucketedSort buildBucketedSort(SearchExecutionContext context, BigArrays bigArrays, int bucketSize, BucketedSort.ExtraData extra) throws IOException {
        GeoPoint[] localPoints = this.localPoints();
        MultiValueMode localSortMode = this.localSortMode();
        IndexGeoPointFieldData geoIndexFieldData = this.fieldData(context);
        IndexFieldData.XFieldComparatorSource.Nested nested = this.nested(context);
        return this.comparatorSource(localPoints, localSortMode, geoIndexFieldData, nested).newBucketedSort(bigArrays, this.order, DocValueFormat.RAW, bucketSize, extra);
    }

    private GeoPoint[] localPoints() {
        GeoPoint[] localPoints = this.points.toArray(new GeoPoint[this.points.size()]);
        if (!GeoValidationMethod.isIgnoreMalformed(this.validation)) {
            for (GeoPoint point : localPoints) {
                if (!GeoUtils.isValidLatitude(point.lat())) {
                    throw new ElasticsearchParseException("illegal latitude value [{}] for [GeoDistanceSort] for field [{}].", point.lat(), this.fieldName);
                }
                if (GeoUtils.isValidLongitude(point.lon())) continue;
                throw new ElasticsearchParseException("illegal longitude value [{}] for [GeoDistanceSort] for field [{}].", point.lon(), this.fieldName);
            }
        }
        if (GeoValidationMethod.isCoerce(this.validation)) {
            for (GeoPoint point : localPoints) {
                GeoUtils.normalizePoint(point, true, true);
            }
        }
        return localPoints;
    }

    private MultiValueMode localSortMode() {
        if (this.sortMode != null) {
            return MultiValueMode.fromString(this.sortMode.toString());
        }
        return this.order == SortOrder.DESC ? MultiValueMode.MAX : MultiValueMode.MIN;
    }

    private IndexGeoPointFieldData fieldData(SearchExecutionContext context) {
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        if (fieldType == null) {
            if (this.ignoreUnmapped) {
                return new LatLonPointIndexFieldData(this.fieldName, (ValuesSourceType)CoreValuesSourceType.GEOPOINT, (dv, n) -> {
                    throw new UnsupportedOperationException();
                });
            }
            throw new IllegalArgumentException("failed to find mapper for [" + this.fieldName + "] for geo distance based sort");
        }
        Object indexFieldData = context.getForField(fieldType, MappedFieldType.FielddataOperation.SEARCH);
        if (indexFieldData instanceof IndexGeoPointFieldData) {
            return (IndexGeoPointFieldData)indexFieldData;
        }
        throw new IllegalArgumentException("unable to apply geo distance sort to field [" + this.fieldName + "] of type [" + fieldType.typeName() + "]");
    }

    private IndexFieldData.XFieldComparatorSource.Nested nested(SearchExecutionContext context) throws IOException {
        if (this.nestedSort == null) {
            FieldSortBuilder.validateMissingNestedPath(context, this.fieldName);
            return null;
        }
        FieldSortBuilder.validateMaxChildrenExistOnlyInTopLevelNestedSort(context, this.nestedSort);
        return GeoDistanceSortBuilder.resolveNested(context, this.nestedSort);
    }

    private IndexFieldData.XFieldComparatorSource comparatorSource(final GeoPoint[] localPoints, final MultiValueMode localSortMode, final IndexGeoPointFieldData geoIndexFieldData, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new IndexFieldData.XFieldComparatorSource(null, localSortMode, nested){

            @Override
            public SortField.Type reducedType() {
                return SortField.Type.DOUBLE;
            }

            private NumericDoubleValues getNumericDoubleValues(LeafReaderContext context) throws IOException {
                MultiGeoPointValues geoPointValues = (MultiGeoPointValues)((LeafPointFieldData)geoIndexFieldData.load(context)).getPointValues();
                SortedNumericDoubleValues distanceValues = GeoUtils.distanceValues(GeoDistanceSortBuilder.this.geoDistance, GeoDistanceSortBuilder.this.unit, geoPointValues, localPoints);
                if (this.nested == null) {
                    return FieldData.replaceMissing(this.sortMode.select(distanceValues), Double.POSITIVE_INFINITY);
                }
                BitSet rootDocs = this.nested.rootDocs(context);
                DocIdSetIterator innerDocs = this.nested.innerDocs(context);
                int maxChildren = this.nested.getNestedSort() != null ? this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
                return localSortMode.select(distanceValues, Double.POSITIVE_INFINITY, rootDocs, innerDocs, maxChildren);
            }

            @Override
            public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning enableSkipping, boolean reversed) {
                return new DoubleComparator(numHits, null, null, reversed, Pruning.NONE){

                    @Override
                    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                        return new DoubleComparator.DoubleLeafComparator(context){

                            @Override
                            protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                                return this.getNumericDoubleValues(context).getRawDoubleValues();
                            }
                        };
                    }
                };
            }

            @Override
            public BucketedSort newBucketedSort(BigArrays bigArrays, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
                return new BucketedSort.ForDoubles(bigArrays, sortOrder, format, bucketSize, extra){

                    @Override
                    public BucketedSort.ForDoubles.Leaf forLeaf(final LeafReaderContext ctx) throws IOException {
                        return new BucketedSort.ForDoubles.Leaf(ctx){
                            private final NumericDoubleValues values;
                            private double value;
                            {
                                super(ctx2);
                                this.values = this.getNumericDoubleValues(ctx);
                            }

                            @Override
                            protected boolean advanceExact(int doc) throws IOException {
                                if (this.values.advanceExact(doc)) {
                                    this.value = this.values.doubleValue();
                                    return true;
                                }
                                return false;
                            }

                            @Override
                            protected double docValue() {
                                return this.value;
                            }
                        };
                    }
                };
            }
        };
    }

    static void parseGeoPoints(XContentParser parser, List<GeoPoint> geoPoints) throws IOException {
        while (!parser.nextToken().equals((Object)XContentParser.Token.END_ARRAY)) {
            if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                double lon = parser.doubleValue();
                parser.nextToken();
                if (!parser.currentToken().equals((Object)XContentParser.Token.VALUE_NUMBER)) {
                    throw new ElasticsearchParseException("geo point parsing: expected second number but got [{}] instead", new Object[]{parser.currentToken()});
                }
                double lat = parser.doubleValue();
                geoPoints.add(new GeoPoint(lat, lon));
                continue;
            }
            geoPoints.add(GeoUtils.parseGeoPoint(parser));
        }
    }

    @Override
    public GeoDistanceSortBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        if (this.nestedSort == null) {
            return this;
        }
        NestedSortBuilder rewrite = this.nestedSort.rewrite(ctx);
        if (this.nestedSort == rewrite) {
            return this;
        }
        return new GeoDistanceSortBuilder(this).setNestedSort(rewrite);
    }

    @Override
    public boolean supportsParallelCollection() {
        return false;
    }
}

