/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;

@ServerlessScope(value=Scope.INTERNAL)
public class RestCloseIndexAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestCloseIndexAction.class);
    public static final Set<String> WAIT_FOR_ACTIVE_SHARDS_INDEX_SETTING_REMOVED = Set.of("wait-for-active-shards-index-setting-removed");

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_close"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_close"));
    }

    @Override
    public String getName() {
        return "close_index_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        CloseIndexRequest closeIndexRequest = new CloseIndexRequest(Strings.splitStringByCommaToArray(request.param("index")));
        closeIndexRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout(request));
        closeIndexRequest.ackTimeout(RestUtils.getAckTimeout(request));
        closeIndexRequest.indicesOptions(IndicesOptions.fromRequest(request, closeIndexRequest.indicesOptions()));
        this.handleIndexSettingWaitForActiveShards(request, closeIndexRequest);
        return channel -> client.admin().indices().close(closeIndexRequest, new RestToXContentListener<CloseIndexResponse>((RestChannel)channel));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleIndexSettingWaitForActiveShards(RestRequest request, CloseIndexRequest closeIndexRequest) {
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards == null) {
            return;
        }
        if ("index-setting".equalsIgnoreCase(waitForActiveShards)) {
            if (request.getRestApiVersion() != RestApiVersion.V_8) throw new IllegalArgumentException("The 'index-setting' value for parameter 'wait_for_active_shards' is the default behaviour and this configuration value is not supported anymore. Please remove 'wait_for_active_shards=index-setting'.");
            deprecationLogger.warn(DeprecationCategory.SETTINGS, "close-index-wait_for_active_shards-index-setting", "?wait_for_active_shards=index-setting is now the default behaviour; the 'index-setting' value for this parameter should no longer be used since it will become unsupported in version " + Version.V_9_0_0.major, new Object[0]);
            return;
        } else {
            closeIndexRequest.waitForActiveShards(ActiveShardCount.parseString(waitForActiveShards));
        }
    }

    @Override
    public Set<String> supportedCapabilities() {
        return WAIT_FOR_ACTIVE_SHARDS_INDEX_SETTING_REMOVED;
    }
}

