/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack.graph;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.protocol.xpack.graph.Connection;
import org.elasticsearch.protocol.xpack.graph.Vertex;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GraphExploreResponse
extends ActionResponse
implements ToXContentObject {
    private long tookInMillis;
    private boolean timedOut = false;
    private ShardOperationFailedException[] shardFailures = ShardSearchFailure.EMPTY_ARRAY;
    private Map<Vertex.VertexId, Vertex> vertices;
    private Map<Connection.ConnectionId, Connection> connections;
    private boolean returnDetailedInfo;
    static final String RETURN_DETAILED_INFO_PARAM = "returnDetailedInfo";
    private static final ParseField TOOK = new ParseField("took", new String[0]);
    private static final ParseField TIMED_OUT = new ParseField("timed_out", new String[0]);
    private static final ParseField VERTICES = new ParseField("vertices", new String[0]);
    private static final ParseField CONNECTIONS = new ParseField("connections", new String[0]);
    private static final ParseField FAILURES = new ParseField("failures", new String[0]);

    public GraphExploreResponse() {
    }

    public GraphExploreResponse(long tookInMillis, boolean timedOut, ShardOperationFailedException[] shardFailures, Map<Vertex.VertexId, Vertex> vertices, Map<Connection.ConnectionId, Connection> connections, boolean returnDetailedInfo) {
        this.tookInMillis = tookInMillis;
        this.timedOut = timedOut;
        this.shardFailures = shardFailures;
        this.vertices = vertices;
        this.connections = connections;
        this.returnDetailedInfo = returnDetailedInfo;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public ShardOperationFailedException[] getShardFailures() {
        return this.shardFailures;
    }

    public Collection<Connection> getConnections() {
        return this.connections.values();
    }

    public Collection<Vertex> getVertices() {
        return this.vertices.values();
    }

    public Vertex getVertex(Vertex.VertexId id) {
        return this.vertices.get(id);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.tookInMillis);
        out.writeBoolean(this.timedOut);
        out.writeVInt(this.shardFailures.length);
        for (ShardOperationFailedException shardSearchFailure : this.shardFailures) {
            shardSearchFailure.writeTo(out);
        }
        out.writeVInt(this.vertices.size());
        for (Vertex vertex : this.vertices.values()) {
            vertex.writeTo(out);
        }
        out.writeVInt(this.connections.size());
        for (Connection connection : this.connections.values()) {
            connection.writeTo(out);
        }
        out.writeBoolean(this.returnDetailedInfo);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TOOK.getPreferredName(), this.tookInMillis);
        builder.field(TIMED_OUT.getPreferredName(), this.timedOut);
        builder.startArray(FAILURES.getPreferredName());
        if (this.shardFailures != null) {
            for (ShardOperationFailedException shardFailure : this.shardFailures) {
                shardFailure.toXContent(builder, params);
            }
        }
        builder.endArray();
        HashMap<Vertex, Integer> vertexNumbers = new HashMap<Vertex, Integer>(this.vertices.size());
        HashMap<String, String> extraParams = new HashMap<String, String>();
        extraParams.put(RETURN_DETAILED_INFO_PARAM, Boolean.toString(this.returnDetailedInfo));
        ToXContent.DelegatingMapParams extendedParams = new ToXContent.DelegatingMapParams(extraParams, params);
        builder.startArray(VERTICES.getPreferredName());
        for (Vertex vertex : this.vertices.values()) {
            builder.startObject();
            vertexNumbers.put(vertex, vertexNumbers.size());
            vertex.toXContent(builder, extendedParams);
            builder.endObject();
        }
        builder.endArray();
        builder.startArray(CONNECTIONS.getPreferredName());
        for (Connection connection : this.connections.values()) {
            builder.startObject();
            connection.toXContent(builder, extendedParams, vertexNumbers);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

