/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.net.InetAddress;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.network.CIDRUtils;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.xcontent.XContentString;

class ESInetAddressPoint
extends Field {
    private static final FieldType TYPE = new FieldType();
    private final XContentString ipString;
    private final InetAddress inetAddress;

    protected ESInetAddressPoint(String name, XContentString value) {
        super(name, TYPE);
        if (value == null) {
            throw new IllegalArgumentException("point must not be null");
        }
        this.fieldsData = new BytesRef(InetAddresses.encodeAsIpv6(value));
        this.ipString = value;
        this.inetAddress = null;
    }

    protected ESInetAddressPoint(String name, InetAddress value) {
        super(name, TYPE);
        if (value == null) {
            throw new IllegalArgumentException("point must not be null");
        }
        this.fieldsData = new BytesRef(CIDRUtils.encode(value.getAddress()));
        this.inetAddress = value;
        this.ipString = null;
    }

    public InetAddress getInetAddress() {
        if (this.ipString != null) {
            return InetAddresses.forString(this.ipString.bytes());
        }
        if (this.inetAddress != null) {
            return this.inetAddress;
        }
        throw new IllegalStateException("Neither ipString nor inetAddress is set");
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        BytesRef bytes = (BytesRef)this.fieldsData;
        InetAddress address = InetAddressPoint.decode(BytesRef.deepCopyOf((BytesRef)bytes).bytes);
        if (address.getAddress().length == 16) {
            result.append('[');
            result.append(NetworkAddress.format(address));
            result.append(']');
        } else {
            result.append(NetworkAddress.format(address));
        }
        result.append('>');
        return result.toString();
    }

    static {
        TYPE.setDimensions(1, 16);
        TYPE.freeze();
    }
}

