/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexOptions;

public class FieldInfosWithUsages
extends FieldInfos {
    private final int totalUsages;

    public FieldInfosWithUsages(FieldInfo[] infos) {
        super(infos);
        this.totalUsages = FieldInfosWithUsages.computeUsages(infos);
    }

    public static int computeUsages(FieldInfo[] infos) {
        int usages = 0;
        for (FieldInfo fi : infos) {
            if (fi.getIndexOptions() != IndexOptions.NONE) {
                ++usages;
            }
            if (fi.hasNorms()) {
                ++usages;
            }
            if (fi.getDocValuesType() != DocValuesType.NONE) {
                ++usages;
            }
            if (fi.getPointDimensionCount() > 0) {
                ++usages;
            }
            if (fi.getVectorDimension() <= 0) continue;
            ++usages;
        }
        return usages;
    }

    public int getTotalUsages() {
        return this.totalUsages;
    }
}

