/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;

public class GetMappingsResponse
extends ActionResponse
implements ChunkedToXContentObject {
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private final Map<String, MappingMetadata> mappings;

    public GetMappingsResponse(Map<String, MappingMetadata> mappings) {
        this.mappings = mappings;
    }

    public Map<String, MappingMetadata> mappings() {
        return this.mappings;
    }

    public Map<String, MappingMetadata> getMappings() {
        return this.mappings();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        MappingMetadata.writeMappingMetadata(out, this.mappings);
    }

    public Iterator<ToXContent> toXContentChunked(ToXContent.Params outerParams) {
        return Iterators.concat(Iterators.single((b, p) -> b.startObject()), Iterators.map(this.getMappings().entrySet().iterator(), indexEntry -> (builder, params) -> {
            builder.startObject((String)indexEntry.getKey());
            if (indexEntry.getValue() != null) {
                builder.field(MAPPINGS.getPreferredName(), ((MappingMetadata)indexEntry.getValue()).sourceAsMap());
            } else {
                builder.startObject(MAPPINGS.getPreferredName()).endObject();
            }
            builder.endObject();
            return builder;
        }), Iterators.single((b, p) -> b.endObject()));
    }

    public String toString() {
        return Strings.toString(this);
    }

    public int hashCode() {
        return this.mappings.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetMappingsResponse other = (GetMappingsResponse)obj;
        return this.mappings.equals(other.mappings);
    }
}

