"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Badges = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _is_attack_discovery_alert = require("../../../../../utils/is_attack_discovery_alert");
var _shared_badge = require("./shared_badge");
var _workflow_badge = require("./workflow_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/attack_discovery_panel/panel_header/primary_interactions/badges/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const BadgesComponent = ({
  attackDiscovery
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _is_attack_discovery_alert.isAttackDiscoveryAlert)(attackDiscovery) ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
        gap: ${euiTheme.size.xs};
      `,
    "data-test-subj": "badges",
    gutterSize: "none",
    responsive: false,
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_workflow_badge.WorkflowBadge, {
    attackDiscovery: attackDiscovery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_shared_badge.SharedBadge, {
    attackDiscovery: attackDiscovery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }))) : null;
};
BadgesComponent.displayName = 'Badges';
const Badges = exports.Badges = /*#__PURE__*/_react2.default.memo(BadgesComponent);