"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingSuccessCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_onboarding_success_callout = require("./hooks/use_onboarding_success_callout");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/asset_inventory/components/onboarding/onboarding_success_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Component to display a success callout after onboarding is completed.
 * Only visible if the user enabled the onboarding process.
 */
const OnboardingSuccessCallout = () => {
  const {
    isOnboardingSuccessCalloutVisible,
    hideOnboardingSuccessCallout,
    onAddIntegrationClick
  } = (0, _use_onboarding_success_callout.useOnboardingSuccessCallout)();
  return isOnboardingSuccessCalloutVisible ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    onDismiss: hideOnboardingSuccessCallout,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.onboarding.enabledSuccessfullyTitle",
      defaultMessage: "Asset Inventory Enabled Successfully",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 11
      }
    }),
    color: "success",
    iconType: "check",
    "data-test-subj": _constants.TEST_SUBJ_ONBOARDING_SUCCESS_CALLOUT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.onboarding.enabledSuccessfully",
    defaultMessage: "Asset Inventory is now set up and ready to use. You can start managing your assets with enhanced visibility and context, empowering your security team to make informed decisions.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    color: "success",
    onClick: onAddIntegrationClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.addIntegration",
    defaultMessage: "Add integration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  })) : null;
};
exports.OnboardingSuccessCallout = OnboardingSuccessCallout;