"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LandingLinksIconsCategoriesGroups = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _landing_links = require("./landing_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/packages/navigation/src/landing_links/landing_links_icons_categories_groups.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const stackManagementButtonClassName = 'stackManagementSection__button';
const useStyle = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const accordionFontSize = (0, _eui.useEuiFontSize)('xs');
  return {
    accordionButton: (0, _react2.css)`
  .${stackManagementButtonClassName} {
    font-weight: ${euiTheme.font.weight.bold};
    ${accordionFontSize}
  }}
`
  };
};
const LandingLinksIconsCategoriesGroups = exports.LandingLinksIconsCategoriesGroups = /*#__PURE__*/_react.default.memo(function LandingLinksIconsCategoriesGroups({
  links,
  categories: accordionCategories,
  urlState,
  onLinkClick
}) {
  const style = useStyle();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, accordionCategories.map(({
    label,
    categories
  }, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    key: `${label}_${index}`,
    id: `landingLinksCategoryGroups_${label}_${index}`,
    buttonContent: label,
    buttonClassName: stackManagementButtonClassName,
    css: style.accordionButton,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 13
    }
  }, categories && /*#__PURE__*/_react.default.createElement(LandingLinksIconsCategoryGroups, {
    links: links,
    categories: categories,
    urlState: urlState,
    onLinkClick: onLinkClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 17
    }
  })))));
});
const useGroupStyles = () => {
  return {
    container: (0, _react2.css)`
      min-width: 22em;
    `
  };
};
const LandingLinksIconsCategoryGroups = /*#__PURE__*/_react.default.memo(function LandingLinksIconsCategoryGroups({
  links,
  categories,
  urlState,
  onLinkClick
}) {
  const styles = useGroupStyles();
  const categoriesLinks = (0, _react.useMemo)(() => {
    const linksById = Object.fromEntries(links.map(link => [link.id, link]));
    return categories.reduce((acc, {
      label,
      linkIds,
      type,
      iconType
    }) => {
      const linksItem = linkIds.reduce((linksAcc, linkId) => {
        if (linksById[linkId]) {
          linksAcc.push(linksById[linkId]);
        }
        return linksAcc;
      }, []);
      if (linksItem.length > 0) {
        acc.push({
          type,
          label,
          iconType,
          links: linksItem
        });
      }
      return acc;
    }, []);
  }, [links, categories]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xl",
    alignItems: "flexStart",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, categoriesLinks.map(({
    label,
    links: categoryLinks,
    iconType
  }, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `${index}_${label}`,
    css: styles.container,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(LandingColumnHeading, {
    label: label,
    iconType: iconType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_landing_links.LandingColumnLinks, {
    items: categoryLinks,
    urlState: urlState,
    onLinkClick: onLinkClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }))));
});
const LandingColumnHeading = /*#__PURE__*/_react.default.memo(function LandingColumnHeading({
  label,
  iconType
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 5
    }
  }, iconType && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, label))));
});

// eslint-disable-next-line import/no-default-export
var _default = exports.default = LandingLinksIconsCategoriesGroups;