"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchService = void 0;
var _rxjs = require("rxjs");
var _server = require("@kbn/core/server");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var _logger = /*#__PURE__*/new WeakMap();
var _coreStatus$ = /*#__PURE__*/new WeakMap();
/**
 * Service responsible for interactions with the Elasticsearch.
 */
class ElasticsearchService {
  constructor(logger) {
    _classPrivateFieldInitSpec(this, _logger, void 0);
    _classPrivateFieldInitSpec(this, _coreStatus$, void 0);
    _classPrivateFieldSet(_logger, this, logger);
  }
  setup({
    status,
    license
  }) {
    _classPrivateFieldSet(_coreStatus$, this, (0, _rxjs.combineLatest)([status.core$, license.features$]).pipe((0, _rxjs.map)(([coreStatus]) => license.isEnabled() && coreStatus.elasticsearch.level === _server.ServiceStatusLevels.available), (0, _rxjs.shareReplay)(1)));
  }
  start() {
    return {
      // We'll need to get rid of this as soon as Core's Elasticsearch service exposes this
      // functionality in the scope of https://github.com/elastic/kibana/issues/41983.
      watchOnlineStatus$: () => {
        const RETRY_SCALE_DURATION = 100;
        const RETRY_TIMEOUT_MAX = 10000;
        const retries$ = new _rxjs.BehaviorSubject(0);
        const retryScheduler = {
          scheduleRetry: () => {
            const retriesElapsed = retries$.getValue() + 1;
            const nextRetryTimeout = Math.min(retriesElapsed * RETRY_SCALE_DURATION, RETRY_TIMEOUT_MAX);
            _classPrivateFieldGet(_logger, this).debug(`Scheduling re-try in ${nextRetryTimeout} ms.`);
            retryTimeout = setTimeout(() => retries$.next(retriesElapsed), nextRetryTimeout);
          }
        };
        let retryTimeout;
        return (0, _rxjs.combineLatest)([_classPrivateFieldGet(_coreStatus$, this).pipe((0, _rxjs.tap)(() => {
          // If status or license change occurred before retry timeout we should cancel
          // it and reset retry counter.
          if (retryTimeout) {
            clearTimeout(retryTimeout);
          }
          if (retries$.value > 0) {
            retries$.next(0);
          }
        })), retries$.asObservable().pipe(
        // We shouldn't emit new value if retry counter is reset. This comparator isn't called for
        // the initial value.
        (0, _rxjs.distinctUntilChanged)((prev, curr) => prev === curr || curr === 0))]).pipe((0, _rxjs.filter)(([isAvailable]) => isAvailable), (0, _rxjs.map)(() => retryScheduler));
      }
    };
  }
}
exports.ElasticsearchService = ElasticsearchService;