"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedSearchesService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("../../common");
var _create_get_saved_search_deps = require("./create_get_saved_search_deps");
var _get_discover_session = require("../../common/service/get_discover_session");
var _get_saved_searches = require("../../common/service/get_saved_searches");
var _save_saved_searches = require("./save_saved_searches");
var _save_discover_session = require("./save_discover_session");
var _check_for_duplicate_title = require("./check_for_duplicate_title");
var _to_saved_search = require("./to_saved_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class SavedSearchesService {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "get", (savedSearchId, serialized) => {
      return (0, _get_saved_searches.getSavedSearch)(savedSearchId, (0, _create_get_saved_search_deps.createGetSavedSearchDeps)(this.deps), serialized);
    });
    (0, _defineProperty2.default)(this, "getDiscoverSession", discoverSessionId => {
      return (0, _get_discover_session.getDiscoverSession)(discoverSessionId, (0, _create_get_saved_search_deps.createGetSavedSearchDeps)(this.deps));
    });
    (0, _defineProperty2.default)(this, "getAll", async () => {
      const {
        contentManagement
      } = this.deps;
      const result = await contentManagement.search({
        contentTypeId: _common.SavedSearchType,
        query: {}
      });
      return result.hits;
    });
    (0, _defineProperty2.default)(this, "find", async search => {
      const {
        contentManagement
      } = this.deps;
      const result = await contentManagement.search({
        contentTypeId: _common.SavedSearchType,
        query: {
          text: search
        },
        options: {
          searchFields: ['title'],
          fields: ['title']
        }
      });
      return result.hits;
    });
    (0, _defineProperty2.default)(this, "save", (savedSearch, options = {}) => {
      const {
        contentManagement,
        savedObjectsTaggingOss
      } = this.deps;
      return (0, _save_saved_searches.saveSavedSearch)(savedSearch, options, contentManagement, savedObjectsTaggingOss === null || savedObjectsTaggingOss === void 0 ? void 0 : savedObjectsTaggingOss.getTaggingApi());
    });
    (0, _defineProperty2.default)(this, "saveDiscoverSession", (discoverSession, options = {}) => {
      const {
        contentManagement,
        savedObjectsTaggingOss
      } = this.deps;
      return (0, _save_discover_session.saveDiscoverSession)(discoverSession, options, contentManagement, savedObjectsTaggingOss === null || savedObjectsTaggingOss === void 0 ? void 0 : savedObjectsTaggingOss.getTaggingApi());
    });
    (0, _defineProperty2.default)(this, "checkForDuplicateTitle", props => {
      return (0, _check_for_duplicate_title.checkForDuplicateTitle)({
        title: props.newTitle,
        isTitleDuplicateConfirmed: props.isTitleDuplicateConfirmed,
        onTitleDuplicate: props.onTitleDuplicate,
        contentManagement: this.deps.contentManagement
      });
    });
    (0, _defineProperty2.default)(this, "byValueToSavedSearch", (result, serialized) => {
      return (0, _to_saved_search.byValueToSavedSearch)(result, this.deps, serialized);
    });
    this.deps = deps;
  }
}
exports.SavedSearchesService = SavedSearchesService;