"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagManagementPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _edition_modal = require("../components/edition_modal");
var _components = require("./components");
var _actions = require("./actions");
var _bulk_actions = require("./bulk_actions");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/saved_objects_tagging/public/management/tag_management_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TagManagementPage = ({
  setBreadcrumbs,
  core,
  tagClient,
  tagCache,
  assignmentService,
  capabilities,
  assignableTypes
}) => {
  const {
    application,
    http,
    ...startServices
  } = core;
  const [loading, setLoading] = (0, _react.useState)(false);
  const [allTags, setAllTags] = (0, _react.useState)([]);
  const [selectedTags, setSelectedTags] = (0, _react.useState)([]);
  const [query, setQuery] = (0, _react.useState)();
  const filteredTags = (0, _react.useMemo)(() => {
    return query ? _eui.Query.execute(query, allTags) : allTags;
  }, [allTags, query]);
  const unmount$ = (0, _react.useMemo)(() => {
    return new _rxjs.Subject();
  }, []);
  (0, _react.useEffect)(() => {
    return () => {
      unmount$.next();
    };
  }, [unmount$]);
  const fetchTags = (0, _react.useCallback)(async () => {
    setLoading(true);
    const {
      tags
    } = await tagClient.find({
      page: 1,
      perPage: 10000
    });
    setAllTags(tags);
    setLoading(false);
  }, [tagClient]);
  (0, _useMount.default)(() => {
    fetchTags();
  });
  const createModalOpener = (0, _react.useMemo)(() => (0, _edition_modal.getCreateModalOpener)({
    ...startServices,
    tagClient
  }), [startServices, tagClient]);
  const tableActions = (0, _react.useMemo)(() => {
    return (0, _actions.getTableActions)({
      startServices,
      capabilities,
      tagClient,
      tagCache,
      assignmentService,
      setLoading,
      assignableTypes,
      fetchTags,
      canceled$: unmount$
    });
  }, [startServices, capabilities, tagClient, tagCache, assignmentService, setLoading, assignableTypes, fetchTags, unmount$]);
  const bulkActions = (0, _react.useMemo)(() => {
    return (0, _bulk_actions.getBulkActions)({
      startServices,
      capabilities,
      tagClient,
      tagCache,
      assignmentService,
      setLoading,
      assignableTypes,
      clearSelection: () => setSelectedTags([])
    });
  }, [startServices, capabilities, tagClient, tagCache, assignmentService, assignableTypes]);
  (0, _react.useEffect)(() => {
    setBreadcrumbs([{
      text: _i18n.i18n.translate('xpack.savedObjectsTagging.management.breadcrumb.index', {
        defaultMessage: 'Tags'
      })
    }]);
  }, [setBreadcrumbs]);
  const {
    notifications
  } = startServices;
  const openCreateModal = (0, _react.useCallback)(() => {
    createModalOpener({
      onCreate: createdTag => {
        fetchTags();
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.savedObjectsTagging.notifications.createTagSuccessTitle', {
            defaultMessage: 'Created "{name}" tag',
            values: {
              name: createdTag.name
            }
          })
        });
      }
    });
  }, [notifications, createModalOpener, fetchTags]);
  const getTagRelationUrl = (0, _react.useCallback)(tag => {
    return (0, _utils.getTagConnectionsUrl)(tag, http.basePath);
  }, [http]);
  const showTagRelations = (0, _react.useCallback)(tag => {
    application.navigateToUrl(getTagRelationUrl(tag));
  }, [application, getTagRelationUrl]);
  const executeBulkAction = (0, _react.useCallback)(async action => {
    try {
      await action.execute(selectedTags.map(({
        id
      }) => id), {
        canceled$: unmount$
      });
    } catch (e) {
      notifications.toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.savedObjectsTagging.notifications.bulkActionError', {
          defaultMessage: 'An error occurred'
        })
      });
    } finally {
      setLoading(false);
    }
    if (action.refreshAfterExecute) {
      await fetchTags();
    }
  }, [selectedTags, fetchTags, notifications, unmount$]);
  const actionBar = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_components.ActionBar, {
    actions: bulkActions,
    totalCount: filteredTags.length,
    selectedCount: selectedTags.length,
    onActionSelected: executeBulkAction,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }), [selectedTags, filteredTags, bulkActions, executeBulkAction]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.Header, {
    canCreate: capabilities.create,
    onCreate: openCreateModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_components.TagTable, {
    loading: loading,
    tags: filteredTags,
    capabilities: capabilities,
    actionBar: actionBar,
    actions: tableActions,
    initialQuery: query,
    onQueryChange: newQuery => {
      setQuery(newQuery);
      setSelectedTags([]);
    },
    allowSelection: bulkActions.length > 0,
    selectedTags: selectedTags,
    onSelectionChange: tags => {
      setSelectedTags(tags);
    },
    getTagRelationUrl: getTagRelationUrl,
    onShowRelations: tag => {
      showTagRelations(tag);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }));
};
exports.TagManagementPage = TagManagementPage;