"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewErrorsInLogsAction = exports.ScheduledQueryErrorsTable = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _rison = require("@kbn/rison");
var _querystring = require("querystring");
var _kibana = require("../common/lib/kibana");
var _agent_id_to_name = require("../agents/agent_id_to_name");
var _use_pack_query_errors = require("./use_pack_query_errors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/packs/scheduled_query_errors_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VIEW_IN_LOGS = _i18n.i18n.translate('xpack.osquery.pack.queriesTable.viewLogsErrorsActionAriaLabel', {
  defaultMessage: 'View in Logs'
});
const ViewErrorsInLogsActionComponent = ({
  actionId,
  agentId,
  timestamp
}) => {
  const navigateToApp = (0, _kibana.useKibana)().services.application.navigateToApp;
  const handleClick = (0, _react.useCallback)(event => {
    const openInNewTab = !(!(0, _kibana.isModifiedEvent)(event) && (0, _kibana.isLeftClickEvent)(event));
    event.preventDefault();
    const queryString = (0, _querystring.stringify)({
      logPosition: (0, _rison.encode)({
        end: timestamp,
        streamLive: false
      }),
      logFilter: (0, _rison.encode)({
        expression: `elastic_agent.id:${agentId} and (data_stream.dataset:elastic_agent or data_stream.dataset:elastic_agent.osquerybeat) and "${actionId}"`,
        kind: 'kuery'
      })
    });
    navigateToApp('logs', {
      path: `stream?${queryString}`,
      openInNewTab
    });
  }, [actionId, agentId, navigateToApp, timestamp]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: VIEW_IN_LOGS,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "search",
    onClick: handleClick,
    "aria-label": VIEW_IN_LOGS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
};
const ViewErrorsInLogsAction = exports.ViewErrorsInLogsAction = /*#__PURE__*/_react.default.memo(ViewErrorsInLogsActionComponent);
const renderErrorMessage = error => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  fontSize: "s",
  paddingSize: "none",
  transparentBackground: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 79,
    columnNumber: 3
  }
}, error);
const ScheduledQueryErrorsTableComponent = ({
  actionId,
  interval
}) => {
  var _lastErrorsData$hits;
  const {
    data: lastErrorsData
  } = (0, _use_pack_query_errors.usePackQueryErrors)({
    actionId,
    interval
  });
  const renderAgentIdColumn = (0, _react.useCallback)(agentId => /*#__PURE__*/_react.default.createElement(_agent_id_to_name.AgentIdToName, {
    agentId: agentId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 23
    }
  }), []);
  const renderLogsErrorsAction = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(ViewErrorsInLogsAction, {
    actionId: actionId,
    agentId: item === null || item === void 0 ? void 0 : item.fields['elastic_agent.id'][0],
    timestamp: item === null || item === void 0 ? void 0 : item.fields['event.ingested'][0],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }), [actionId]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'fields.@timestamp',
    name: '@timestamp',
    width: '220px'
  }, {
    field: 'fields["elastic_agent.id"][0]',
    name: _i18n.i18n.translate('xpack.osquery.scheduledQueryErrorsTable.agentIdColumnTitle', {
      defaultMessage: 'Agent Id'
    }),
    truncateText: true,
    render: renderAgentIdColumn,
    width: '15%'
  }, {
    field: 'fields.message[0]',
    name: _i18n.i18n.translate('xpack.osquery.scheduledQueryErrorsTable.errorColumnTitle', {
      defaultMessage: 'Error'
    }),
    render: renderErrorMessage
  }, {
    width: '50px',
    actions: [{
      render: renderLogsErrorsAction
    }]
  }], [renderAgentIdColumn, renderLogsErrorsAction]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    // eslint-disable-next-line react-perf/jsx-no-new-array-as-prop
    items: (_lastErrorsData$hits = lastErrorsData === null || lastErrorsData === void 0 ? void 0 : lastErrorsData.hits) !== null && _lastErrorsData$hits !== void 0 ? _lastErrorsData$hits : [],
    columns: columns,
    pagination: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 5
    }
  });
};
const ScheduledQueryErrorsTable = exports.ScheduledQueryErrorsTable = /*#__PURE__*/_react.default.memo(ScheduledQueryErrorsTableComponent);