"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultShardData = exports.PackShardsField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _converters = require("../../../../common/utils/converters");
var _agent_policies = require("../../../agent_policies");
var _shards_form = require("./shards_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/packs/form/shards/pack_shards_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultShardData = exports.defaultShardData = {
  policy: {
    label: '',
    key: ''
  },
  percentage: 100
};
const PackShardsFieldComponent = ({
  options
}) => {
  const {
    watch: watchRoot,
    register: registerRoot,
    setValue: setValueRoot,
    formState: {
      errors: errorsRoot
    }
  } = (0, _reactHookForm.useFormContext)();
  const {
    data: {
      agentPoliciesById
    } = {}
  } = (0, _agent_policies.useAgentPolicies)();
  const rootShards = watchRoot('shards');
  const initialShardsArray = (0, _react.useMemo)(() => {
    const initialConvertedShards = (0, _converters.convertShardsToArray)(rootShards, agentPoliciesById);
    if (!(0, _lodash.isEmpty)(initialConvertedShards)) {
      if (initialConvertedShards[initialConvertedShards.length - 1].policy.key) {
        return [...initialConvertedShards, defaultShardData];
      }
      return initialConvertedShards;
    }
    return [defaultShardData];
  }, [agentPoliciesById, rootShards]);
  const {
    control,
    watch,
    getFieldState,
    formState,
    resetField,
    setValue
  } = (0, _reactHookForm.useForm)({
    mode: 'all',
    shouldUnregister: true,
    defaultValues: {
      shardsArray: initialShardsArray
    }
  });
  const {
    fields,
    remove,
    append
  } = (0, _reactHookForm.useFieldArray)({
    control,
    name: 'shardsArray'
  });
  const formValue = watch();
  const shardsArrayState = getFieldState('shardsArray', formState);
  (0, _react.useEffect)(() => {
    registerRoot('shards', {
      validate: () => {
        const nonEmptyErrors = (0, _lodash.reject)(shardsArrayState.error, _lodash.isEmpty);
        return !nonEmptyErrors.length;
      }
    });
  }, [shardsArrayState.error, errorsRoot, registerRoot]);
  (0, _react.useEffect)(() => {
    const subscription = watch((data, payload) => {
      if (data !== null && data !== void 0 && data.shardsArray) {
        var _data$shardsArray, _payload$name;
        const lastShardIndex = (data === null || data === void 0 ? void 0 : (_data$shardsArray = data.shardsArray) === null || _data$shardsArray === void 0 ? void 0 : _data$shardsArray.length) - 1;
        if ((_payload$name = payload.name) !== null && _payload$name !== void 0 && _payload$name.startsWith(`shardsArray.${lastShardIndex}.`)) {
          var _lastShard$policy;
          const lastShard = (0, _lodash.last)(data.shardsArray);
          if (lastShard !== null && lastShard !== void 0 && (_lastShard$policy = lastShard.policy) !== null && _lastShard$policy !== void 0 && _lastShard$policy.key) {
            append(defaultShardData);
          }
        }
      }
    });
    return () => subscription.unsubscribe();
  }, [formValue, append, watch]);
  (0, _react.useEffect)(() => {
    const parsedShards = (0, _converters.convertShardsToObject)(formValue.shardsArray);
    if (shardsArrayState.isDirty && !(0, _fastDeepEqual.default)(parsedShards, rootShards)) {
      setValueRoot('shards', parsedShards, {
        shouldTouch: true
      });
    }
  }, [setValueRoot, formValue, shardsArrayState.isDirty, rootShards, resetField, setValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }), fields.map((item, index, array) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: item.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shards_form.ShardsForm, {
    index: index,
    onDelete: remove,
    isLastItem: index === array.length - 1,
    control: control,
    options: options,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }))));
};
const PackShardsField = exports.PackShardsField = /*#__PURE__*/_react.default.memo(PackShardsFieldComponent);