"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Cases = Cases;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _alerts_flyout = _interopRequireDefault(require("../../../components/alerts_flyout/alerts_flyout"));
var _common = require("../../../../common");
var _kibana_react = require("../../../utils/kibana_react");
var _use_plugin_context = require("../../../hooks/use_plugin_context");
var _use_fetch_alert_detail = require("../../../hooks/use_fetch_alert_detail");
var _use_fetch_alert_data = require("../../../hooks/use_fetch_alert_data");
var _ = require("../../..");
var _paths = require("../../../../common/locators/paths");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/cases/components/cases.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Cases({
  permissions
}) {
  const {
    application: {
      navigateToUrl
    },
    cases,
    data,
    http,
    notifications,
    fieldFormats,
    application,
    licensing,
    settings
  } = (0, _kibana_react.useKibana)().services;
  const {
    observabilityRuleTypeRegistry
  } = (0, _use_plugin_context.usePluginContext)();
  const [selectedAlertId, setSelectedAlertId] = (0, _react.useState)('');
  const [alertLoading, alertDetail] = (0, _use_fetch_alert_detail.useFetchAlertDetail)(selectedAlertId);
  const handleFlyoutClose = () => setSelectedAlertId('');
  const handleShowAlertDetails = alertId => {
    setSelectedAlertId(alertId);
  };
  if (!cases) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.observability.cases.casesPluginIsNotLabel', {
      defaultMessage: 'Cases plugin is not available. Please ensure it is installed and enabled.'
    }));
  }
  const CasesList = cases.ui.getCases;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(CasesList, {
    basePath: _paths.CASES_PATH,
    features: {
      alerts: {
        sync: false,
        isExperimental: false
      },
      observables: {
        enabled: false
      },
      events: {
        enabled: false
      }
    },
    owner: [_common.observabilityFeatureId],
    permissions: permissions,
    ruleDetailsNavigation: {
      href: ruleId => http.basePath.prepend(_paths.paths.observability.ruleDetails(ruleId || '')),
      onClick: (ruleId, ev) => {
        const ruleLink = http.basePath.prepend(_paths.paths.observability.ruleDetails(ruleId || ''));
        if (ev != null) {
          ev.preventDefault();
        }
        return navigateToUrl(ruleLink);
      }
    },
    showAlertDetails: handleShowAlertDetails,
    useFetchAlertData: _use_fetch_alert_data.useFetchAlertData,
    renderAlertsTable: props => /*#__PURE__*/_react.default.createElement(_.ObservabilityAlertsTable, (0, _extends2.default)({}, props, {
      services: {
        data,
        http,
        notifications,
        fieldFormats,
        application,
        licensing,
        cases,
        settings
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 11
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), alertDetail && selectedAlertId !== '' && !alertLoading ? /*#__PURE__*/_react.default.createElement(_alerts_flyout.default, {
    alert: alertDetail.raw,
    observabilityRuleTypeRegistry: observabilityRuleTypeRegistry,
    onClose: handleFlyoutClose,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }) : null);
}