"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTableExpandedAlertView = AlertsTableExpandedAlertView;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("@kbn/response-ops-alerts-table/translations");
var _alerts_flyout = _interopRequireDefault(require("./alerts_flyout"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/alerts_flyout/alerts_table_expanded_alert_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AlertsTableExpandedAlertView({
  pageIndex,
  pageSize,
  expandedAlertIndex,
  onExpandedAlertIndexChange,
  alerts,
  alertsCount,
  isLoading,
  tableId,
  observabilityRuleTypeRegistry
}) {
  const alertIndexInPage = expandedAlertIndex - pageIndex * pageSize;
  if (alertIndexInPage < 0 || alertIndexInPage >= alerts.length || pageSize <= 0) {
    onExpandedAlertIndexChange(null);
    return null;
  }
  const expandedAlertPage = Math.floor(expandedAlertIndex / pageSize);
  // This can be undefined when a new page of alerts is still loading
  const alert = alerts[alertIndexInPage];
  return /*#__PURE__*/_react.default.createElement(_alerts_flyout.default, {
    alert: expandedAlertPage === pageIndex ? alert : undefined,
    isLoading: isLoading,
    tableId: tableId,
    onClose: () => {
      onExpandedAlertIndexChange === null || onExpandedAlertIndexChange === void 0 ? void 0 : onExpandedAlertIndexChange(null);
    },
    observabilityRuleTypeRegistry: observabilityRuleTypeRegistry,
    headerAppend: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      justifyContent: "flexEnd",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
      "aria-label": _translations.ALERT_FLYOUT_PAGINATION_ARIA_LABEL,
      pageCount: alertsCount,
      activePage: expandedAlertIndex,
      onPageClick: activePage => {
        onExpandedAlertIndexChange === null || onExpandedAlertIndexChange === void 0 ? void 0 : onExpandedAlertIndexChange(activePage);
      },
      compressed: true,
      "data-test-subj": "alertFlyoutPagination",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 15
      }
    })))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
}