"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSeriesExplorerPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _anomaly_results_view_selector = require("../components/anomaly_results_view_selector");
var _job_selector = require("../components/job_selector");
var _help_menu = require("../components/help_menu");
var _kibana = require("../contexts/kibana");
var _page_header = require("../components/page_header");
var _page_title = require("../components/page_title");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/timeseriesexplorer/timeseriesexplorer_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TimeSeriesExplorerPage = ({
  children,
  dateFormatTz,
  resizeRef,
  noSingleMetricJobsFound,
  handleJobSelectionChange,
  selectedJobId = []
}) => {
  var _cases$ui$getCasesCon;
  const {
    services: {
      cases,
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const CasesContext = (_cases$ui$getCasesCon = cases === null || cases === void 0 ? void 0 : cases.ui.getCasesContext()) !== null && _cases$ui$getCasesCon !== void 0 ? _cases$ui$getCasesCon : _react.default.Fragment;
  const casesPermissions = cases === null || cases === void 0 ? void 0 : cases.helpers.canUseCases();
  const helpLink = docLinks.links.ml.anomalyDetection;
  const timeseriesExplorerStyles = (0, _styles.useTimeseriesExplorerStyles)();
  const annotationStyles = (0, _styles.useAnnotationStyles)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: [timeseriesExplorerStyles, annotationStyles],
    ref: resizeRef,
    "data-test-subj": "mlPageSingleMetricViewer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, {
    leftSideItems: [/*#__PURE__*/_react.default.createElement(_anomaly_results_view_selector.AnomalyResultsViewSelector, {
      key: "anomaly-results-view-selector",
      viewId: "timeseriesexplorer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 13
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
    title: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.pageTitle', {
      defaultMessage: 'Single Metric Viewer'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  })), noSingleMetricJobsFound ? null : /*#__PURE__*/_react.default.createElement(_job_selector.JobSelector, {
    dateFormatTz: dateFormatTz,
    singleSelection: true,
    timeseriesOnly: true,
    onSelectionChange: handleJobSelectionChange,
    selectedJobIds: selectedJobId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: [],
    permissions: casesPermissions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, children), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  })));
};
exports.TimeSeriesExplorerPage = TimeSeriesExplorerPage;