"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/timeseriesexplorer/components/entity_control/entity_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EntityConfig = ({
  entity,
  isModelPlotEnabled,
  config,
  onConfigChange
}) => {
  var _config$sort, _config$sort2;
  const [isEntityConfigPopoverOpen, setIsEntityConfigPopoverOpen] = (0, _react.useState)(false);
  const forceSortByName = isModelPlotEnabled && !(config !== null && config !== void 0 && config.anomalousOnly);
  const sortOptions = (0, _react.useMemo)(() => {
    return [{
      id: 'anomaly_score',
      label: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.sortByScoreLabel', {
        defaultMessage: 'Anomaly score'
      }),
      disabled: forceSortByName
    }, {
      id: 'name',
      label: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.sortByNameLabel', {
        defaultMessage: 'Name'
      })
    }];
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isModelPlotEnabled, config]);
  const orderOptions = (0, _react.useMemo)(() => {
    return [{
      id: 'asc',
      label: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.ascOptionsOrderLabel', {
        defaultMessage: 'asc'
      })
    }, {
      id: 'desc',
      label: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.descOptionsOrderLabel', {
        defaultMessage: 'desc'
      })
    }];
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    style: {
      height: '40px'
    },
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "text",
      iconSize: "m",
      iconType: "gear",
      "aria-label": _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.editControlConfiguration', {
        defaultMessage: 'Edit field configuration'
      }),
      onClick: () => {
        setIsEntityConfigPopoverOpen(!isEntityConfigPopoverOpen);
      },
      "data-test-subj": `mlSingleMetricViewerEntitySelectionConfigButton_${entity.fieldName}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    }),
    isOpen: isEntityConfigPopoverOpen,
    closePopover: () => {
      setIsEntityConfigPopoverOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `mlSingleMetricViewerEntitySelectionConfigPopover_${entity.fieldName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.sortByLabel",
      defaultMessage: "Sort by",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    name: "entitySortBy",
    options: sortOptions,
    idSelected: forceSortByName ? 'name' : config === null || config === void 0 ? void 0 : (_config$sort = config.sort) === null || _config$sort === void 0 ? void 0 : _config$sort.by,
    onChange: id => {
      onConfigChange(entity.fieldType, {
        sort: {
          order: config.sort.order,
          by: id
        }
      });
    },
    compressed: true,
    "data-test-subj": `mlSingleMetricViewerEntitySelectionConfigSortBy_${entity.fieldName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.orderLabel",
      defaultMessage: "Order",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    name: "entitySortOrder",
    options: orderOptions,
    idSelected: config === null || config === void 0 ? void 0 : (_config$sort2 = config.sort) === null || _config$sort2 === void 0 ? void 0 : _config$sort2.order,
    onChange: id => {
      onConfigChange(entity.fieldType, {
        sort: {
          by: config.sort.by,
          order: id
        }
      });
    },
    compressed: true,
    "data-test-subj": `mlSingleMetricViewerEntitySelectionConfigOrder_${entity.fieldName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'xs',
    alignItems: 'center',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }, isModelPlotEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.anomalousOnlyLabel",
      defaultMessage: "Anomalous only",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 19
      }
    }),
    checked: config.anomalousOnly,
    onChange: e => {
      const isAnomalousOnly = e.target.checked;
      onConfigChange(entity.fieldType, {
        anomalousOnly: isAnomalousOnly,
        sort: {
          order: config.sort.order,
          by: config.sort.by
        }
      });
    },
    compressed: true,
    "data-test-subj": `mlSingleMetricViewerEntitySelectionConfigAnomalousOnly_${entity.fieldName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.applyTimeRangeLabel",
      defaultMessage: "Apply time range",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 19
      }
    }),
    checked: config.applyTimeRange,
    onChange: e => {
      const applyTimeRange = e.target.checked;
      onConfigChange(entity.fieldType, {
        applyTimeRange
      });
    },
    compressed: true,
    "data-test-subj": `mlSingleMetricViewerEntitySelectionConfigAnomalousOnly_${entity.fieldName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: '16px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  }, isModelPlotEnabled && !(config !== null && config !== void 0 && config.anomalousOnly) ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.nonAnomalousResultsWithModelPlotInfo",
      defaultMessage: "The list contains values from the model plot results.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 19
      }
    }),
    type: "info",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 15
    }
  }) : null, !isModelPlotEnabled && !(config !== null && config !== void 0 && config.applyTimeRange) ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.ignoreTimeRangeInfo",
      defaultMessage: "The list contains values from all anomalies created during the lifetime of the job.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 19
      }
    }),
    type: "info",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 15
    }
  }) : null))));
};
exports.EntityConfig = EntityConfig;