"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewEventModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _moment = _interopRequireDefault(require("moment"));
var _mlDateUtils = require("@kbn/ml-date-utils");
var _utils = require("../utils");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/settings/calendars/edit/new_event_modal/new_event_modal.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VALID_DATE_STRING_LENGTH = 19;
const INLINE_DATE_PICKER_RANGE_WIDTH = 553;
class NewEventModal extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onDescriptionChange", e => {
      this.setState({
        description: e.target.value,
        descriptionVisited: true
      });
    });
    (0, _defineProperty2.default)(this, "onDescriptionBlur", () => {
      this.setState({
        descriptionVisited: true
      });
    });
    (0, _defineProperty2.default)(this, "handleAddEvent", () => {
      const {
        description,
        startDate,
        endDate
      } = this.state;
      // Temp reference to unsaved events to allow removal from table
      const tempId = (0, _utils.generateTempId)();
      const event = {
        description,
        start_time: startDate.valueOf(),
        end_time: endDate.valueOf(),
        event_id: tempId
      };
      this.props.addEvent(event);
    });
    (0, _defineProperty2.default)(this, "handleChangeStart", date => {
      let start = null;
      let end = this.state.endDate;
      const startMoment = (0, _moment.default)(date);
      const endMoment = (0, _moment.default)(date);
      start = startMoment.startOf('day');
      if (start > end) {
        end = endMoment.startOf('day').add(1, 'days');
      }
      this.setState({
        startDate: start,
        endDate: end,
        startDateString: start.format(_mlDateUtils.TIME_FORMAT),
        endDateString: end.format(_mlDateUtils.TIME_FORMAT)
      });
    });
    (0, _defineProperty2.default)(this, "handleChangeEnd", date => {
      let start = this.state.startDate;
      let end = null;
      const startMoment = (0, _moment.default)(date);
      const endMoment = (0, _moment.default)(date);
      end = endMoment.startOf('day');
      if (start > end) {
        start = startMoment.startOf('day').subtract(1, 'days');
      }
      this.setState({
        startDate: start,
        endDate: end,
        startDateString: start.format(_mlDateUtils.TIME_FORMAT),
        endDateString: end.format(_mlDateUtils.TIME_FORMAT)
      });
    });
    (0, _defineProperty2.default)(this, "handleTimeStartChange", event => {
      const dateString = event.target.value;
      let isValidDate = false;
      if (dateString.length === VALID_DATE_STRING_LENGTH) {
        isValidDate = (0, _moment.default)(dateString).isValid(_mlDateUtils.TIME_FORMAT, true);
      } else {
        this.setState({
          startDateString: dateString
        });
      }
      if (isValidDate) {
        this.setState({
          startDateString: dateString,
          startDate: (0, _moment.default)(dateString)
        });
      }
    });
    (0, _defineProperty2.default)(this, "handleTimeEndChange", event => {
      const dateString = event.target.value;
      let isValidDate = false;
      if (dateString.length === VALID_DATE_STRING_LENGTH) {
        isValidDate = (0, _moment.default)(dateString).isValid(_mlDateUtils.TIME_FORMAT, true);
      } else {
        this.setState({
          endDateString: dateString
        });
      }
      if (isValidDate) {
        this.setState({
          endDateString: dateString,
          endDate: (0, _moment.default)(dateString)
        });
      }
    });
    (0, _defineProperty2.default)(this, "renderRangedDatePicker", () => {
      const {
        startDate,
        endDate,
        startDateString,
        endDateString
      } = this.state;
      const timeInputs = /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.calendarsEdit.newEventModal.fromLabel",
          defaultMessage: "From:",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 178,
            columnNumber: 17
          }
        }),
        helpText: _mlDateUtils.TIME_FORMAT,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        name: "startTime",
        onChange: this.handleTimeStartChange,
        placeholder: _mlDateUtils.TIME_FORMAT,
        value: startDateString,
        "data-test-subj": "mlCalendarEventStartDateInput",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 15
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 194,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.calendarsEdit.newEventModal.toLabel",
          defaultMessage: "To:",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 197,
            columnNumber: 17
          }
        }),
        helpText: _mlDateUtils.TIME_FORMAT,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 195,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        name: "endTime",
        onChange: this.handleTimeEndChange,
        placeholder: _mlDateUtils.TIME_FORMAT,
        value: endDateString,
        "data-test-subj": "mlCalendarEventEndDateInput",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 15
        }
      })))));
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 218,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 9
        }
      }), timeInputs, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 221,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 222,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePickerRange, {
        inline: true,
        css: (0, _react2.css)`
              @media (min-width: ${INLINE_DATE_PICKER_RANGE_WIDTH}px) {
                inline-size: ${INLINE_DATE_PICKER_RANGE_WIDTH}px;
                max-inline-size: 100%;
              }
            `,
        startDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
          selected: startDate,
          onChange: this.handleChangeStart,
          startDate: startDate,
          endDate: endDate,
          isInvalid: startDate > endDate,
          "aria-label": _i18n.i18n.translate('xpack.ml.calendarsEdit.newEventModal.startDateAriaLabel', {
            defaultMessage: 'Start date'
          }),
          timeFormat: _mlDateUtils.TIME_FORMAT,
          dateFormat: _mlDateUtils.TIME_FORMAT,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 232,
            columnNumber: 15
          }
        }),
        endDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
          selected: endDate,
          onChange: this.handleChangeEnd,
          startDate: startDate,
          endDate: endDate,
          isInvalid: startDate > endDate,
          "aria-label": _i18n.i18n.translate('xpack.ml.calendarsEdit.newEventModal.endDateAriaLabel', {
            defaultMessage: 'End date'
          }),
          timeFormat: _mlDateUtils.TIME_FORMAT,
          dateFormat: _mlDateUtils.TIME_FORMAT,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 249,
            columnNumber: 15
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 223,
          columnNumber: 11
        }
      })));
    });
    const _startDate = (0, _moment.default)().startOf('day');
    const _endDate = (0, _moment.default)().startOf('day').add(1, 'days');
    this.state = {
      startDate: _startDate,
      endDate: _endDate,
      description: '',
      descriptionVisited: false,
      startDateString: _startDate.format(_mlDateUtils.TIME_FORMAT),
      endDateString: _endDate.format(_mlDateUtils.TIME_FORMAT)
    };
  }
  render() {
    const {
      closeModal
    } = this.props;
    const {
      description,
      descriptionVisited
    } = this.state;
    const isDescriptionInvalid = !description.trim();
    const isDescriptionInvalidVisible = isDescriptionInvalid && descriptionVisited;
    const modalTitleId = (0, _eui.htmlIdGenerator)()('modalTitle');
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: closeModal,
      initialFocus: "[name=eventDescription]",
      maxWidth: false,
      "data-test-subj": 'mlCalendarEventForm',
      "aria-labelledby": modalTitleId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 285,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: modalTitleId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.newEventModal.createNewEventTitle",
      defaultMessage: "Create new event",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 295,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.calendarsEdit.newEventModal.descriptionLabel",
        defaultMessage: "Description",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 298,
          columnNumber: 19
        }
      }),
      fullWidth: true,
      error: _i18n.i18n.translate('xpack.ml.calendarsEdit.newEventModal.descriptionError', {
        defaultMessage: 'Description cannot be empty'
      }),
      isInvalid: isDescriptionInvalidVisible,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 296,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      name: "eventDescription",
      onBlur: this.onDescriptionBlur,
      onChange: this.onDescriptionChange,
      isInvalid: isDescriptionInvalidVisible,
      fullWidth: true,
      "data-test-subj": 'mlCalendarEventDescriptionInput',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 309,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 319,
        columnNumber: 15
      }
    }), this.renderRangedDatePicker())), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 325,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: closeModal,
      "data-test-subj": 'mlCalendarCancelEventButton',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 326,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.newEventModal.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 327,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.handleAddEvent,
      fill: true,
      disabled: isDescriptionInvalid,
      "data-test-subj": 'mlCalendarAddEventButton',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 332,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.newEventModal.addButtonLabel",
      defaultMessage: "Add",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 338,
        columnNumber: 15
      }
    })))));
  }
}
exports.NewEventModal = NewEventModal;
(0, _defineProperty2.default)(NewEventModal, "propTypes", {
  closeModal: _propTypes.PropTypes.func.isRequired,
  addEvent: _propTypes.PropTypes.func.isRequired
});