"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleMetricDetectors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _kibana = require("../../../../../../../contexts/kibana");
var _job_creator_context = require("../../../job_creator_context");
var _agg_select = require("../agg_select");
var _new_job_capabilities_service = require("../../../../../../../services/new_job_capabilities/new_job_capabilities_service");
var _fields_utils = require("../../../../../../../../../common/util/fields_utils");
var _anomaly_chart = require("../../../charts/anomaly_chart");
var _settings = require("../../../charts/common/settings");
var _toast_notification_service = require("../../../../../../../services/toast_notification_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/single_metric_view/metric_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DTR_IDX = 0;
const SingleMetricDetectors = ({
  setIsValid
}) => {
  const uiSettings = (0, _kibana.useUiSettings)();
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated,
    chartLoader,
    chartInterval
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const newJobCapsService = (0, _new_job_capabilities_service.useNewJobCapsService)();
  const fields = (0, _react.useMemo)(() => (0, _fields_utils.sortFields)([...newJobCapsService.fields, ...jobCreator.runtimeFields]),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)(jobCreator.aggFieldPair !== null ? [{
    label: (0, _agg_select.createLabel)(jobCreator.aggFieldPair)
  }] : []);
  const [aggFieldPair, setAggFieldPair] = (0, _react.useState)(jobCreator.aggFieldPair);
  const [lineChartsData, setLineChartData] = (0, _react.useState)({});
  const [loadingData, setLoadingData] = (0, _react.useState)(false);
  const [start, setStart] = (0, _react.useState)(jobCreator.start);
  const [end, setEnd] = (0, _react.useState)(jobCreator.end);
  const [bucketSpanMs, setBucketSpanMs] = (0, _react.useState)(jobCreator.bucketSpanMs);
  function detectorChangeHandler(selectedOptionsIn) {
    setSelectedOptions(selectedOptionsIn);
    if (selectedOptionsIn.length) {
      const option = selectedOptionsIn[0];
      if (typeof option !== 'undefined' && (0, _mlIsPopulatedObject.isPopulatedObject)(option, ['agg', 'field'])) {
        setAggFieldPair({
          agg: option.agg,
          field: option.field,
          by: {
            field: null,
            value: null
          }
        });
      } else {
        setAggFieldPair(null);
      }
    }
  }
  (0, _react.useEffect)(() => {
    if (aggFieldPair !== null) {
      jobCreator.setDetector(aggFieldPair.agg, aggFieldPair.field);
      jobCreatorUpdate();
      loadChart();
      setIsValid(aggFieldPair !== null);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreator, aggFieldPair]);
  (0, _react.useEffect)(() => {
    if (jobCreator.start !== start || jobCreator.end !== end) {
      setStart(jobCreator.start);
      setEnd(jobCreator.end);
      loadChart();
    }
    if (jobCreator.bucketSpanMs !== bucketSpanMs) {
      setBucketSpanMs(jobCreator.bucketSpanMs);
      loadChart();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreator, jobCreatorUpdated]);
  async function loadChart() {
    if (aggFieldPair !== null) {
      setLoadingData(true);
      try {
        const cs = (0, _settings.getChartSettings)(uiSettings, jobCreator, chartInterval);
        const resp = await chartLoader.loadLineCharts(jobCreator.start, jobCreator.end, [aggFieldPair], null, null, cs.intervalMs, jobCreator.runtimeMappings, jobCreator.datafeedConfig.indices_options);
        if (resp[DTR_IDX] !== undefined) {
          setLineChartData(resp);
        }
      } catch (error) {
        toastNotificationService.displayErrorToast(error);
        setLineChartData({});
      }
      setLoadingData(false);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    fields: fields,
    changeHandler: detectorChangeHandler,
    selectedOptions: selectedOptions,
    removeOptions: [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }), (lineChartsData[DTR_IDX] !== undefined || loadingData === true) && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_anomaly_chart.AnomalyChart, {
    chartType: _anomaly_chart.CHART_TYPE.LINE,
    chartData: lineChartsData[DTR_IDX],
    modelData: [],
    anomalyData: [],
    height: "300px",
    width: "100%",
    loading: loadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  })));
};
exports.SingleMetricDetectors = SingleMetricDetectors;