"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategorizationExamplesLoader = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _mlCategoryValidator = require("@kbn/ml-category-validator");
var _new_job = require("../../../../../../common/constants/new_job");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CategorizationExamplesLoader {
  constructor(jobCreator, indexPattern, query) {
    (0, _defineProperty2.default)(this, "_jobCreator", void 0);
    (0, _defineProperty2.default)(this, "_indexPatternTitle", '');
    (0, _defineProperty2.default)(this, "_timeFieldName", '');
    (0, _defineProperty2.default)(this, "_query", {});
    this._jobCreator = jobCreator;
    this._indexPatternTitle = indexPattern.title;
    this._query = query;
    if (typeof indexPattern.timeFieldName === 'string') {
      this._timeFieldName = indexPattern.timeFieldName;
    }
  }
  async loadExamples() {
    var _this$_jobCreator$run;
    const analyzer = this._jobCreator.categorizationAnalyzer;
    const categorizationFieldName = this._jobCreator.categorizationFieldName;
    if (categorizationFieldName === null) {
      return {
        examples: [],
        sampleSize: 0,
        overallValidStatus: _mlCategoryValidator.CATEGORY_EXAMPLES_VALIDATION_STATUS.INVALID,
        validationChecks: []
      };
    }
    const resp = await this._jobCreator.mlApi.jobs.categorizationFieldExamples(this._indexPatternTitle, this._query, _new_job.NUMBER_OF_CATEGORY_EXAMPLES, categorizationFieldName, this._timeFieldName, this._jobCreator.start, this._jobCreator.end, analyzer, (_this$_jobCreator$run = this._jobCreator.runtimeMappings) !== null && _this$_jobCreator$run !== void 0 ? _this$_jobCreator$run : undefined, this._jobCreator.datafeedConfig.indices_options);
    return resp;
  }
}
exports.CategorizationExamplesLoader = CategorizationExamplesLoader;