"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSideNavItems = useSideNavItems;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _constants = require("@kbn/aiops-change-point-detection/constants");
var _mlUrlState = require("@kbn/ml-url-state");
var _kibana = require("../../contexts/kibana");
var _license = require("../../license");
var _locator = require("../../../../common/constants/locator");
var _ml = require("../../contexts/ml");
var _check_capabilities = require("../../capabilities/check_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSideNavItems(activeRoute) {
  const mlLocator = (0, _kibana.useMlLocator)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const mlFeaturesDisabled = !(0, _license.isFullLicense)();
  const {
    isADEnabled,
    isDFAEnabled
  } = (0, _ml.useEnabledFeatures)();
  const [canUseAiops] = (0, _check_capabilities.usePermissionCheck)(['canUseAiops']);
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  const pageState = (0, _react.useMemo)(() => {
    return (globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== undefined ? {
      globalState: {
        refreshInterval: globalState.refreshInterval
      }
    } : undefined;
  }, [globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval]);
  const redirectToTab = (0, _react.useCallback)(async defaultPathId => {
    const path = await mlLocator.getUrl({
      page: defaultPathId,
      // only retain the refreshInterval part of globalState
      // appState will not be considered.
      pageState
    });
    await navigateToPath(path, false);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [pageState]);
  const tabsDefinition = (0, _react.useMemo)(() => {
    const disableLinks = mlFeaturesDisabled;
    const mlTabs = [{
      id: 'main_section',
      name: '',
      items: [{
        id: 'overview',
        pathId: _locator.ML_PAGES.OVERVIEW,
        name: _i18n.i18n.translate('xpack.ml.navMenu.overviewTabLinkText', {
          defaultMessage: 'Overview'
        }),
        disabled: disableLinks,
        testSubj: 'mlMainTab overview'
      }, {
        id: 'datavisualizer',
        name: _i18n.i18n.translate('xpack.ml.navMenu.dataVisualizerTabLinkText', {
          defaultMessage: 'Data Visualizer'
        }),
        disabled: false,
        pathId: _locator.ML_PAGES.DATA_VISUALIZER,
        testSubj: 'mlMainTab dataVisualizer'
      }]
    }, ...(isADEnabled ? [{
      id: 'anomaly_detection_section',
      name: _i18n.i18n.translate('xpack.ml.navMenu.anomalyDetectionTabLinkText', {
        defaultMessage: 'Anomaly Detection'
      }),
      disabled: disableLinks || !isADEnabled,
      items: [{
        id: 'anomaly_explorer',
        name: _i18n.i18n.translate('xpack.ml.navMenu.anomalyDetection.anomalyExplorerText', {
          defaultMessage: 'Anomaly Explorer'
        }),
        disabled: disableLinks || !isADEnabled,
        pathId: _locator.ML_PAGES.ANOMALY_EXPLORER,
        testSubj: 'mlMainTab anomalyExplorer'
      }, {
        id: 'single_metric_viewer',
        name: _i18n.i18n.translate('xpack.ml.navMenu.anomalyDetection.singleMetricViewerText', {
          defaultMessage: 'Single Metric Viewer'
        }),
        pathId: _locator.ML_PAGES.SINGLE_METRIC_VIEWER,
        disabled: disableLinks || !isADEnabled,
        testSubj: 'mlMainTab singleMetricViewer'
      }]
    }] : []), ...(isDFAEnabled ? [{
      id: 'data_frame_analytics_section',
      name: _i18n.i18n.translate('xpack.ml.navMenu.dataFrameAnalyticsTabLinkText', {
        defaultMessage: 'Data Frame Analytics'
      }),
      disabled: disableLinks || !isDFAEnabled,
      items: [{
        id: 'data_frame_analytics_results_explorer',
        pathId: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION,
        name: _i18n.i18n.translate('xpack.ml.navMenu.dataFrameAnalytics.resultsExplorerText', {
          defaultMessage: 'Results Explorer'
        }),
        disabled: disableLinks || !isDFAEnabled,
        testSubj: 'mlMainTab dataFrameAnalyticsResultsExplorer'
      }, {
        id: 'data_frame_analytics_job_map',
        pathId: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_MAP,
        name: _i18n.i18n.translate('xpack.ml.navMenu.dataFrameAnalytics.analyticsMapText', {
          defaultMessage: 'Analytics Map'
        }),
        disabled: disableLinks || !isDFAEnabled,
        testSubj: 'mlMainTab dataFrameAnalyticsMap'
      }]
    }] : [])];
    if (canUseAiops === false) {
      return mlTabs;
    }
    mlTabs.push({
      id: 'aiops_section',
      name: _i18n.i18n.translate('xpack.ml.navMenu.aiopsTabLinkText', {
        defaultMessage: 'AIOps Labs'
      }),
      disabled: disableLinks,
      items: [{
        id: 'logRateAnalysis',
        pathId: _locator.ML_PAGES.AIOPS_LOG_RATE_ANALYSIS_INDEX_SELECT,
        name: _i18n.i18n.translate('xpack.ml.navMenu.logRateAnalysisLinkText', {
          defaultMessage: 'Log Rate Analysis'
        }),
        disabled: disableLinks,
        testSubj: 'mlMainTab logRateAnalysis',
        relatedRouteIds: ['log_rate_analysis']
      }, {
        id: 'logCategorization',
        pathId: _locator.ML_PAGES.AIOPS_LOG_CATEGORIZATION_INDEX_SELECT,
        name: _i18n.i18n.translate('xpack.ml.navMenu.logCategorizationLinkText', {
          defaultMessage: 'Log Pattern Analysis'
        }),
        disabled: disableLinks,
        testSubj: 'mlMainTab logCategorization',
        relatedRouteIds: ['log_categorization']
      }, ...(_constants.CHANGE_POINT_DETECTION_ENABLED ? [{
        id: 'changePointDetection',
        pathId: _locator.ML_PAGES.AIOPS_CHANGE_POINT_DETECTION_INDEX_SELECT,
        name: _i18n.i18n.translate('xpack.ml.navMenu.changePointDetectionLinkText', {
          defaultMessage: 'Change Point Detection'
        }),
        disabled: disableLinks,
        testSubj: 'mlMainTab changePointDetection',
        relatedRouteIds: ['change_point_detection']
      }] : [])]
    });
    return mlTabs;
  }, [mlFeaturesDisabled, isADEnabled, isDFAEnabled, canUseAiops]);
  const getTabItem = (0, _react.useCallback)(tab => {
    const {
      id,
      disabled,
      items,
      onClick,
      pathId,
      name,
      testSubj,
      highlightNestedRoutes,
      relatedRouteIds
    } = tab;
    const onClickCallback = onClick !== null && onClick !== void 0 ? onClick : pathId ? redirectToTab.bind(null, pathId) : undefined;
    const isSelected = `/${pathId}` === (activeRoute === null || activeRoute === void 0 ? void 0 : activeRoute.path) || !!highlightNestedRoutes && (activeRoute === null || activeRoute === void 0 ? void 0 : activeRoute.path.includes(`${pathId}/`)) || Array.isArray(relatedRouteIds) && relatedRouteIds.includes(activeRoute === null || activeRoute === void 0 ? void 0 : activeRoute.id);
    return {
      id,
      name,
      isSelected,
      disabled,
      ...(onClickCallback ? {
        onClick: onClickCallback
      } : {}),
      'data-test-subj': testSubj + (isSelected ? ' selected' : ''),
      items: items ? items.map(getTabItem) : undefined,
      forceOpen: true
    };
  }, [activeRoute, redirectToTab]);
  return (0, _react.useMemo)(() => tabsDefinition.map(getTabItem), [tabsDefinition, getTabItem]);
}