"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterByMapExtentAction = void 0;
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var _is_legacy_map = require("../../legacy_visualizations/is_legacy_map");
var _kibana_services = require("../../kibana_services");
var _constants2 = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/trigger_actions/filter_by_map_extent/action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getContainerLabel(api) {
  var _parentApi;
  return (api === null || api === void 0 ? void 0 : (_parentApi = api.parentApi) === null || _parentApi === void 0 ? void 0 : _parentApi.type) === 'dashboard' ? _i18n.i18n.translate('xpack.maps.filterByMapExtentMenuItem.dashboardLabel', {
    defaultMessage: 'dashboard'
  }) : _i18n.i18n.translate('xpack.maps.filterByMapExtentMenuItem.pageLabel', {
    defaultMessage: 'page'
  });
}
function getDisplayName(api) {
  return _i18n.i18n.translate('xpack.maps.filterByMapExtentMenuItem.displayName', {
    defaultMessage: 'Filter {containerLabel} by map bounds',
    values: {
      containerLabel: getContainerLabel(api)
    }
  });
}
const filterByMapExtentAction = exports.filterByMapExtentAction = (0, _public.createAction)({
  id: _constants2.FILTER_BY_MAP_EXTENT,
  type: _constants2.FILTER_BY_MAP_EXTENT,
  order: 20,
  getDisplayName: ({
    embeddable
  }) => getDisplayName(embeddable),
  getDisplayNameTooltip: ({
    embeddable
  }) => _i18n.i18n.translate('xpack.maps.filterByMapExtentMenuItem.displayNameTooltip', {
    defaultMessage: 'As you zoom and pan the map, the {containerLabel} updates to display only the data visible in the map bounds.',
    values: {
      containerLabel: getContainerLabel(embeddable)
    }
  }),
  getIconType: () => 'filter',
  isCompatible: async ({
    embeddable
  }) => {
    return !(0, _presentationPublishing.areTriggersDisabled)(embeddable) && ((0, _presentationPublishing.apiIsOfType)(embeddable, _constants.MAP_SAVED_OBJECT_TYPE) || (0, _public2.apiHasVisualizeConfig)(embeddable) && (0, _is_legacy_map.isLegacyMapApi)(embeddable));
  },
  execute: async ({
    embeddable
  }) => {
    const core = (0, _kibana_services.getCore)();
    const LazyModal = /*#__PURE__*/(0, _react.lazy)(async () => {
      const {
        FilterByMapExtentModal
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./modal')));
      return {
        default: FilterByMapExtentModal
      };
    });
    const overlayRef = core.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 15
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(LazyModal, {
      onClose: () => overlayRef.close(),
      title: getDisplayName(embeddable),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    })), core));
  }
});