"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerWizardSelect = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _layers = require("../../../classes/layers");
var _constants = require("../../../../common/constants");
require("./layer_wizard_select.scss");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/add_layer_panel/flyout_body/layer_wizard_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getCategoryLabel(category) {
  if (category === _constants.LAYER_WIZARD_CATEGORY.ELASTICSEARCH) {
    return _i18n.i18n.translate('xpack.maps.layerWizardSelect.elasticsearchCategoryLabel', {
      defaultMessage: 'Elasticsearch'
    });
  }
  if (category === _constants.LAYER_WIZARD_CATEGORY.REFERENCE) {
    return _i18n.i18n.translate('xpack.maps.layerWizardSelect.referenceCategoryLabel', {
      defaultMessage: 'Reference'
    });
  }
  if (category === _constants.LAYER_WIZARD_CATEGORY.SOLUTIONS) {
    return _i18n.i18n.translate('xpack.maps.layerWizardSelect.solutionsCategoryLabel', {
      defaultMessage: 'Solutions'
    });
  }
  throw new Error(`Unexpected category: ${category}`);
}
class LayerWizardSelect extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      activeCategories: [],
      hasLoadedWizards: false,
      layerWizards: [],
      selectedCategory: null
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadLayerWizards();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadLayerWizards() {
    const layerWizards = await (0, _layers.getLayerWizards)();
    const activeCategories = [];
    layerWizards.forEach(layerWizard => {
      layerWizard.categories.forEach(category => {
        if (!activeCategories.includes(category)) {
          activeCategories.push(category);
        }
      });
    });
    if (this._isMounted) {
      this.setState({
        activeCategories,
        layerWizards,
        hasLoadedWizards: true
      });
    }
  }
  _filterByCategory(category) {
    this.setState({
      selectedCategory: category
    });
  }
  _renderCategoryFacets() {
    if (this.state.activeCategories.length === 0) {
      return null;
    }
    const facets = this.state.activeCategories.map(category => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFacetButton, {
        key: category,
        isSelected: category === this.state.selectedCategory,
        onClick: () => this._filterByCategory(category),
        minWidth: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 9
        }
      }, getCategoryLabel(category));
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFacetGroup, {
      layout: "horizontal",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFacetButton, {
      key: "all",
      isSelected: !this.state.selectedCategory,
      onClick: () => this._filterByCategory(null),
      minWidth: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerWizardSelect.allCategories",
      defaultMessage: "All",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 11
      }
    })), facets);
  }
  render() {
    if (!this.state.hasLoadedWizards) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 2,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 11
        }
      }));
    }
    const wizardCards = this.state.layerWizards.filter(layerWizard => {
      return this.state.selectedCategory ? layerWizard.categories.includes(this.state.selectedCategory) : true;
    }).map(layerWizard => {
      const icon = layerWizard.icon ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: layerWizard.icon,
        size: "l",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 41
        }
      }) : undefined;
      const onClick = () => {
        this.props.onSelect(layerWizard);
      };
      const card = /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
        title: layerWizard.title,
        titleSize: "xs",
        betaBadgeProps: {
          label: layerWizard.isBeta ? _i18n.i18n.translate('xpack.maps.layerWizardSelect.technicalPreviewLabel', {
            defaultMessage: 'Technical preview'
          }) : ''
        },
        icon: icon,
        onClick: onClick,
        description: layerWizard.description,
        isDisabled: layerWizard.isDisabled,
        "data-test-subj": _lodash.default.camelCase(layerWizard.title),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 11
        }
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: layerWizard.title,
        component: "li",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 11
        }
      }, layerWizard.isDisabled && layerWizard.disabledReason ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        anchorClassName: "mapMapLayerWizardSelect__tooltip",
        content: layerWizard.disabledReason,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 15
        }
      }, card) : card);
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this._renderCategoryFacets(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      columns: 2,
      gutterSize: "m",
      component: "ul",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 9
      }
    }, wizardCards));
  }
}
exports.LayerWizardSelect = LayerWizardSelect;