"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _elastic_elk_b = _interopRequireDefault(require("./elastic_elk_b.png"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/easteregg/bee.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Bee() {
  const [position, setPosition] = (0, _react.useState)({
    top: 50 + Math.random() * 100,
    left: 50 + Math.random() * 50,
    vX: 3 + Math.random(),
    vY: 0.5 + Math.random() * 0.5
  });
  (0, _react.useEffect)(() => {
    let handle = 0;
    function tick() {
      handle = requestAnimationFrame(() => {
        setPosition(({
          top,
          left,
          vX,
          vY
        }) => {
          let newVx = vX + Math.random() * 0.5 - 0.25;
          let newVy = vY + Math.random() - 0.5;
          if (top < 50) {
            newVy = Math.abs(newVy);
          }
          if (top > window.innerHeight - 300) {
            newVy = -1 * Math.abs(newVy);
          }
          if (left < 50) {
            newVx = Math.abs(newVx);
          }
          if (left > window.innerWidth - 300) {
            newVx = -1 * Math.abs(newVx);
          }
          return {
            top: top + vY,
            left: left + vX,
            vX: newVx,
            vY: newVy
          };
        });
        tick();
      });
    }
    tick();
    return () => {
      cancelAnimationFrame(handle);
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement("img", {
    src: _elastic_elk_b.default,
    alt: "ELK-Bee",
    title: "Bzzzzzzz",
    style: {
      position: 'absolute',
      width: '80px',
      height: 'auto',
      transform: position.vX > 0 ? 'scale(-1, 1)' : undefined,
      top: position.top,
      left: position.left,
      zIndex: 999
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  });
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = Bee;
module.exports = exports.default;