"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFiberType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Get the display name of a {@link ReactFiberNode React Fiber node}.
 * @param {ReactFiberNode} fiber {@link ReactFiberNode React Fiber node} to get the display name for.
 * @return {string | null} The display name of the {@link ReactFiberNode React Fiber node}, or null if it cannot be determined.
 */
const getFiberType = fiber => {
  var _fiber$type, _fiber$type3;
  if (typeof fiber.type === 'string') {
    return fiber.type;
  } else if (typeof ((_fiber$type = fiber.type) === null || _fiber$type === void 0 ? void 0 : _fiber$type.name) === 'string') {
    var _fiber$type2;
    return (_fiber$type2 = fiber.type) === null || _fiber$type2 === void 0 ? void 0 : _fiber$type2.name;
  } else if (typeof ((_fiber$type3 = fiber.type) === null || _fiber$type3 === void 0 ? void 0 : _fiber$type3.displayName) === 'string') {
    var _fiber$type4;
    return (_fiber$type4 = fiber.type) === null || _fiber$type4 === void 0 ? void 0 : _fiber$type4.displayName;
  } else if (typeof (fiber === null || fiber === void 0 ? void 0 : fiber.elementType) === 'string') {
    return fiber === null || fiber === void 0 ? void 0 : fiber.elementType;
  }
  return null;
};
exports.getFiberType = getFiberType;