"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogFlyout = exports.useLogEntryFlyoutContext = exports.WithFlyoutOptionsUrlState = exports.LogFlyout = exports.LogEntryFlyoutProvider = exports.FlyoutVisibility = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _url_state = require("../../utils/url_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/containers/logs/log_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let FlyoutVisibility = exports.FlyoutVisibility = /*#__PURE__*/function (FlyoutVisibility) {
  FlyoutVisibility["hidden"] = "hidden";
  FlyoutVisibility["visible"] = "visible";
  return FlyoutVisibility;
}({});
const useLogFlyout = () => {
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react.useState)(false);
  const [logEntryId, setLogEntryId] = (0, _react.useState)(null);
  const [surroundingLogsId, setSurroundingLogsId] = (0, _react.useState)(null);
  const closeFlyout = (0, _react.useCallback)(() => setIsFlyoutOpen(false), []);
  const openFlyout = (0, _react.useCallback)(newLogEntryId => {
    if (newLogEntryId) {
      setLogEntryId(newLogEntryId);
    }
    setIsFlyoutOpen(true);
  }, []);
  return {
    isFlyoutOpen,
    closeFlyout,
    openFlyout,
    logEntryId,
    setLogEntryId,
    surroundingLogsId,
    setSurroundingLogsId
  };
};
exports.useLogFlyout = useLogFlyout;
const LogFlyout = exports.LogFlyout = (0, _constate.default)(useLogFlyout);
const [LogEntryFlyoutProvider, useLogEntryFlyoutContext] = LogFlyout;
exports.useLogEntryFlyoutContext = useLogEntryFlyoutContext;
exports.LogEntryFlyoutProvider = LogEntryFlyoutProvider;
const WithFlyoutOptionsUrlState = () => {
  const {
    isFlyoutOpen,
    openFlyout,
    closeFlyout,
    logEntryId,
    setLogEntryId,
    surroundingLogsId,
    setSurroundingLogsId
  } = useLogEntryFlyoutContext();
  return /*#__PURE__*/_react.default.createElement(_url_state.UrlStateContainer, {
    urlState: {
      flyoutVisibility: isFlyoutOpen ? FlyoutVisibility.visible : FlyoutVisibility.hidden,
      flyoutId: logEntryId,
      surroundingLogsId
    },
    urlStateKey: "flyoutOptions",
    mapToUrlState: mapToUrlState,
    onChange: newUrlState => {
      if (newUrlState && newUrlState.flyoutId) {
        setLogEntryId(newUrlState.flyoutId);
      }
      if (newUrlState && newUrlState.surroundingLogsId) {
        setSurroundingLogsId(newUrlState.surroundingLogsId);
      }
      if (newUrlState && newUrlState.flyoutVisibility === FlyoutVisibility.visible) {
        openFlyout();
      }
      if (newUrlState && newUrlState.flyoutVisibility === FlyoutVisibility.hidden) {
        closeFlyout();
      }
    },
    onInitialize: initialUrlState => {
      if (initialUrlState && initialUrlState.flyoutId) {
        setLogEntryId(initialUrlState.flyoutId);
      }
      if (initialUrlState && initialUrlState.surroundingLogsId) {
        setSurroundingLogsId(initialUrlState.surroundingLogsId);
      }
      if (initialUrlState && initialUrlState.flyoutVisibility === FlyoutVisibility.visible) {
        openFlyout();
      }
      if (initialUrlState && initialUrlState.flyoutVisibility === FlyoutVisibility.hidden) {
        closeFlyout();
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  });
};
exports.WithFlyoutOptionsUrlState = WithFlyoutOptionsUrlState;
const mapToUrlState = value => value ? {
  flyoutId: mapToFlyoutIdState(value.flyoutId),
  flyoutVisibility: mapToFlyoutVisibilityState(value.flyoutVisibility),
  surroundingLogsId: mapToSurroundingLogsIdState(value.surroundingLogsId)
} : undefined;
const mapToFlyoutIdState = subject => {
  return subject && (0, _lodash.isString)(subject) ? subject : undefined;
};
const mapToSurroundingLogsIdState = subject => {
  return subject && (0, _lodash.isString)(subject) ? subject : undefined;
};
const mapToFlyoutVisibilityState = subject => {
  if (subject) {
    if (subject === 'visible') {
      return FlyoutVisibility.visible;
    }
    if (subject === 'hidden') {
      return FlyoutVisibility.hidden;
    }
  }
};