"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMetricThresholdAlertPrefill = void 0;
var _lodash = require("lodash");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMetricThresholdAlertPrefill = () => {
  const [prefillOptionsState, setPrefillOptionsState] = (0, _react.useState)({
    groupBy: undefined,
    filterQuery: undefined,
    metrics: []
  });
  const {
    groupBy,
    filterQuery,
    metrics
  } = prefillOptionsState;
  return {
    groupBy,
    filterQuery,
    metrics,
    setPrefillOptions(newState) {
      if (!(0, _lodash.isEqual)(newState, prefillOptionsState)) setPrefillOptionsState(newState);
    }
  };
};
exports.useMetricThresholdAlertPrefill = useMetricThresholdAlertPrefill;